/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import com.mekeng.github.common.me.data.IAEGasStack;
import com.mekeng.github.common.me.data.impl.AEGasStack;
import com.mekeng.github.common.me.storage.IGasStorageChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileFluidPacketDecoder
extends AENetworkTile
implements IGridTickable,
IAEAppEngInventory {
    private final AppEngInternalInventory inventory = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final IActionSource ownActionSource = new MachineSource((IActionHost)this);

    public TileFluidPacketDecoder() {
        this.getProxy().setIdlePowerUsage(1.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public boolean canBeRotated() {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return null;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(5, 120, false, true);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_77973_b() == FCItems.FLUID_PACKET) {
            IMEMonitor fluidGrid;
            FluidStack fluid = (FluidStack)FakeItemRegister.getStack(stack);
            if (fluid == null || fluid.amount <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                return TickRateModulation.SLEEP;
            }
            AEFluidStack aeFluid = AEFluidStack.fromFluidStack((FluidStack)fluid);
            IEnergyGrid energyGrid = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
            IAEFluidStack remaining = (IAEFluidStack)Platform.poweredInsert((IEnergySource)energyGrid, (IMEInventory)(fluidGrid = ((IStorageGrid)node.getGrid().getCache(IStorageGrid.class)).getInventory(Util.getFluidChannel())), (IAEStack)aeFluid, (IActionSource)this.ownActionSource);
            if (remaining != null) {
                if (remaining.getStackSize() == aeFluid.getStackSize()) {
                    return TickRateModulation.SLOWER;
                }
                this.inventory.setStackInSlot(0, FakeFluids.packFluid2Packet(remaining.getFluidStack()));
                return TickRateModulation.FASTER;
            }
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            return TickRateModulation.SLEEP;
        }
        if (ModAndClassUtil.GAS && stack.func_77973_b() == FCGasItems.GAS_PACKET) {
            IMEMonitor gasGrid;
            GasStack gas = (GasStack)FakeItemRegister.getStack(stack);
            if (gas == null || gas.getGas() == null || gas.amount <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                return TickRateModulation.SLEEP;
            }
            AEGasStack aeGas = AEGasStack.of((GasStack)gas);
            IEnergyGrid energyGrid = (IEnergyGrid)node.getGrid().getCache(IEnergyGrid.class);
            IAEStack remaining = Platform.poweredInsert((IEnergySource)energyGrid, (IMEInventory)(gasGrid = ((IStorageGrid)node.getGrid().getCache(IStorageGrid.class)).getInventory(AEApi.instance().storage().getStorageChannel(IGasStorageChannel.class))), (IAEStack)aeGas, (IActionSource)this.ownActionSource);
            if (remaining != null) {
                if (remaining.getStackSize() == aeGas.getStackSize()) {
                    return TickRateModulation.SLOWER;
                }
                this.inventory.setStackInSlot(0, FakeGases.packGas2Packet(((IAEGasStack)remaining).getGasStack()));
                return TickRateModulation.FASTER;
            }
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            return TickRateModulation.SLEEP;
        }
        return TickRateModulation.SLEEP;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.inventory.writeToNBT(data, "Inventory");
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.inventory.readFromNBT(data, "Inventory");
    }
}

