/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.tile.grid.AENetworkInvTile;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.component.DualityDualInterface;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.interfaces.FCPriorityHost;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.loader.FCBlocks;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class TileDualInterface
extends AENetworkInvTile
implements IGridTickable,
IInventoryDestination,
IInterfaceHost,
FCPriorityHost,
IFluidInterfaceHost {
    protected final DualityDualInterface<TileDualInterface> duality = this.createDuality();
    protected boolean omniDirectional = true;

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.duality.onChannelStateChange(c);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.duality.onPowerStateChange(c);
    }

    protected DualityDualInterface createDuality() {
        return new DualityDualInterface<TileDualInterface>(this.getProxy(), this);
    }

    public void setSide(EnumFacing facing) {
        EnumFacing newForward;
        if (Platform.isClient()) {
            return;
        }
        if (!this.omniDirectional && this.getForward() == facing.func_176734_d()) {
            newForward = facing;
        } else if (!(this.omniDirectional || this.getForward() != facing && this.getForward() != facing.func_176734_d())) {
            newForward = facing;
            this.omniDirectional = true;
        } else if (this.omniDirectional) {
            newForward = facing.func_176734_d();
            this.omniDirectional = false;
        } else {
            newForward = Platform.rotateAround((EnumFacing)this.getForward(), (EnumFacing)facing);
        }
        if (this.omniDirectional) {
            this.setOrientation(EnumFacing.NORTH, EnumFacing.UP);
        } else {
            EnumFacing newUp = EnumFacing.UP;
            if (newForward == EnumFacing.UP || newForward == EnumFacing.DOWN) {
                newUp = EnumFacing.NORTH;
            }
            this.setOrientation(newForward, newUp);
        }
        this.configureNodeSides();
        this.markForUpdate();
        this.saveChanges();
    }

    private void configureNodeSides() {
        if (this.omniDirectional) {
            this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
        } else {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        }
    }

    public void getDrops(World w, BlockPos pos, List<ItemStack> drops) {
        this.duality.addDrops(drops);
    }

    public void gridChanged() {
        this.duality.onGridChanged();
    }

    public void onReady() {
        this.configureNodeSides();
        super.onReady();
        this.duality.initialize();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74757_a("omniDirectional", this.omniDirectional);
        this.duality.writeToNBT(data);
        return data;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.omniDirectional = data.func_74767_n("omniDirectional");
        this.duality.readFromNBT(data);
    }

    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean oldOmniDirectional = this.omniDirectional;
        this.omniDirectional = data.readBoolean();
        return oldOmniDirectional != this.omniDirectional || c;
    }

    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.omniDirectional);
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.SMART;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.getTileEntity());
    }

    public boolean canInsert(ItemStack stack) {
        return this.duality.canInsertItem(stack);
    }

    public IItemHandler getInventoryByName(String name) {
        return this.duality.getItemInventoryByName(name);
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return this.duality.getTickingRequest(node);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.duality.onTick(node, ticksSinceLastCall);
    }

    @Nonnull
    public IItemHandler getInternalInventory() {
        return this.duality.getInternalItemInventory();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.duality.onItemInventoryChange(inv, slot, mc, removed, added);
    }

    public void onStackReturnNetwork(IAEFluidStack stack) {
        this.duality.getItemInterface().onStackReturnedToNetwork(FakeFluids.packFluid2AEDrops(stack));
    }

    public void onStackReturnNetwork(IAEItemStack stack) {
        this.duality.getItemInterface().onStackReturnedToNetwork(stack);
    }

    public DualityInterface getInterfaceDuality() {
        return this.duality.getItemInterface();
    }

    public DualityFluidInterface getDualityFluidInterface() {
        return this.duality.getFluidInterface();
    }

    public EnumSet<EnumFacing> getTargets() {
        if (this.omniDirectional) {
            return EnumSet.allOf(EnumFacing.class);
        }
        return EnumSet.of(this.getForward());
    }

    public TileEntity getTileEntity() {
        return this;
    }

    public IConfigManager getConfigManager() {
        return this.duality.getConfigManager();
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.duality.pushPattern(patternDetails, table);
    }

    public boolean isBusy() {
        return this.duality.isCraftingBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.duality.provideCrafting(craftingTracker);
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.duality.getInstalledUpgrades(u);
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.duality.getRequestCraftingJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.duality.injectCraftedItems(link, items, mode);
    }

    public void jobStateChange(ICraftingLink link) {
        this.duality.onCraftingJobStateChange(link);
    }

    public int getPriority() {
        return this.duality.getPriority();
    }

    public void setPriority(int newValue) {
        this.duality.setPriority(newValue);
    }

    public boolean isOmniDirectional() {
        return this.omniDirectional;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.duality.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T capInst = this.duality.getCapability(capability, facing);
        return (T)(capInst != null ? capInst : super.getCapability(capability, facing));
    }

    public ItemStack getItemStackRepresentation() {
        return new ItemStack((Block)FCBlocks.DUAL_INTERFACE);
    }

    @Override
    public GuiType getGuiType() {
        return GuiType.DUAL_ITEM_INTERFACE;
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        NBTTagCompound pre = super.downloadSettings(from);
        NBTTagCompound tag = pre == null ? new NBTTagCompound() : pre;
        tag.func_74782_a("pattern", (NBTBase)this.duality.downloadSettings(from));
        return tag.func_82582_d() ? null : tag;
    }

    public void uploadSettings(SettingsFrom from, NBTTagCompound compound, EntityPlayer player) {
        super.uploadSettings(from, compound, player);
        if (compound.func_74764_b("pattern")) {
            this.duality.uploadSettings(compound.func_74775_l("pattern"), player);
        }
    }
}

