/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.part;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.core.settings.TickRates;
import appeng.fluids.parts.PartSharedFluidBus;
import appeng.helpers.MultiCraftingTracker;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.inventory.FluidConvertingInventoryAdaptor;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PartFluidExportBus
extends PartSharedFluidBus
implements ICraftingRequester {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/fluid_export_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/fluid_export_bus_has_channel")});
    private final IActionSource source;
    private final MultiCraftingTracker craftingTracker = new MultiCraftingTracker((ICraftingRequester)this, 9);

    public PartFluidExportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.CRAFT_ONLY, (Enum)YesNo.NO);
        this.getConfigManager().registerSetting(Settings.SCHEDULING_MODE, (Enum)SchedulingMode.DEFAULT);
        this.source = new MachineSource((IActionHost)this);
    }

    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.craftingTracker.readFromNBT(extra);
    }

    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.craftingTracker.writeToNBT(extra);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        TileEntity te = this.getTile();
        BlockPos tePos = te.func_174877_v();
        if (Platform.isServer()) {
            InventoryHandler.openGui(player, te.func_145831_w(), tePos, this.getSide().getFacing(), GuiType.FLUID_EXPORT_BUS);
        }
        return true;
    }

    @Nonnull
    public TickingRequest getTickingRequest(@Nonnull IGridNode node) {
        return new TickingRequest(TickRates.FluidExportBus.getMin(), TickRates.FluidExportBus.getMax(), this.isSleeping(), false);
    }

    @Nonnull
    public TickRateModulation tickingRequest(@Nonnull IGridNode node, int ticksSinceLastCall) {
        return this.canDoBusWork() ? this.doBusWork() : TickRateModulation.IDLE;
    }

    protected boolean canDoBusWork() {
        return this.getProxy().isActive();
    }

    private boolean craftOnly() {
        return this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    protected TickRateModulation doBusWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        TileEntity te = this.getConnectedTE();
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            try {
                InventoryAdaptor destination = this.getHandler();
                ICraftingGrid cg = this.getProxy().getCrafting();
                IFluidHandler fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
                IMEMonitor inv = this.getProxy().getStorage().getInventory((IStorageChannel)this.getChannel());
                if (fh != null) {
                    for (int i = 0; i < this.getConfig().getSlots(); ++i) {
                        int wasInserted;
                        IAEFluidStack out;
                        IAEFluidStack fluid = this.getConfig().getFluidInSlot(i);
                        if (fluid == null) continue;
                        boolean isAllowed = true;
                        IAEFluidStack toExtract = fluid.copy();
                        toExtract.setStackSize((long)this.calculateAmountToSend());
                        if (this.craftOnly()) {
                            isAllowed = this.craftingTracker.handleCrafting(i, toExtract.getStackSize(), FakeFluids.packFluid2AEDrops(toExtract), destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.source);
                        }
                        if ((out = (IAEFluidStack)inv.extractItems((IAEStack)toExtract, Actionable.SIMULATE, this.source)) != null && isAllowed && (wasInserted = fh.fill(out.getFluidStack(), true)) > 0) {
                            toExtract.setStackSize((long)wasInserted);
                            inv.extractItems((IAEStack)toExtract, Actionable.MODULATE, this.source);
                            return TickRateModulation.FASTER;
                        }
                        if (!this.isCraftingEnabled()) continue;
                        this.craftingTracker.handleCrafting(i, toExtract.getStackSize(), FakeFluids.packFluid2AEDrops(toExtract), destination, this.getTile().func_145831_w(), this.getProxy().getGrid(), cg, this.source);
                    }
                    return TickRateModulation.SLOWER;
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.SLEEP;
    }

    private boolean isCraftingEnabled() {
        return this.getInstalledUpgrades(Upgrades.CRAFTING) > 0;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox(6.0, 6.0, 15.0, 10.0, 10.0, 16.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Nonnull
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return this.craftingTracker.getRequestedJobs();
    }

    protected InventoryAdaptor getHandler() {
        TileEntity self = this.getHost().getTile();
        TileEntity target = this.getTileEntity(self, self.func_174877_v().func_177972_a(this.getSide().getFacing()));
        return target != null ? FluidConvertingInventoryAdaptor.wrap((ICapabilityProvider)target, this.getSide().getFacing().func_176734_d()) : null;
    }

    private TileEntity getTileEntity(TileEntity self, BlockPos pos) {
        World w = self.func_145831_w();
        return w.func_72863_F().func_186026_b(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) != null ? w.func_175625_s(pos) : null;
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        InventoryAdaptor d = this.getHandler();
        try {
            double power;
            IEnergyGrid energy;
            if (d != null && this.getProxy().isActive() && (energy = this.getProxy().getEnergy()).extractAEPower(power = (double)items.getStackSize(), mode, PowerMultiplier.CONFIG) > power - 0.01) {
                ItemStack remaining;
                ItemStack inputStack = items.getCachedItemStack(items.getStackSize());
                if (mode == Actionable.SIMULATE) {
                    remaining = d.simulateAdd(inputStack);
                    items.setCachedItemStack(inputStack);
                } else {
                    remaining = d.addItems(inputStack);
                    if (!remaining.func_190926_b()) {
                        items.setCachedItemStack(remaining);
                    }
                }
                if (remaining == inputStack) {
                    return items;
                }
                return AEItemStack.fromItemStack((ItemStack)remaining);
            }
        }
        catch (GridAccessException e) {
            AELog.debug((Throwable)e);
        }
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
        this.craftingTracker.jobStateChange(link);
    }
}

