/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.part;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.parts.IPartModel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.core.sync.GuiBridge;
import appeng.items.misc.ItemEncodedPattern;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.PartExpandedProcessingPatternTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemLargeEncodedPattern;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.inventory.ExAppEngInternalInventory;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PartExtendedFluidPatternTerminal
extends PartExpandedProcessingPatternTerminal {
    private boolean combine = false;
    private boolean fluidFirst = false;
    @PartModels
    public static ResourceLocation[] MODELS = new ResourceLocation[]{new ResourceLocation("ae2fc", "part/f_pattern_ex_term_on"), new ResourceLocation("ae2fc", "part/f_pattern_ex_term_off")};
    private static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODELS[0], MODEL_STATUS_ON});
    private static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODELS[1], MODEL_STATUS_OFF});
    private static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODELS[0], MODEL_STATUS_HAS_CHANNEL});

    public PartExtendedFluidPatternTerminal(ItemStack is) {
        super(is);
        ExAppEngInternalInventory exCraft = new ExAppEngInternalInventory((AppEngInternalInventory)this.getInventoryByName("crafting"));
        ExAppEngInternalInventory exOutput = new ExAppEngInternalInventory((AppEngInternalInventory)this.getInventoryByName("output"));
        this.crafting = exCraft;
        this.output = exOutput;
    }

    @Nonnull
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL);
    }

    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        TileEntity te = this.getTile();
        BlockPos tePos = te.func_174877_v();
        if (Platform.isWrench((EntityPlayer)player, (ItemStack)player.field_71071_by.func_70448_g(), (BlockPos)tePos)) {
            return super.onPartActivate(player, hand, pos);
        }
        if (Platform.isServer()) {
            if (GuiBridge.GUI_EXPANDED_PROCESSING_PATTERN_TERMINAL.hasPermissions(te, tePos.func_177958_n(), tePos.func_177956_o(), tePos.func_177952_p(), this.getSide(), player)) {
                InventoryHandler.openGui(player, te.func_145831_w(), tePos, this.getSide().getFacing(), GuiType.FLUID_EXTENDED_PATTERN_TERMINAL);
            } else {
                Platform.openGUI((EntityPlayer)player, (TileEntity)this.getHost().getTile(), (AEPartLocation)this.getSide(), (GuiBridge)GuiBridge.GUI_ME);
            }
        }
        return true;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ItemStack is;
        if (slot == 1 && !(is = inv.getStackInSlot(1)).func_190926_b() && (is.func_77973_b() instanceof ItemFluidEncodedPattern || is.func_77973_b() instanceof ItemLargeEncodedPattern)) {
            ItemEncodedPattern pattern = (ItemEncodedPattern)is.func_77973_b();
            ICraftingPatternDetails details = pattern.getPatternForItem(is, this.getHost().getTile().func_145831_w());
            if (details != null) {
                ItemStack packet;
                IAEItemStack item;
                int x;
                for (x = 0; x < this.getInventoryByName("crafting").getSlots(); ++x) {
                    ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, ItemStack.field_190927_a);
                }
                for (x = 0; x < this.getInventoryByName("output").getSlots(); ++x) {
                    ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, ItemStack.field_190927_a);
                }
                for (x = 0; x < this.getInventoryByName("crafting").getSlots() && x < details.getInputs().length; ++x) {
                    item = details.getInputs()[x];
                    if (item != null && item.getItem() == FCItems.FLUID_DROP) {
                        packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                        ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, packet);
                        continue;
                    }
                    if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                        packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                        ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, packet);
                        continue;
                    }
                    ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
                for (x = 0; x < this.getInventoryByName("output").getSlots() && x < details.getOutputs().length; ++x) {
                    item = details.getOutputs()[x];
                    if (item != null && item.getItem() instanceof ItemFluidDrop) {
                        packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                        ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, packet);
                        continue;
                    }
                    if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                        packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                        ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, packet);
                        continue;
                    }
                    ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
                }
            }
            this.getHost().markForSave();
            return;
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    public void onChangeCrafting(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        IItemList storageList;
        IItemHandler crafting = this.getInventoryByName("crafting");
        IItemHandler output = this.getInventoryByName("output");
        IItemList iItemList = storageList = this.getInventory(Util.getItemChannel()) == null ? null : this.getInventory(Util.getItemChannel()).getStorageList();
        if (crafting instanceof AppEngInternalInventory && output instanceof AppEngInternalInventory) {
            ItemStack item;
            int x;
            Util.clearItemInventory((IItemHandlerModifiable)crafting);
            Util.clearItemInventory((IItemHandlerModifiable)output);
            ItemStack[] fuzzyFind = new ItemStack[Util.findMax((Collection<Integer>)inputs.keySet()) + 1];
            IntIterator intIterator = inputs.keySet().iterator();
            while (intIterator.hasNext()) {
                int index = (Integer)intIterator.next();
                Util.fuzzyTransferItems(index, (ItemStack[])inputs.get(index), fuzzyFind, (IItemList<IAEItemStack>)storageList);
            }
            if (combine) {
                fuzzyFind = Util.compress(fuzzyFind);
            }
            int bound = Math.min(crafting.getSlots(), fuzzyFind.length);
            for (x = 0; x < bound; ++x) {
                item = fuzzyFind[x];
                ((AppEngInternalInventory)crafting).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
            }
            bound = Math.min(output.getSlots(), outputs.size());
            for (x = 0; x < bound; ++x) {
                item = outputs.get(x);
                ((AppEngInternalInventory)output).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
            }
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.combine = data.func_74767_n("combineMode");
        this.fluidFirst = data.func_74767_n("fluidFirst");
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("combineMode", this.combine);
        data.func_74757_a("fluidFirst", this.fluidFirst);
    }

    public void setCombineMode(boolean value) {
        this.combine = value;
    }

    public boolean getCombineMode() {
        return this.combine;
    }

    public void setFluidPlaceMode(boolean value) {
        this.fluidFirst = value;
    }

    public boolean getFluidPlaceMode() {
        return this.fluidFirst;
    }
}

