/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item.fake;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.fluids.util.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.fake.DropLookup;
import com.glodblock.github.common.item.fake.FakeItemHandler;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.loader.FCItems;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class FakeFluids {
    public static void init() {
        FakeItemRegister.registerHandler(ItemFluidDrop.class, new FakeItemHandler<FluidStack, IAEFluidStack>(){

            @Override
            public FluidStack getStack(ItemStack stack) {
                if (stack.func_190926_b() || stack.func_77973_b() != FCItems.FLUID_DROP || !stack.func_77942_o()) {
                    return null;
                }
                NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
                if (!tag.func_150297_b("Fluid", 8)) {
                    return null;
                }
                Fluid fluid = FluidRegistry.getFluid((String)tag.func_74779_i("Fluid"));
                if (fluid == null) {
                    return null;
                }
                FluidStack fluidStack = new FluidStack(fluid, stack.func_190916_E());
                if (tag.func_150297_b("FluidTag", 10)) {
                    fluidStack.tag = tag.func_74775_l("FluidTag");
                }
                return fluidStack;
            }

            @Override
            public FluidStack getStack(@Nullable IAEItemStack stack) {
                return stack == null ? null : this.getStack(stack.createItemStack());
            }

            @Override
            public IAEFluidStack getAEStack(ItemStack stack) {
                if (stack.func_190926_b()) {
                    return null;
                }
                AEFluidStack fluidStack = AEFluidStack.fromFluidStack((FluidStack)this.getStack(stack));
                if (fluidStack == null) {
                    return null;
                }
                fluidStack.setStackSize((long)stack.func_190916_E());
                return fluidStack;
            }

            @Override
            public IAEFluidStack getAEStack(@Nullable IAEItemStack stack) {
                if (stack == null) {
                    return null;
                }
                AEFluidStack fluidStack = AEFluidStack.fromFluidStack((FluidStack)this.getStack(stack.createItemStack()));
                if (fluidStack == null) {
                    return null;
                }
                fluidStack.setStackSize(stack.getStackSize());
                return fluidStack;
            }

            @Override
            public ItemStack packStack(FluidStack fluid) {
                if (fluid == null || fluid.amount <= 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = new ItemStack((Item)FCItems.FLUID_DROP, fluid.amount);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("Fluid", fluid.getFluid().getName());
                if (fluid.tag != null) {
                    tag.func_74782_a("FluidTag", (NBTBase)fluid.tag);
                }
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public ItemStack displayStack(FluidStack target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IAEItemStack packAEStack(FluidStack fluid) {
                if (fluid == null || fluid.amount <= 0) {
                    return null;
                }
                IAEItemStack stack = DropLookup.lookup(fluid, f -> AEItemStack.fromItemStack((ItemStack)this.packStack((FluidStack)f)));
                if (stack == null) {
                    return null;
                }
                stack.setStackSize((long)fluid.amount);
                return stack;
            }

            @Override
            public IAEItemStack packAEStackLong(IAEFluidStack fluid) {
                if (fluid == null || fluid.getStackSize() <= 0L) {
                    return null;
                }
                IAEItemStack stack = DropLookup.lookup(fluid.getFluidStack(), f -> AEItemStack.fromItemStack((ItemStack)this.packStack((FluidStack)f)));
                if (stack == null) {
                    return null;
                }
                stack.setStackSize(fluid.getStackSize());
                return stack;
            }
        });
        FakeItemRegister.registerHandler(ItemFluidPacket.class, new FakeItemHandler<FluidStack, IAEFluidStack>(){

            @Override
            public FluidStack getStack(ItemStack stack) {
                if (stack.func_190926_b() || !stack.func_77942_o()) {
                    return null;
                }
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)Objects.requireNonNull(stack.func_77978_p()).func_74775_l("FluidStack"));
                return fluid != null && fluid.amount > 0 ? fluid : null;
            }

            @Override
            public FluidStack getStack(@Nullable IAEItemStack stack) {
                return stack != null ? this.getStack(stack.createItemStack()) : null;
            }

            @Override
            public IAEFluidStack getAEStack(ItemStack stack) {
                return this.getAEStack((IAEItemStack)AEItemStack.fromItemStack((ItemStack)stack));
            }

            @Override
            public IAEFluidStack getAEStack(@Nullable IAEItemStack stack) {
                if (stack == null) {
                    return null;
                }
                return AEFluidStack.fromFluidStack((FluidStack)this.getStack(stack.createItemStack()));
            }

            @Override
            public ItemStack packStack(FluidStack fluid) {
                if (fluid == null || fluid.amount == 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack stack = new ItemStack((Item)FCItems.FLUID_PACKET);
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound fluidTag = new NBTTagCompound();
                fluid.writeToNBT(fluidTag);
                tag.func_74782_a("FluidStack", (NBTBase)fluidTag);
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public ItemStack displayStack(FluidStack fluid) {
                if (fluid == null) {
                    return ItemStack.field_190927_a;
                }
                FluidStack copy = fluid.copy();
                copy.amount = 1000;
                ItemStack stack = new ItemStack((Item)FCItems.FLUID_PACKET);
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound fluidTag = new NBTTagCompound();
                copy.writeToNBT(fluidTag);
                tag.func_74782_a("FluidStack", (NBTBase)fluidTag);
                tag.func_74757_a("DisplayOnly", true);
                stack.func_77982_d(tag);
                return stack;
            }

            @Override
            public IAEItemStack packAEStack(FluidStack target) {
                return AEItemStack.fromItemStack((ItemStack)this.packStack(target));
            }

            @Override
            public IAEItemStack packAEStackLong(IAEFluidStack target) {
                return AEItemStack.fromItemStack((ItemStack)this.packStack(target.getFluidStack()));
            }
        });
    }

    public static boolean isFluidFakeItem(ItemStack stack) {
        return stack.func_77973_b() == FCItems.FLUID_PACKET || stack.func_77973_b() == FCItems.FLUID_DROP;
    }

    public static ItemStack packFluid2Drops(@Nullable FluidStack stack) {
        return FakeItemRegister.packStack(stack, FCItems.FLUID_DROP);
    }

    public static IAEItemStack packFluid2AEDrops(@Nullable FluidStack stack) {
        return FakeItemRegister.packAEStack(stack, FCItems.FLUID_DROP);
    }

    public static IAEItemStack packFluid2AEDrops(@Nullable IAEFluidStack stack) {
        return FakeItemRegister.packAEStackLong(stack, FCItems.FLUID_DROP);
    }

    public static ItemStack packFluid2Packet(@Nullable FluidStack stack) {
        return FakeItemRegister.packStack(stack, FCItems.FLUID_PACKET);
    }

    public static IAEItemStack packFluid2AEPacket(@Nullable FluidStack stack) {
        return FakeItemRegister.packAEStack(stack, FCItems.FLUID_PACKET);
    }

    public static ItemStack displayFluid(@Nullable FluidStack stack) {
        return FakeItemRegister.displayStack(stack, FCItems.FLUID_PACKET);
    }
}

