/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.interfaces.HasCustomModel;
import com.glodblock.github.util.NameConst;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemFluidPacket
extends Item
implements HasCustomModel {
    public ItemFluidPacket() {
        this.func_77625_d(1);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluid = (FluidStack)FakeItemRegister.getStack(stack);
        boolean display = ItemFluidPacket.isDisplay(stack);
        if (display) {
            return fluid != null ? fluid.getLocalizedName() : super.func_77653_i(stack);
        }
        return fluid != null ? String.format("%s, %,d mB", fluid.getLocalizedName(), fluid.amount) : super.func_77653_i(stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flags) {
        FluidStack fluid = (FluidStack)FakeItemRegister.getStack(stack);
        boolean display = ItemFluidPacket.isDisplay(stack);
        if (display) {
            return;
        }
        if (fluid != null) {
            for (String line : I18n.func_74838_a((String)"ae2fc.tooltip.fluid_packet").split("\\\\n")) {
                tooltip.add(TextFormatting.GRAY + line);
            }
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_74838_a((String)"ae2fc.tooltip.invalid_fluid"));
        }
    }

    public static boolean isDisplay(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o() || stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74767_n("DisplayOnly");
    }

    @Override
    public ResourceLocation getCustomModelPath() {
        return NameConst.MODEL_FLUID_PACKET;
    }

    public static boolean isFluidPacket(ItemStack is) {
        return !is.func_190926_b() && is.func_77973_b() instanceof ItemFluidPacket;
    }
}

