/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.component;

import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.helpers.IInterfaceHost;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.SettingsFrom;
import com.glodblock.github.common.component.DualityDualInterface;
import com.mekeng.github.common.me.duality.IGasInterfaceHost;
import com.mekeng.github.common.me.duality.impl.DualityGasInterface;
import com.mekeng.github.common.me.inventory.IGasInventory;
import com.mekeng.github.common.me.inventory.impl.GasInventory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class DualityTrioInterface<H extends IInterfaceHost & IFluidInterfaceHost>
extends DualityDualInterface<H> {
    private final DualityGasInterface gasDuality;

    public DualityTrioInterface(AENetworkProxy networkProxy, H host) {
        super(networkProxy, host);
        this.gasDuality = new DualityGasInterface(networkProxy, (IGasInterfaceHost)host);
    }

    public DualityGasInterface getGasInterface() {
        return this.gasDuality;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.gasDuality.getInstalledUpgrades(u) + super.getInstalledUpgrades(u);
    }

    @Override
    public void setPriority(int newValue) {
        super.setPriority(newValue);
        this.gasDuality.setPriority(newValue);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.gasDuality.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T capInst = super.getCapability(capability, facing);
        return (T)(capInst != null ? capInst : this.gasDuality.getCapability(capability, facing));
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        TickingRequest dual = super.getTickingRequest(node);
        TickingRequest gas = this.gasDuality.getTickingRequest(node);
        return new TickingRequest(Math.min(dual.minTickRate, gas.minTickRate), Math.max(dual.maxTickRate, gas.maxTickRate), dual.isSleeping && gas.isSleeping, true);
    }

    @Override
    public TickRateModulation onTick(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation dual = super.onTick(node, ticksSinceLastCall);
        TickRateModulation gas = this.gasDuality.tickingRequest(node, ticksSinceLastCall);
        if (dual.ordinal() >= gas.ordinal()) {
            return dual;
        }
        return gas;
    }

    @Override
    public void onChannelStateChange(MENetworkChannelsChanged c) {
        super.onChannelStateChange(c);
        this.gasDuality.notifyNeighbors();
    }

    @Override
    public void onPowerStateChange(MENetworkPowerStatusChange c) {
        super.onPowerStateChange(c);
        this.gasDuality.notifyNeighbors();
    }

    @Override
    public void onGridChanged() {
        super.onGridChanged();
        this.gasDuality.gridChanged();
    }

    @Override
    public void addDrops(List<ItemStack> drops) {
        super.addDrops(drops);
        this.gasDuality.addDrops(drops);
    }

    @Override
    public IItemHandler getItemInventoryByName(String name) {
        if (name.startsWith("gas_")) {
            return this.gasDuality.getInventoryByName(name.replace("gas_", ""));
        }
        return super.getItemInventoryByName(name);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagCompound gasIfaceTag = new NBTTagCompound();
        this.gasDuality.writeToNBT(gasIfaceTag);
        data.func_74782_a("gasDuality", (NBTBase)gasIfaceTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.gasDuality.readFromNBT(data.func_74775_l("gasDuality"));
    }

    @Override
    public NBTTagCompound downloadSettings(SettingsFrom from) {
        IGasInventory gasInv;
        NBTTagCompound tag = super.downloadSettings(from);
        if (from == SettingsFrom.MEMORY_CARD && (gasInv = this.gasDuality.getGasInventoryByName("config")) instanceof GasInventory) {
            tag.func_74782_a("gas_config", (NBTBase)((GasInventory)gasInv).save());
        }
        return tag;
    }

    @Override
    public void uploadSettings(NBTTagCompound compound, EntityPlayer player) {
        super.uploadSettings(compound, player);
        IGasInventory gasInv = this.gasDuality.getGasInventoryByName("config");
        if (gasInv instanceof GasInventory) {
            GasInventory target = (GasInventory)gasInv;
            GasInventory tmp = new GasInventory(target.size());
            NBTTagCompound data = compound.func_74775_l("gas_config");
            if (!data.func_82582_d()) {
                tmp.load(data);
            }
            for (int x = 0; x < tmp.size(); ++x) {
                target.setGas(x, tmp.getGasStack(x));
            }
        }
    }
}

