/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.component;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IMaterials;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.core.localization.PlayerMessages;
import appeng.fluids.helper.DualityFluidInterface;
import appeng.fluids.helper.IFluidInterfaceHost;
import appeng.fluids.util.AEFluidInventory;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.inv.InvOperation;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class DualityDualInterface<H extends IInterfaceHost & IFluidInterfaceHost>
implements ICapabilityProvider {
    private final DualityInterface itemDuality;
    private final DualityFluidInterface fluidDuality;

    public DualityDualInterface(AENetworkProxy networkProxy, H host) {
        this.itemDuality = new DualityInterface(networkProxy, host);
        this.fluidDuality = new DualityFluidInterface(networkProxy, (IFluidInterfaceHost)host);
    }

    public DualityInterface getItemInterface() {
        return this.itemDuality;
    }

    public DualityFluidInterface getFluidInterface() {
        return this.fluidDuality;
    }

    public IConfigManager getConfigManager() {
        return this.itemDuality.getConfigManager();
    }

    public int getInstalledUpgrades(Upgrades u) {
        return this.itemDuality.getInstalledUpgrades(u) + this.fluidDuality.getInstalledUpgrades(u);
    }

    public int getPriority() {
        return this.itemDuality.getPriority();
    }

    public void setPriority(int newValue) {
        this.itemDuality.setPriority(newValue);
        this.fluidDuality.setPriority(newValue);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.itemDuality.hasCapability(capability, facing) || this.fluidDuality.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object capInst = this.itemDuality.getCapability(capability, facing);
        return (T)(capInst != null ? capInst : this.fluidDuality.getCapability(capability, facing));
    }

    public void initialize() {
        this.itemDuality.initialize();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        TickingRequest item = this.itemDuality.getTickingRequest(node);
        TickingRequest fluid = this.fluidDuality.getTickingRequest(node);
        return new TickingRequest(Math.min(item.minTickRate, fluid.minTickRate), Math.max(item.maxTickRate, fluid.maxTickRate), item.isSleeping && fluid.isSleeping, true);
    }

    public TickRateModulation onTick(IGridNode node, int ticksSinceLastCall) {
        TickRateModulation item = this.itemDuality.tickingRequest(node, ticksSinceLastCall);
        TickRateModulation fluid = this.fluidDuality.tickingRequest(node, ticksSinceLastCall);
        if (item.ordinal() >= fluid.ordinal()) {
            return item;
        }
        return fluid;
    }

    public void onChannelStateChange(MENetworkChannelsChanged c) {
        this.itemDuality.notifyNeighbors();
        this.fluidDuality.notifyNeighbors();
    }

    public void onPowerStateChange(MENetworkPowerStatusChange c) {
        this.itemDuality.notifyNeighbors();
        this.fluidDuality.notifyNeighbors();
    }

    public void onGridChanged() {
        this.itemDuality.gridChanged();
        this.fluidDuality.gridChanged();
    }

    public void addDrops(List<ItemStack> drops) {
        this.itemDuality.addDrops(drops);
        this.fluidDuality.addDrops(drops);
    }

    public boolean canInsertItem(ItemStack stack) {
        return this.itemDuality.canInsert(stack);
    }

    public IItemHandler getItemInventoryByName(String name) {
        if (name.startsWith("item_")) {
            return this.itemDuality.getInventoryByName(name.replace("item_", ""));
        }
        if (name.startsWith("fluid_")) {
            return this.fluidDuality.getInventoryByName(name.replace("fluid_", ""));
        }
        return this.itemDuality.getInventoryByName(name);
    }

    public IItemHandler getInternalItemInventory() {
        return this.itemDuality.getInternalInventory();
    }

    public void onItemInventoryChange(IItemHandler inv, int slot, InvOperation op, ItemStack removed, ItemStack added) {
        this.itemDuality.onChangeInventory(inv, slot, op, removed, added);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.itemDuality.pushPattern(patternDetails, table);
    }

    public boolean isCraftingBusy() {
        return this.itemDuality.isBusy();
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.itemDuality.provideCrafting(craftingTracker);
    }

    public ImmutableSet<ICraftingLink> getRequestCraftingJobs() {
        return this.itemDuality.getRequestedJobs();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return this.itemDuality.injectCraftedItems(link, items, mode);
    }

    public void onCraftingJobStateChange(ICraftingLink link) {
        this.itemDuality.jobStateChange(link);
    }

    public void writeToNBT(NBTTagCompound data) {
        NBTTagCompound itemIfaceTag = new NBTTagCompound();
        NBTTagCompound fluidIfaceTag = new NBTTagCompound();
        this.itemDuality.writeToNBT(itemIfaceTag);
        this.fluidDuality.writeToNBT(fluidIfaceTag);
        data.func_74782_a("itemDuality", (NBTBase)itemIfaceTag);
        data.func_74782_a("fluidDuality", (NBTBase)fluidIfaceTag);
    }

    public void readFromNBT(NBTTagCompound data) {
        this.itemDuality.readFromNBT(data.func_74775_l("itemDuality"));
        this.fluidDuality.readFromNBT(data.func_74775_l("fluidDuality"));
    }

    public NBTTagCompound downloadSettings(SettingsFrom from) {
        NBTTagCompound tag = new NBTTagCompound();
        if (from == SettingsFrom.MEMORY_CARD) {
            IFluidHandler fluidInv;
            IItemHandler inv = this.getItemInventoryByName("item_patterns");
            if (inv instanceof AppEngInternalInventory) {
                ((AppEngInternalInventory)inv).writeToNBT(tag, "item_patterns");
            }
            if ((fluidInv = this.fluidDuality.getFluidInventoryByName("config")) instanceof AEFluidInventory) {
                ((AEFluidInventory)fluidInv).writeToNBT(tag, "fluid_config");
            }
        }
        return tag;
    }

    public void uploadSettings(NBTTagCompound compound, EntityPlayer player) {
        IFluidHandler fluidInv;
        IItemHandler inv = this.getItemInventoryByName("item_patterns");
        if (inv instanceof AppEngInternalInventory) {
            AppEngInternalInventory target = (AppEngInternalInventory)inv;
            AppEngInternalInventory tmp = new AppEngInternalInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "item_patterns");
            PlayerMainInvWrapper playerInv = new PlayerMainInvWrapper(player.field_71071_by);
            IMaterials materials = AEApi.instance().definitions().materials();
            int missingPatternsToEncode = 0;
            for (int i = 0; i < inv.getSlots(); ++i) {
                if (!(target.getStackInSlot(i).func_77973_b() instanceof ItemEncodedPattern)) continue;
                ItemStack blank = (ItemStack)materials.blankPattern().maybeStack(target.getStackInSlot(i).func_190916_E()).get();
                if (!player.func_191521_c(blank)) {
                    player.func_71019_a(blank, true);
                }
                target.setStackInSlot(i, ItemStack.field_190927_a);
            }
            for (int x = 0; x < tmp.getSlots(); ++x) {
                if (tmp.getStackInSlot(x).func_190926_b()) continue;
                boolean found = false;
                for (int i = 0; i < playerInv.getSlots(); ++i) {
                    if (!materials.blankPattern().isSameAs(playerInv.getStackInSlot(i))) continue;
                    target.setStackInSlot(x, tmp.getStackInSlot(x));
                    playerInv.getStackInSlot(i).func_190918_g(1);
                    found = true;
                    break;
                }
                if (found) continue;
                ++missingPatternsToEncode;
            }
            if (Platform.isServer() && missingPatternsToEncode > 0) {
                player.func_145747_a(PlayerMessages.MissingPatternsToEncode.get());
            }
        }
        if ((fluidInv = this.fluidDuality.getFluidInventoryByName("config")) instanceof AEFluidInventory) {
            AEFluidInventory target = (AEFluidInventory)fluidInv;
            AEFluidInventory tmp = new AEFluidInventory(null, target.getSlots());
            tmp.readFromNBT(compound, "fluid_config");
            for (int x = 0; x < tmp.getSlots(); ++x) {
                target.setFluidInSlot(x, tmp.getFluidInSlot(x));
            }
        }
    }
}

