/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.block;

import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import com.glodblock.github.common.tile.TileDualInterface;
import com.glodblock.github.inventory.GuiType;
import com.glodblock.github.inventory.InventoryHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDualInterface
extends AEBaseTileBlock {
    private static final PropertyBool OMNIDIRECTIONAL = PropertyBool.func_177716_a((String)"omnidirectional");
    private static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockDualInterface() {
        super(Material.field_151573_f);
        this.setTileEntity(TileDualInterface.class);
    }

    protected IProperty[] getAEStates() {
        return new IProperty[]{OMNIDIRECTIONAL};
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OMNIDIRECTIONAL, FACING});
    }

    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (p.func_70093_af()) {
            return false;
        }
        TileDualInterface tg = (TileDualInterface)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null) {
            if (Platform.isServer()) {
                InventoryHandler.openGui(p, w, pos, side, GuiType.DUAL_ITEM_INTERFACE);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileDualInterface te = (TileDualInterface)this.getTileEntity(world, pos);
        return te == null ? state : state.func_177226_a((IProperty)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(te.isOmniDirectional())).func_177226_a((IProperty)FACING, (Comparable)te.getForward());
    }

    protected boolean hasCustomRotation() {
        return true;
    }

    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
        if (rotatable instanceof TileDualInterface) {
            ((TileDualInterface)rotatable).setSide(axis);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        AEBaseTile tileEntity = this.getTileEntity((IBlockAccess)worldIn, pos);
        if (tileEntity instanceof TileDualInterface) {
            ((TileDualInterface)tileEntity).getInterfaceDuality().updateRedstoneState();
        }
    }
}

