/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.IUpgradeableCellContainer;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerWirelessPatternTerminal;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.helpers.InventoryAction;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.items.misc.ItemEncodedPattern;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidCraftEncodedPattern;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.ItemLargeEncodedPattern;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.interfaces.PatternConsumer;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.FluidCraftingPatternDetails;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mekanism.api.gas.GasStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerWirelessFluidPatternTerminal
extends ContainerWirelessPatternTerminal
implements PatternConsumer,
IUpgradeableCellContainer,
IInventorySlotAware {
    private final WirelessTerminalGuiObject wirelessTerminalGUIObject;
    @GuiSync(value=105)
    public boolean combine = false;
    @GuiSync(value=106)
    public boolean fluidFirst = false;

    public ContainerWirelessFluidPatternTerminal(InventoryPlayer ip, WirelessTerminalGuiObject gui) {
        super(ip, gui);
        this.wirelessTerminalGUIObject = gui;
        this.loadFromNBT();
    }

    public void encode() {
        if (!this.checkHasFluidPattern()) {
            super.encode();
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack.func_190926_b()) {
            stack = this.patternSlotIN.func_75211_c();
            if (stack.func_190926_b() || !ContainerWirelessFluidPatternTerminal.isPattern(stack)) {
                return;
            }
            if (stack.func_190916_E() == 1) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            } else {
                stack.func_190918_g(1);
            }
            this.encodeFluidPattern();
        } else if (ContainerWirelessFluidPatternTerminal.isPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    public void encodeFluidCraftPattern() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (!output.func_190926_b() && !ContainerWirelessFluidPatternTerminal.isPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            Optional maybePattern;
            output = this.patternSlotIN.func_75211_c();
            if (output.func_190926_b() || !ContainerWirelessFluidPatternTerminal.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            }
            if ((maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
                output = (ItemStack)maybePattern.get();
                this.patternSlotOUT.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.isCraftingMode());
        encodedValue.func_74757_a("substitute", this.substitute);
        ItemStack patternStack = new ItemStack((Item)FCItems.DENSE_CRAFT_ENCODED_PATTERN);
        patternStack.func_77982_d(encodedValue);
        FluidCraftingPatternDetails details = FluidCraftingPatternDetails.GetFluidPattern(patternStack, this.getNetworkNode().getWorld());
        if (details == null || !details.isNecessary()) {
            this.encode();
            return;
        }
        this.patternSlotOUT.func_75215_d(patternStack);
    }

    private boolean checkHasFluidPattern() {
        if (this.craftingMode) {
            return false;
        }
        boolean hasFluid = false;
        boolean search = false;
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            ItemStack crafting = slotFakeCraftingMatrix.func_75211_c();
            if (crafting.func_190926_b()) continue;
            search = true;
            if (crafting.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || crafting.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        if (!search) {
            return false;
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            ItemStack out = slotFakeCraftingMatrix.func_75211_c();
            if (out.func_190926_b()) continue;
            search = false;
            if (hasFluid) break;
            if (out.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || out.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        return hasFluid && !search;
    }

    private void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)FCItems.DENSE_ENCODED_PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(ContainerWirelessFluidPatternTerminal.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(ContainerWirelessFluidPatternTerminal.collectInventory((Slot[])this.outputSlots));
        this.patternSlotOUT.func_75215_d(pattern.writeToStack());
    }

    private static IAEItemStack[] collectInventory(Slot[] slots) {
        ArrayList<Object> acc = new ArrayList<Object>();
        for (Slot slot : slots) {
            IAEItemStack dropStack;
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == FCItems.FLUID_PACKET && (dropStack = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            if (ModAndClassUtil.GAS && stack.func_77973_b() == FCGasItems.GAS_PACKET && (dropStack = FakeGases.packGas2AEDrops((GasStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
            if (aeStack == null) continue;
            acc.add(aeStack);
        }
        return acc.toArray(new IAEItemStack[0]);
    }

    private static boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        if (output.func_77973_b() instanceof ItemFluidEncodedPattern || output.func_77973_b() instanceof ItemFluidCraftEncodedPattern || output.func_77973_b() instanceof ItemLargeEncodedPattern) {
            return true;
        }
        IDefinitions defs = AEApi.instance().definitions();
        return defs.items().encodedPattern().isSameAs(output) || defs.materials().blankPattern().isSameAs(output);
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            NBTTagCompound tag = this.iGuiItemObject.getItemStack().func_77978_p();
            if (tag != null) {
                this.combine = tag.func_74767_n("combine");
                this.fluidFirst = tag.func_74767_n("fluidFirst");
            } else {
                this.combine = false;
                this.fluidFirst = false;
            }
        }
    }

    public void saveChanges() {
        super.saveChanges();
        if (Platform.isServer()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("combine", this.combine);
            tag.func_74757_a("fluidFirst", this.fluidFirst);
            this.wirelessTerminalGUIObject.saveChanges(tag);
        }
    }

    private void loadFromNBT() {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            this.combine = data.func_74767_n("combine");
            this.fluidFirst = data.func_74767_n("fluidFirst");
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        if (this.isCraftingMode()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        if (slotId < 0 || slotId >= this.field_75151_b.size()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        Slot slot = this.func_75139_a(slotId);
        ItemStack stack = player.field_71071_by.func_70445_o();
        if ((slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && Util.getFluidFromItem(stack) != null) {
            FluidStack fluid = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    fluid = Util.getFluidFromItem(stack);
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    fluid = Util.getFluidFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    FluidStack origin = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (fluid != null && fluid.equals((Object)origin)) {
                        fluid.amount += origin.amount;
                        if (fluid.amount <= 0) {
                            fluid = null;
                        }
                    }
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            }
            if (fluid == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (ModAndClassUtil.GAS && (slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null) && Util.getGasFromItem(stack) != null) {
            GasStack gas = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    gas = (GasStack)Util.getGasFromItem(stack);
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    gas = (GasStack)Util.getGasFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    GasStack origin = (GasStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (gas != null && gas.equals(origin)) {
                        gas.amount += origin.amount;
                        if (gas.amount <= 0) {
                            gas = null;
                        }
                    }
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                }
            }
            if (gas == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE) {
            GasStack gas;
            if (stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() == FCItems.FLUID_PACKET) {
                FluidStack fluid = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                if (fluid != null && fluid.amount - 1000 >= 1) {
                    fluid.amount -= 1000;
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            } else if (ModAndClassUtil.GAS && stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() == FCGasItems.GAS_PACKET && (gas = (GasStack)FakeItemRegister.getStack(slot.func_75211_c())) != null && gas.amount - 1000 >= 1) {
                gas.amount -= 1000;
                slot.func_75215_d(FakeGases.packGas2Packet(gas));
            }
        }
        super.doAction(player, action, slotId, id);
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        ItemStack is;
        if (slot == 1 && !(is = inv.getStackInSlot(1)).func_190926_b() && (is.func_77973_b() instanceof ItemFluidEncodedPattern || is.func_77973_b() instanceof ItemFluidCraftEncodedPattern || is.func_77973_b() instanceof ItemLargeEncodedPattern)) {
            ItemEncodedPattern pattern = (ItemEncodedPattern)is.func_77973_b();
            ICraftingPatternDetails details = pattern.getPatternForItem(is, this.getPlayerInv().field_70458_d.field_70170_p);
            if (details != null) {
                int x;
                this.setCraftingMode(details.isCraftable());
                this.setSubstitute(details.canSubstitute());
                for (x = 0; x < this.crafting.getSlots(); ++x) {
                    ((AppEngInternalInventory)this.crafting).setStackInSlot(x, ItemStack.field_190927_a);
                }
                for (x = 0; x < this.output.getSlots(); ++x) {
                    this.output.setStackInSlot(x, ItemStack.field_190927_a);
                }
                if (details instanceof FluidCraftingPatternDetails) {
                    this.putPattern(((FluidCraftingPatternDetails)details).getOriginInputs(), details.getOutputs());
                    this.setCraftingMode(true);
                } else {
                    this.putPattern(details.getInputs(), details.getOutputs());
                }
            }
            this.saveChanges();
            return;
        }
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
    }

    public void putPattern(IAEItemStack[] inputs, IAEItemStack[] outputs) {
        ItemStack packet;
        IAEItemStack item;
        int x;
        for (x = 0; x < this.getInventoryByName("crafting").getSlots() && x < inputs.length; ++x) {
            item = inputs[x];
            if (item != null && item.getItem() == FCItems.FLUID_DROP) {
                packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, packet);
                continue;
            }
            if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, packet);
                continue;
            }
            ((AppEngInternalInventory)this.getInventoryByName("crafting")).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
        }
        for (x = 0; x < this.getInventoryByName("output").getSlots() && x < outputs.length; ++x) {
            item = outputs[x];
            if (item != null && item.getItem() == FCItems.FLUID_DROP) {
                packet = FakeFluids.packFluid2Packet((FluidStack)FakeItemRegister.getStack(item.createItemStack()));
                ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, packet);
                continue;
            }
            if (ModAndClassUtil.GAS && item != null && item.getItem() == FCGasItems.GAS_DROP) {
                packet = FakeGases.packGas2Packet((GasStack)FakeItemRegister.getStack(item.createItemStack()));
                ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, packet);
                continue;
            }
            ((AppEngInternalInventory)this.getInventoryByName("output")).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item.createItemStack());
        }
    }

    public void multiply(int multiple) {
        if (Util.multiplySlotCheck((Slot[])this.craftingSlots, multiple) && Util.multiplySlotCheck((Slot[])this.outputSlots, multiple)) {
            Util.multiplySlot((Slot[])this.craftingSlots, multiple);
            Util.multiplySlot((Slot[])this.outputSlots, multiple);
        }
    }

    public void divide(int divide) {
        if (Util.divideSlotCheck((Slot[])this.craftingSlots, divide) && Util.divideSlotCheck((Slot[])this.outputSlots, divide)) {
            Util.divideSlot((Slot[])this.craftingSlots, divide);
            Util.divideSlot((Slot[])this.outputSlots, divide);
        }
    }

    public void increase(int increase) {
        if (Util.increaseSlotCheck((Slot[])this.craftingSlots, increase) && Util.increaseSlotCheck((Slot[])this.outputSlots, increase)) {
            Util.increaseSlot((Slot[])this.craftingSlots, increase);
            Util.increaseSlot((Slot[])this.outputSlots, increase);
        }
    }

    public void decrease(int decrease) {
        if (Util.decreaseSlotCheck((Slot[])this.craftingSlots, decrease) && Util.decreaseSlotCheck((Slot[])this.outputSlots, decrease)) {
            Util.decreaseSlot((Slot[])this.craftingSlots, decrease);
            Util.decreaseSlot((Slot[])this.outputSlots, decrease);
        }
    }

    public IItemHandler getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        return name.equals("output") ? this.output : super.getInventoryByName(name);
    }

    public void setCombineMode(boolean value) {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            data.func_74757_a("combine", value);
        } else {
            data = new NBTTagCompound();
            data.func_74757_a("combine", value);
            this.wirelessTerminalGUIObject.getItemStack().func_77982_d(data);
        }
        this.combine = value;
    }

    public void setFluidPlaceMode(boolean value) {
        NBTTagCompound data = this.wirelessTerminalGUIObject.getItemStack().func_77978_p();
        if (data != null) {
            data.func_74757_a("fluidFirst", value);
        } else {
            data = new NBTTagCompound();
            data.func_74757_a("fluidFirst", value);
            this.wirelessTerminalGUIObject.getItemStack().func_77982_d(data);
        }
        this.fluidFirst = value;
    }

    @Override
    public void acceptPattern(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        IItemList storageList;
        IItemList iItemList = storageList = this.wirelessTerminalGUIObject.getInventory(Util.getItemChannel()) == null ? null : this.wirelessTerminalGUIObject.getInventory(Util.getItemChannel()).getStorageList();
        if (this.crafting instanceof AppEngInternalInventory && this.output != null) {
            ItemStack item;
            int x;
            Util.clearItemInventory((IItemHandlerModifiable)this.crafting);
            Util.clearItemInventory((IItemHandlerModifiable)this.output);
            ItemStack[] fuzzyFind = new ItemStack[Util.findMax((Collection<Integer>)inputs.keySet()) + 1];
            IntIterator intIterator = inputs.keySet().iterator();
            while (intIterator.hasNext()) {
                int index = (Integer)intIterator.next();
                Util.fuzzyTransferItems(index, (ItemStack[])inputs.get(index), fuzzyFind, (IItemList<IAEItemStack>)storageList);
            }
            if (combine && !this.craftingMode) {
                fuzzyFind = Util.compress(fuzzyFind);
            }
            int bound = Math.min(this.crafting.getSlots(), fuzzyFind.length);
            for (x = 0; x < bound; ++x) {
                item = fuzzyFind[x];
                ((AppEngInternalInventory)this.crafting).setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
            }
            bound = Math.min(this.output.getSlots(), outputs.size());
            for (x = 0; x < bound; ++x) {
                item = outputs.get(x);
                this.output.setStackInSlot(x, item == null ? ItemStack.field_190927_a : item);
            }
        }
    }

    NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
            if (i.func_190916_E() > i.func_77976_d()) {
                c.func_74768_a("stackSize", i.func_190916_E());
            }
        }
        return c;
    }
}

