/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.InventoryAction;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.tile.TileUltimateEncoder;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.interfaces.PatternConsumer;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.Util;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.GasStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerUltimateEncoder
extends AEBaseContainer
implements IOptionalSlotHost,
PatternConsumer {
    private final TileUltimateEncoder encoder;
    protected final SlotRestrictedInput patternSlotIN;
    protected final SlotRestrictedInput patternSlotOUT;
    protected final SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[42];
    protected final SlotPatternOutputs[] outputSlots = new SlotPatternOutputs[8];
    @GuiSync(value=105)
    public boolean combine = false;
    @GuiSync(value=106)
    public boolean fluidFirst = false;

    public ContainerUltimateEncoder(InventoryPlayer ipl, TileUltimateEncoder encoder) {
        super(ipl, (Object)encoder);
        int x;
        int y;
        this.encoder = encoder;
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, (IItemHandler)this.encoder.getPattern(), 0, 137, 91, this.getInventoryPlayer());
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IItemHandler)this.encoder.getPattern(), 1, 137, 134, this.getInventoryPlayer());
        for (y = 0; y < 7; ++y) {
            for (x = 0; x < 6; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix((IItemHandler)this.encoder.getCraft(), x + y * 6, 8 + x * 18, 29 + y * 18);
                this.craftingSlots[x + y * 6] = slotFakeCraftingMatrix;
                this.func_75146_a((Slot)slotFakeCraftingMatrix);
            }
        }
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 2; ++x) {
                SlotPatternOutputs slotPatternOutputs = new SlotPatternOutputs((IItemHandler)this.encoder.getOutput(), (IOptionalSlotHost)this, x + y * 2, 134 + x * 18, 12 + y * 18, 0, 0, 1);
                this.outputSlots[x + y * 2] = slotPatternOutputs;
                this.func_75146_a((Slot)slotPatternOutputs);
                this.outputSlots[x + y * 2].setRenderDisabled(false);
                this.outputSlots[x + y * 2].setIIcon(-1);
            }
        }
        this.func_75146_a((Slot)this.patternSlotIN);
        this.func_75146_a((Slot)this.patternSlotOUT);
        this.bindPlayerInventory(ipl, 0, 167);
    }

    public void setCombine(boolean val) {
        this.combine = val;
        this.encoder.combine = val;
    }

    public void setFluidFirst(boolean val) {
        this.fluidFirst = val;
        this.encoder.fluidFirst = val;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            this.combine = this.encoder.combine;
            this.fluidFirst = this.encoder.fluidFirst;
        }
    }

    public TileUltimateEncoder getEncoder() {
        return this.encoder;
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        if (this.field_75151_b.get(idx) instanceof SlotPlayerInv || this.field_75151_b.get(idx) instanceof SlotPlayerHotBar) {
            AppEngSlot clickSlot = (AppEngSlot)this.field_75151_b.get(idx);
            ItemStack itemStack = clickSlot.func_75211_c();
            if (AEApi.instance().definitions().materials().blankPattern().isSameAs(itemStack)) {
                AppEngInternalInventory patternInv = this.encoder.getPattern();
                ItemStack remainder = patternInv.insertItem(0, itemStack, false);
                clickSlot.func_75215_d(remainder);
            }
        }
        return super.func_82846_b(p, idx);
    }

    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalSlotFake) && !(slot instanceof SlotFakeCraftingMatrix)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        if (slotId < 0 || slotId >= this.field_75151_b.size()) {
            super.doAction(player, action, slotId, id);
            return;
        }
        Slot slot = this.func_75139_a(slotId);
        ItemStack stack = player.field_71071_by.func_70445_o();
        if ((slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && Util.getFluidFromItem(stack) != null) {
            FluidStack fluid = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    fluid = Util.getFluidFromItem(stack);
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    fluid = Util.getFluidFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    FluidStack origin = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (fluid != null && fluid.equals((Object)origin)) {
                        fluid.amount += origin.amount;
                        if (fluid.amount <= 0) {
                            fluid = null;
                        }
                    }
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            }
            if (fluid == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (ModAndClassUtil.GAS && (slot instanceof SlotFakeCraftingMatrix || slot instanceof SlotPatternOutputs) && !stack.func_190926_b() && stack.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null) && Util.getGasFromItem(stack) != null) {
            GasStack gas = null;
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    gas = (GasStack)Util.getGasFromItem(stack);
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    gas = (GasStack)Util.getGasFromItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    GasStack origin = (GasStack)FakeItemRegister.getStack(slot.func_75211_c());
                    if (gas != null && gas.equals(origin)) {
                        gas.amount += origin.amount;
                        if (gas.amount <= 0) {
                            gas = null;
                        }
                    }
                    slot.func_75215_d(FakeGases.packGas2Packet(gas));
                }
            }
            if (gas == null) {
                super.doAction(player, action, slotId, id);
                return;
            }
            return;
        }
        if (action == InventoryAction.SPLIT_OR_PLACE_SINGLE) {
            GasStack gas;
            if (stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() instanceof ItemFluidPacket) {
                FluidStack fluid = (FluidStack)FakeItemRegister.getStack(slot.func_75211_c());
                if (fluid != null && fluid.amount - 1000 >= 1) {
                    fluid.amount -= 1000;
                    slot.func_75215_d(FakeFluids.packFluid2Packet(fluid));
                }
            } else if (ModAndClassUtil.GAS && stack.func_190926_b() && !slot.func_75211_c().func_190926_b() && slot.func_75211_c().func_77973_b() == FCGasItems.GAS_PACKET && (gas = (GasStack)FakeItemRegister.getStack(slot.func_75211_c())) != null && gas.amount - 1000 >= 1) {
                gas.amount -= 1000;
                slot.func_75215_d(FakeGases.packGas2Packet(gas));
            }
        }
        super.doAction(player, action, slotId, id);
    }

    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (!output.func_190926_b()) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_71019_a(output, false);
            }
            this.patternSlotOUT.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void encode() {
        if (ContainerUltimateEncoder.collectInventory((Slot[])this.craftingSlots).length == 0 || ContainerUltimateEncoder.collectInventory((Slot[])this.outputSlots).length == 0) {
            return;
        }
        if (!this.checkHasFluidPattern()) {
            ItemStack stack = this.patternSlotOUT.func_75211_c();
            if (stack.func_190926_b()) {
                stack = this.patternSlotIN.func_75211_c();
                if (stack.func_190926_b() || this.notPattern(stack)) {
                    return;
                }
                if (stack.func_190916_E() == 1) {
                    this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
                } else {
                    stack.func_190918_g(1);
                }
                this.encodeItem();
            } else if (!this.notPattern(stack)) {
                this.encodeItem();
            }
            return;
        }
        ItemStack stack = this.patternSlotOUT.func_75211_c();
        if (stack.func_190926_b()) {
            stack = this.patternSlotIN.func_75211_c();
            if (stack.func_190926_b() || this.notPattern(stack)) {
                return;
            }
            if (stack.func_190916_E() == 1) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            } else {
                stack.func_190918_g(1);
            }
            this.encodeFluidPattern();
        } else if (!this.notPattern(stack)) {
            this.encodeFluidPattern();
        }
    }

    public void encodeItem() {
        ItemStack patternStack = new ItemStack((Item)FCItems.LARGE_ITEM_ENCODED_PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(ContainerUltimateEncoder.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(ContainerUltimateEncoder.collectInventory((Slot[])this.outputSlots));
        pattern.setEncoder(this.getInventoryPlayer().field_70458_d.func_146103_bH());
        this.patternSlotOUT.func_75215_d(pattern.writeToStack());
    }

    private boolean checkHasFluidPattern() {
        boolean hasFluid = false;
        boolean search = false;
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            ItemStack crafting = slotFakeCraftingMatrix.func_75211_c();
            if (crafting.func_190926_b()) continue;
            search = true;
            if (crafting.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || crafting.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        if (!search) {
            return false;
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            ItemStack out = slotFakeCraftingMatrix.func_75211_c();
            if (out.func_190926_b()) continue;
            search = false;
            if (hasFluid) break;
            if (out.func_77973_b() == FCItems.FLUID_PACKET) {
                hasFluid = true;
                break;
            }
            if (!ModAndClassUtil.GAS || out.func_77973_b() != FCGasItems.GAS_PACKET) continue;
            hasFluid = true;
            break;
        }
        return hasFluid && !search;
    }

    private void encodeFluidPattern() {
        ItemStack patternStack = new ItemStack((Item)FCItems.DENSE_ENCODED_PATTERN);
        FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
        pattern.setInputs(ContainerUltimateEncoder.collectInventory((Slot[])this.craftingSlots));
        pattern.setOutputs(ContainerUltimateEncoder.collectInventory((Slot[])this.outputSlots));
        pattern.setEncoder(this.getInventoryPlayer().field_70458_d.func_146103_bH());
        this.patternSlotOUT.func_75215_d(pattern.writeToStack());
    }

    private static IAEItemStack[] collectInventory(Slot[] slots) {
        ArrayList<Object> acc = new ArrayList<Object>();
        for (Slot slot : slots) {
            IAEItemStack dropStack;
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == FCItems.FLUID_PACKET && (dropStack = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            if (ModAndClassUtil.GAS && stack.func_77973_b() == FCGasItems.GAS_PACKET && (dropStack = FakeGases.packGas2AEDrops((GasStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            AEItemStack aeStack = AEItemStack.fromItemStack((ItemStack)stack);
            if (aeStack == null) continue;
            acc.add(aeStack);
        }
        return acc.toArray(new IAEItemStack[0]);
    }

    private boolean notPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return true;
        }
        if (output.func_77973_b() == FCItems.DENSE_ENCODED_PATTERN || output.func_77973_b() == FCItems.LARGE_ITEM_ENCODED_PATTERN) {
            return false;
        }
        IDefinitions defs = AEApi.instance().definitions();
        return !defs.items().encodedPattern().isSameAs(output) && !defs.materials().blankPattern().isSameAs(output);
    }

    public void multiply(int multiple) {
        if (Util.multiplySlotCheck((Slot[])this.craftingSlots, multiple) && Util.multiplySlotCheck((Slot[])this.outputSlots, multiple)) {
            Util.multiplySlot((Slot[])this.craftingSlots, multiple);
            Util.multiplySlot((Slot[])this.outputSlots, multiple);
        }
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.outputSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void divide(int divide) {
        if (Util.divideSlotCheck((Slot[])this.craftingSlots, divide) && Util.divideSlotCheck((Slot[])this.outputSlots, divide)) {
            Util.divideSlot((Slot[])this.craftingSlots, divide);
            Util.divideSlot((Slot[])this.outputSlots, divide);
        }
    }

    public void increase(int increase) {
        if (Util.increaseSlotCheck((Slot[])this.craftingSlots, increase) && Util.increaseSlotCheck((Slot[])this.outputSlots, increase)) {
            Util.increaseSlot((Slot[])this.craftingSlots, increase);
            Util.increaseSlot((Slot[])this.outputSlots, increase);
        }
    }

    public void decrease(int decrease) {
        if (Util.decreaseSlotCheck((Slot[])this.craftingSlots, decrease) && Util.decreaseSlotCheck((Slot[])this.outputSlots, decrease)) {
            Util.decreaseSlot((Slot[])this.craftingSlots, decrease);
            Util.decreaseSlot((Slot[])this.outputSlots, decrease);
        }
    }

    public boolean isSlotEnabled(int i) {
        return true;
    }

    @Override
    public void acceptPattern(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        this.encoder.onChangeCrafting(inputs, outputs, combine);
    }
}

