/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.container;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.InventoryAction;
import appeng.util.item.AEItemStack;
import com.glodblock.github.common.item.ItemFluidEncodedPattern;
import com.glodblock.github.common.item.fake.FakeFluids;
import com.glodblock.github.common.item.fake.FakeItemRegister;
import com.glodblock.github.common.tile.TileFluidPatternEncoder;
import com.glodblock.github.handler.AeItemStackHandler;
import com.glodblock.github.integration.mek.FCGasItems;
import com.glodblock.github.integration.mek.FakeGases;
import com.glodblock.github.interfaces.AeStackInventory;
import com.glodblock.github.interfaces.PatternConsumer;
import com.glodblock.github.interfaces.SlotFluid;
import com.glodblock.github.loader.FCItems;
import com.glodblock.github.util.FluidPatternDetails;
import com.glodblock.github.util.ModAndClassUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerFluidPatternEncoder
extends AEBaseContainer
implements PatternConsumer {
    private final TileFluidPatternEncoder tile;

    public ContainerFluidPatternEncoder(InventoryPlayer ipl, TileFluidPatternEncoder tile) {
        super(ipl, (Object)tile);
        this.tile = tile;
        AeItemStackHandler crafting = new AeItemStackHandler(tile.getCraftingSlots());
        AeItemStackHandler output = new AeItemStackHandler(tile.getOutputSlots());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a((Slot)new SlotFluidConvertingFake(crafting, y * 3 + x, 23 + x * 18, 17 + y * 18));
            }
            this.func_75146_a((Slot)new SlotFluidConvertingFake(output, y, 113, 17 + y * 18));
        }
        this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, (IItemHandler)tile.getInventory(), 0, 138, 20, ipl));
        this.func_75146_a((Slot)new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, (IItemHandler)tile.getInventory(), 1, 138, 50, ipl));
        this.bindPlayerInventory(ipl, 0, 84);
    }

    public TileFluidPatternEncoder getTile() {
        return this.tile;
    }

    public boolean canEncodePattern() {
        block3: {
            if (ContainerFluidPatternEncoder.isNotPattern(this.tile.getInventory().getStackInSlot(0)) && ContainerFluidPatternEncoder.isNotPattern(this.tile.getInventory().getStackInSlot(1))) {
                return false;
            }
            for (IAEItemStack stack : this.tile.getCraftingSlots()) {
                if (stack == null || stack.getStackSize() <= 0L) continue;
                break block3;
            }
            return false;
        }
        for (IAEItemStack stack : this.tile.getOutputSlots()) {
            if (stack == null || stack.getStackSize() <= 0L) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotPattern(ItemStack stack) {
        return stack.func_190926_b() || !AEApi.instance().definitions().materials().blankPattern().isSameAs(stack) && !(stack.func_77973_b() instanceof ItemFluidEncodedPattern);
    }

    public void encodePattern() {
        if (this.canEncodePattern()) {
            if (this.tile.getInventory().getStackInSlot(1).func_190926_b()) {
                this.tile.getInventory().extractItem(0, 1, false);
            }
            ItemStack patternStack = new ItemStack((Item)FCItems.DENSE_ENCODED_PATTERN);
            FluidPatternDetails pattern = new FluidPatternDetails(patternStack);
            pattern.setInputs(ContainerFluidPatternEncoder.collectAeInventory(this.tile.getCraftingSlots()));
            pattern.setOutputs(ContainerFluidPatternEncoder.collectAeInventory(this.tile.getOutputSlots()));
            pattern.setEncoder(this.getInventoryPlayer().field_70458_d.func_146103_bH());
            this.tile.getInventory().setStackInSlot(1, pattern.writeToStack());
        }
    }

    private static IAEItemStack[] collectAeInventory(AeStackInventory<IAEItemStack> inv) {
        ArrayList<IAEItemStack> acc = new ArrayList<IAEItemStack>();
        for (IAEItemStack stack : inv) {
            IAEItemStack dropStack;
            if (stack == null) continue;
            if (stack.getItem() == FCItems.FLUID_PACKET && (dropStack = FakeFluids.packFluid2AEDrops((FluidStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            if (ModAndClassUtil.GAS && stack.getItem() == FCGasItems.GAS_PACKET && (dropStack = FakeGases.packGas2AEDrops((GasStack)FakeItemRegister.getStack(stack))) != null) {
                acc.add(dropStack);
                continue;
            }
            acc.add(stack);
        }
        return acc.toArray(new IAEItemStack[0]);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotId, long id) {
        Slot slot = this.func_75139_a(slotId);
        if (slot instanceof SlotFluidConvertingFake) {
            ItemStack stack = player.field_71071_by.func_70445_o();
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (stack.func_190926_b()) {
                        slot.func_75215_d(ItemStack.field_190927_a);
                        break;
                    }
                    ((SlotFluidConvertingFake)slot).putConvertedStack(stack.func_77946_l());
                    break;
                }
                case PLACE_SINGLE: {
                    if (stack.func_190926_b()) break;
                    ((SlotFluidConvertingFake)slot).putConvertedStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    ItemStack inSlot = slot.func_75211_c();
                    if (!inSlot.func_190926_b()) {
                        if (stack.func_190926_b()) {
                            slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)inSlot, (int)Math.max(1, inSlot.func_190916_E() - 1)));
                            break;
                        }
                        if (stack.func_77969_a(inSlot)) {
                            slot.func_75215_d(ItemHandlerHelper.copyStackWithSize((ItemStack)inSlot, (int)Math.min(inSlot.func_77976_d(), inSlot.func_190916_E() + 1)));
                            break;
                        }
                        ((SlotFluidConvertingFake)slot).putConvertedStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                        break;
                    }
                    if (stack.func_190926_b()) break;
                    ((SlotFluidConvertingFake)slot).putConvertedStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                }
            }
        } else {
            super.doAction(player, action, slotId, id);
        }
    }

    @Override
    public void acceptPattern(Int2ObjectMap<ItemStack[]> inputs, List<ItemStack> outputs, boolean combine) {
        int index;
        AeStackInventory<IAEItemStack> craftingSlot = this.tile.getCraftingSlots();
        AeStackInventory<IAEItemStack> outputSlot = this.tile.getOutputSlots();
        IntIterator intIterator = inputs.keySet().iterator();
        while (intIterator.hasNext()) {
            index = (Integer)intIterator.next();
            ItemStack[] items = (ItemStack[])inputs.get(index);
            if (index >= craftingSlot.getSlotCount() || items.length <= 0) continue;
            craftingSlot.setStack(index, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)items[0]));
        }
        int bound = Math.min(outputSlot.getSlotCount(), outputs.size());
        for (index = 0; index < bound; ++index) {
            outputSlot.setStack(index, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)outputs.get(index)));
        }
    }

    private static class SlotFluidConvertingFake
    extends SlotFake
    implements SlotFluid {
        private final AeStackInventory<IAEItemStack> inv;

        public SlotFluidConvertingFake(AeItemStackHandler inv, int idx, int x, int y) {
            super((IItemHandler)inv, idx, x, y);
            this.inv = inv.getAeInventory();
        }

        public void func_75215_d(ItemStack stack) {
            this.inv.setStack(this.getSlotIndex(), (IAEItemStack)AEItemStack.fromItemStack((ItemStack)stack));
        }

        @Override
        public void setAeStack(@Nullable IAEItemStack stack, boolean sync) {
            this.inv.setStack(this.getSlotIndex(), stack);
        }

        public void putConvertedStack(ItemStack stack) {
            if (stack.func_190926_b()) {
                this.setAeStack(null, false);
                return;
            }
            if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                IFluidTankProperties[] tanks;
                for (IFluidTankProperties tank : tanks = ((IFluidHandlerItem)Objects.requireNonNull(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null))).getTankProperties()) {
                    IAEItemStack aeStack = FakeFluids.packFluid2AEPacket(tank.getContents());
                    if (aeStack == null) continue;
                    this.setAeStack(aeStack, false);
                    return;
                }
            } else if (ModAndClassUtil.GAS && stack.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, null)) {
                GasTankInfo[] tanks;
                for (GasTankInfo tank : tanks = ((IGasHandler)Objects.requireNonNull(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY, null))).getTankInfo()) {
                    IAEItemStack aeStack = FakeGases.packGas2AEPacket(tank.getGas());
                    if (aeStack == null) continue;
                    this.setAeStack(aeStack, false);
                    return;
                }
            }
            this.func_75215_d(stack);
        }

        @Override
        @Nullable
        public IAEItemStack getAeStack() {
            return this.inv.getStack(this.getSlotIndex());
        }
    }
}

