/*
 * Decompiled with CFR 0.152.
 */
package me.saxon564.mochickens.world.dimensions.chicken.structures;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.saxon564.mochickens.world.dimensions.chicken.structures.VillageBuildings;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipeList;

public class VillagerRegistry {
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Multimap<Integer, IVillageTradeHandler> tradeHandlers = ArrayListMultimap.create();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, ResourceLocation> newVillagers;

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe((String)"Attempt to register duplicate villager id %d", (Object[])new Object[]{id});
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerVillagerSkin(int villagerId, ResourceLocation villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public void registerVillageTradeHandler(int villagerId, IVillageTradeHandler handler) {
        this.tradeHandlers.put((Object)villagerId, (Object)handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getVillagerSkin(int villagerType, ResourceLocation defaultSkin) {
        if (VillagerRegistry.instance().newVillagers != null && VillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return VillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(VillagerRegistry.instance().newVillagerIds);
    }

    public static void manageVillagerTrades(MerchantRecipeList recipeList, EntityVillager villager, int villagerType, Random random) {
        for (IVillageTradeHandler handler : VillagerRegistry.instance().tradeHandlers.get((Object)villagerType)) {
            handler.manipulateTradesForVillager(villager, recipeList, random);
        }
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(VillageBuildings.PieceWeight villagePiece, VillageBuildings.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.villagePieceClass).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    public static void addEmeraldBuyRecipe(EntityVillager villager, MerchantRecipeList list, Random random, Item item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            EntityVillager.field_70958_bB.put(item, new Tuple((Object)min, (Object)max));
        }
        EntityVillager.func_146091_a((MerchantRecipeList)list, (Item)item, (Random)random, (float)chance);
    }

    public static void addEmeraldSellRecipe(EntityVillager villager, MerchantRecipeList list, Random random, Item item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            EntityVillager.field_70960_bC.put(item, new Tuple((Object)min, (Object)max));
        }
        EntityVillager.func_146089_b((MerchantRecipeList)list, (Item)item, (Random)random, (float)chance);
    }

    public static void applyRandomTrade(EntityVillager villager, Random rand) {
        int extra = VillagerRegistry.instance().newVillagerIds.size();
        int trade = rand.nextInt(5 + extra);
        villager.func_70938_b(trade < 5 ? trade : VillagerRegistry.instance().newVillagerIds.get(trade - 5));
    }

    public static interface IVillageTradeHandler {
        public void manipulateTradesForVillager(EntityVillager var1, MerchantRecipeList var2, Random var3);
    }

    public static interface IVillageCreationHandler {
        public VillageBuildings.PieceWeight getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(VillageBuildings.PieceWeight var1, VillageBuildings.Start var2, List var3, Random var4, int var5, int var6, int var7, int var8, int var9);
    }
}

