/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import vapourdrive.hammerz.Hammerz;
import vapourdrive.hammerz.Reference;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.utils.RandomUtils;

public class Hammer
extends ItemPickaxe {
    public String name;

    public Hammer(Item.ToolMaterial material, String Name) {
        super(material);
        this.func_77655_b(Name + "Hammer");
        this.func_77637_a(Hammerz.HZTab);
        this.func_77656_e((int)((float)this.func_77612_l() * ConfigOptions.DurabilityMultiplier));
        this.name = Name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(Reference.ResourcePath + this.name + "Hammer");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        this.addPermanentInfo(stack, player, list, useExtraInformation);
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            this.addExpandedInfo(stack, player, list, useExtraInformation);
        } else {
            this.addStandardInfo(stack, player, list, useExtraInformation);
        }
    }

    public void addStandardInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"phrase.hammerz.holdshift"));
        if (ConfigOptions.AddDurabilityInfo) {
            list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"hammerz.keyword.durability") + ": " + (stack.func_77958_k() - stack.func_77960_j()) + "/" + stack.func_77958_k());
        }
    }

    public void addExpandedInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"phrase.hammerz.hammerinfo1"));
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"phrase.hammerz.hammerinfo2"));
    }

    public void addPermanentInfo(ItemStack stack, EntityPlayer player, List list, boolean useExtraInformation) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (player.func_70093_af() && ConfigOptions.CanShiftMine || block.func_149712_f(world, x, y, z) == 0.0f) {
            return false;
        }
        MovingObjectPosition object = RandomUtils.raytraceFromEntity(world, (Entity)player, false, 4.5);
        if (object == null) {
            return super.func_150894_a(stack, world, block, x, y, z, (EntityLivingBase)player);
        }
        int side = object.field_72310_e;
        int xmove = 0;
        int ymove = 0;
        int zmove = 0;
        if (side == 0 || side == 1) {
            xmove = 1;
            zmove = 1;
        } else {
            ymove = 1;
            if (side == 4 || side == 5) {
                zmove = 1;
            } else {
                xmove = 1;
            }
        }
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        for (int i = -xmove; i <= xmove; ++i) {
            for (int j = -ymove; j <= ymove; ++j) {
                for (int k = -zmove; k <= zmove; ++k) {
                    if (x + i == x && y + j == y && z + k == z) continue;
                    this.checkBlockBreak(world, player, x + i, y + j, z + k, stack, strength, block, side);
                }
            }
        }
        return false;
    }

    public void checkBlockBreak(World world, EntityPlayer player, int x, int y, int z, ItemStack stack, float strength, Block originalBlock, int side) {
        float newStrength;
        Block breakBlock = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        Material material = originalBlock.func_149688_o();
        if (breakBlock.func_149688_o() == material && ForgeHooks.canHarvestBlock((Block)breakBlock, (EntityPlayer)player, (int)metadata) && stack.func_77973_b().func_150897_b(breakBlock) && (newStrength = ForgeHooks.blockStrength((Block)breakBlock, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z)) > 0.0f && strength / newStrength <= 10.0f) {
            if ((double)breakBlock.func_149712_f(world, x, y, z) != 0.0) {
                if (this.handleDamage(breakBlock, stack, player)) {
                    RandomUtils.breakBlock(world, breakBlock, x, y, z, side, player);
                }
            } else {
                RandomUtils.breakBlock(world, breakBlock, x, y, z, side, player);
            }
        }
    }

    public void log(World world, Object object) {
        if (world.field_72995_K) {
            Hammerz.log.log(Level.INFO, object);
        }
    }

    public boolean requestDamage(Block breakBlock, ItemStack stack, EntityPlayer player, int damage) {
        if (stack.func_77958_k() - stack.func_77960_j() < damage) {
            return false;
        }
        stack.func_77972_a(damage, (EntityLivingBase)player);
        return stack.field_77994_a != 0;
    }

    public boolean handleDamage(Block breakBlock, ItemStack stack, EntityPlayer player) {
        return this.requestDamage(breakBlock, stack, player, 1);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return super.getDigSpeed(stack, block, meta) * ConfigOptions.EfficiencyMultiplier;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float floatx, float floaty, float floatz) {
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof Hammer) {
            if (!player.func_70093_af()) {
                ItemStack torchStack = new ItemStack(Blocks.field_150478_aa);
                if (player.field_71071_by.func_70431_c(torchStack) && torchStack.func_77973_b().func_77648_a(torchStack, player, world, x, y, z, side, floatx, floaty, floatz)) {
                    player.field_71071_by.func_146026_a(torchStack.func_77973_b());
                    return true;
                }
            } else {
                return this.onItemShiftUse(stack, player, world, x, y, z, side, floatx, floaty, floatz);
            }
        }
        return false;
    }

    public boolean onItemShiftUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float floatx, float floaty, float floatz) {
        return false;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        int[] names = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < names.length; ++i) {
            if (!("block" + this.name).contentEquals(OreDictionary.getOreName((int)names[i]))) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
    }
}

