/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.items;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import vapourdrive.hammerz.Hammerz;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.config.HammerzConfig;
import vapourdrive.hammerz.items.BedrockHammer;
import vapourdrive.hammerz.items.ChameleonHammer;
import vapourdrive.hammerz.items.DarkHammer;
import vapourdrive.hammerz.items.ElementalHammer;
import vapourdrive.hammerz.items.ElvenElementiumHammer;
import vapourdrive.hammerz.items.Hammer;
import vapourdrive.hammerz.items.ManasteelHammer;
import vapourdrive.hammerz.items.ThaumiumHammer;
import vapourdrive.hammerz.items.VoidHammer;

public class HZ_Items {
    public static LinkedHashMap<Item, String> oreDictItems = new LinkedHashMap();
    public static Item WoodHammer;
    public static Item StoneHammer;
    public static Item IronHammer;
    public static Item GoldHammer;
    public static Item DiamondHammer;
    public static Item CopperHammer;
    public static Item TinHammer;
    public static Item SilverHammer;
    public static Item LeadHammer;
    public static Item NickelHammer;
    public static Item ElectrumHammer;
    public static Item InvarHammer;
    public static Item BronzeHammer;
    public static Item PlatinumHammer;
    public static Item DarkSteelHammer;
    public static Item SteelHammer;
    public static Item ThaumiumHammer;
    public static Item ManasteelHammer;
    public static Item ElvenElementiumHammer;
    public static Item HSLAHammer;
    public static Item BedrockHammer;
    public static Item VoidHammer;
    public static Item ElementalHammer;
    public static Item ChameleonHammer;

    public static void preInit() {
        CopperHammer = new Hammer(EnumHelper.addToolMaterial((String)"Copper", (int)1, (int)175, (float)4.0f, (float)0.5f, (int)6), "Copper");
        TinHammer = new Hammer(EnumHelper.addToolMaterial((String)"Tin", (int)1, (int)200, (float)4.5f, (float)1.0f, (int)7), "Tin");
        SilverHammer = new Hammer(EnumHelper.addToolMaterial((String)"Silver", (int)2, (int)200, (float)6.0f, (float)1.5f, (int)20), "Silver");
        LeadHammer = new Hammer(EnumHelper.addToolMaterial((String)"Lead", (int)1, (int)150, (float)5.0f, (float)1.0f, (int)9), "Lead");
        NickelHammer = new Hammer(EnumHelper.addToolMaterial((String)"Nickel", (int)2, (int)300, (float)6.5f, (float)2.5f, (int)18), "Nickel");
        ElectrumHammer = new Hammer(EnumHelper.addToolMaterial((String)"Electrum", (int)0, (int)100, (float)14.0f, (float)0.5f, (int)30), "Electrum");
        InvarHammer = new Hammer(EnumHelper.addToolMaterial((String)"Invar", (int)2, (int)450, (float)7.0f, (float)3.0f, (int)16), "Invar");
        BronzeHammer = new Hammer(EnumHelper.addToolMaterial((String)"Bronze", (int)2, (int)500, (float)6.0f, (float)2.0f, (int)15), "Bronze");
        PlatinumHammer = new Hammer(EnumHelper.addToolMaterial((String)"Platinum", (int)4, (int)1700, (float)9.0f, (float)4.0f, (int)9), "Platinum");
        SteelHammer = new Hammer(EnumHelper.addToolMaterial((String)"Steel", (int)2, (int)500, (float)7.0f, (float)2.0f, (int)9), "Steel");
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Hammerz.log.log(Level.INFO, "ThaumcraftCompat loading");
            ThaumiumHammer = new ThaumiumHammer("Thaumium");
            VoidHammer = new VoidHammer("Void");
            ElementalHammer = new ElementalHammer("Elemental");
            Hammerz.hasStorageBlock = true;
            if (Loader.isModLoaded((String)"ForbiddenMagic")) {
                Hammerz.log.log(Level.INFO, "Forbidden Magic Compat loading");
                ChameleonHammer = new ChameleonHammer("Chameleon");
            }
        }
        if (Loader.isModLoaded((String)"Botania")) {
            Hammerz.log.log(Level.INFO, "BotaniaCompat loading");
            ManasteelHammer = new ManasteelHammer("Manasteel");
            ElvenElementiumHammer = new ElvenElementiumHammer("ElvenElementium");
        }
        if (Loader.isModLoaded((String)"EnderIO")) {
            Hammerz.log.log(Level.INFO, "EnderIOCompat loading");
            DarkSteelHammer = new DarkHammer(EnumHelper.addToolMaterial((String)"DarkSteel", (int)5, (int)1561, (float)7.0f, (float)2.0f, (int)25), "DarkSteel");
        }
        if (Loader.isModLoaded((String)"RotaryCraft")) {
            Hammerz.log.log(Level.INFO, "RotaryCraftCompat loading");
            HSLAHammer = new Hammer(EnumHelper.addToolMaterial((String)"HSLA", (int)2, (int)600, (float)6.0f, (float)3.0f, (int)14), "HSLA");
            BedrockHammer = new BedrockHammer(EnumHelper.addToolMaterial((String)"Bedrock", (int)3, (int)0, (float)8.0f, (float)3.0f, (int)10), "Bedrock");
        }
        WoodHammer = new Hammer(Item.ToolMaterial.WOOD, "Wood");
        StoneHammer = new Hammer(Item.ToolMaterial.STONE, "Stone");
        IronHammer = new Hammer(Item.ToolMaterial.IRON, "Iron");
        GoldHammer = new Hammer(Item.ToolMaterial.GOLD, "Gold");
        DiamondHammer = new Hammer(Item.ToolMaterial.EMERALD, "Diamond");
        HZ_Items.setupOreDictionaryHammer(CopperHammer, "Copper", ConfigOptions.OreDictHammerEnabling, 0);
        HZ_Items.setupOreDictionaryHammer(TinHammer, "Tin", ConfigOptions.OreDictHammerEnabling, 1);
        HZ_Items.setupOreDictionaryHammer(SilverHammer, "Silver", ConfigOptions.OreDictHammerEnabling, 2);
        HZ_Items.setupOreDictionaryHammer(LeadHammer, "Lead", ConfigOptions.OreDictHammerEnabling, 3);
        HZ_Items.setupOreDictionaryHammer(NickelHammer, "Nickel", ConfigOptions.OreDictHammerEnabling, 4);
        HZ_Items.setupOreDictionaryHammer(ElectrumHammer, "Electrum", ConfigOptions.OreDictHammerEnabling, 5);
        HZ_Items.setupOreDictionaryHammer(InvarHammer, "Invar", ConfigOptions.OreDictHammerEnabling, 6);
        HZ_Items.setupOreDictionaryHammer(BronzeHammer, "Bronze", ConfigOptions.OreDictHammerEnabling, 7);
        HZ_Items.setupOreDictionaryHammer(PlatinumHammer, "Platinum", ConfigOptions.OreDictHammerEnabling, 8);
        HZ_Items.setupOreDictionaryHammer(SteelHammer, "Steel", ConfigOptions.OreDictHammerEnabling, 9);
    }

    public static void init() {
        HZ_Items.registerItem(WoodHammer, "WoodHammer", ConfigOptions.VanillaHammerEnabling, 0);
        HZ_Items.registerItem(StoneHammer, "StoneHammer", ConfigOptions.VanillaHammerEnabling, 1);
        HZ_Items.registerItem(IronHammer, "IronHammer", ConfigOptions.VanillaHammerEnabling, 2);
        HZ_Items.registerItem(GoldHammer, "GoldHammer", ConfigOptions.VanillaHammerEnabling, 3);
        HZ_Items.registerItem(DiamondHammer, "DiamondHammer", ConfigOptions.VanillaHammerEnabling, 4);
        if (Loader.isModLoaded((String)"EnderIO")) {
            HZ_Items.registerItem(DarkSteelHammer, "DarkSteelHammer", ConfigOptions.EnderIOHammerEnabling, 0);
        }
        if (Loader.isModLoaded((String)"Botania")) {
            HZ_Items.registerItem(ManasteelHammer, "Manasteel", ConfigOptions.BotaniaHammersEnabling, 0);
            HZ_Items.registerItem(ElvenElementiumHammer, "ElvenElementium", ConfigOptions.BotaniaHammersEnabling, 1);
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            HZ_Items.registerItem(ThaumiumHammer, "Thaumium", ConfigOptions.ThaumcraftHammerEnabling, 0);
            HZ_Items.registerItem(VoidHammer, "Void", ConfigOptions.ThaumcraftHammerEnabling, 1);
            HZ_Items.registerItem(ElementalHammer, "Elemental", ConfigOptions.ThaumcraftHammerEnabling, 2);
            if (Loader.isModLoaded((String)"ForbiddenMagic")) {
                HZ_Items.registerItem(ChameleonHammer, "Chameleon", ConfigOptions.ForbiddenMagicHammerEnabling, 0);
            }
        }
        if (Loader.isModLoaded((String)"RotaryCraft")) {
            HZ_Items.registerItem(HSLAHammer, "HSLA", ConfigOptions.RotaryCraftHammerEnabling, 0);
            HZ_Items.registerItem(BedrockHammer, "Bedrock", ConfigOptions.RotaryCraftHammerEnabling, 1);
        }
        HZ_Items.registerOreDictHammers(oreDictItems, ConfigOptions.OreDictHammerEnabling);
    }

    public static void registerItem(Item item, String name, boolean[] hammerEnabling, int booleanCheck) {
        if (hammerEnabling[booleanCheck]) {
            GameRegistry.registerItem((Item)item, (String)name);
        }
    }

    private static void setupOreDictionaryHammer(Item item, String name, boolean[] hammerEnabling, int i) {
        HZ_Items.setupOreDictionaryHammer(false, "", item, name, hammerEnabling, i);
    }

    private static void setupOreDictionaryHammer(Boolean requiresMod, String ModId, Item item, String name, boolean[] hammerEnabling, int i) {
        if (OreDictionary.doesOreNameExist((String)("block" + name))) {
            oreDictItems.put(item, name);
            HammerzConfig.enabledOreDictHammersComment = HammerzConfig.enabledOreDictHammersComment + name + ", ";
            HammerzConfig.enabledOreDictHammersArrayList.add(true);
        }
    }

    public static void registerOreDictHammers(HashMap<Item, String> map, boolean[] hammerEnabling) {
        Set<Map.Entry<Item, String>> set = map.entrySet();
        Iterator<Map.Entry<Item, String>> iterator = set.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<Item, String> entry = iterator.next();
            if (hammerEnabling[i]) {
                GameRegistry.registerItem((Item)entry.getKey(), (String)(entry.getValue() + "Hammer"));
            }
            ++i;
        }
    }
}

