/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import vapourdrive.hammerz.items.HZ_Items;

public class DropHandler {
    static final List<String> validBlocks = Arrays.asList("dirt", "sand", "gravel", "cobblestone", "netherrack");

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack stack;
        if (event.harvester != null && (stack = event.harvester.func_71045_bC()) != null) {
            Block block;
            ItemStack drop;
            int i;
            if (stack.func_77973_b() == HZ_Items.ElvenElementiumHammer) {
                for (i = 0; i < event.drops.size(); ++i) {
                    drop = (ItemStack)event.drops.get(i);
                    if (drop == null || (block = Block.func_149634_a((Item)drop.func_77973_b())) == null || !DropHandler.isDisposable(block)) continue;
                    event.drops.remove(i);
                }
            }
            if (stack.func_77973_b() == HZ_Items.ElementalHammer) {
                for (i = 0; i < event.drops.size(); ++i) {
                    drop = (ItemStack)event.drops.get(i);
                    if (drop == null) continue;
                    block = Block.func_149634_a((Item)drop.func_77973_b());
                    ItemStack oreCluster = this.getOreCluster(event.harvester, drop);
                    if (block == null || oreCluster == null) continue;
                    event.drops.remove(i);
                    event.drops.add(oreCluster);
                }
            }
        }
    }

    public ItemStack getOreCluster(EntityPlayer harvester, ItemStack drop) {
        float chance = 0.33f;
        chance += 0.14f * (float)EnchantmentHelper.func_77517_e((EntityLivingBase)harvester);
        Random random = new Random();
        if (random.nextFloat() <= chance) {
            int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(drop.func_77973_b(), 1, drop.func_77960_j()));
            for (int i = 0; i < ids.length; ++i) {
                ItemStack cluster;
                String name = OreDictionary.getOreName((int)ids[i]);
                ArrayList clusterList = OreDictionary.getOres((String)name.replace("ore", "cluster"));
                if (clusterList.isEmpty() || (cluster = (ItemStack)clusterList.get(0)) == null) continue;
                return cluster.func_77946_l();
            }
        }
        return null;
    }

    public static boolean isDisposable(Block block) {
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            if (!validBlocks.contains(OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }
}

