/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.hammerz;

import Reika.RotaryCraft.API.RecipeInterface;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import vapourdrive.hammerz.config.ConfigOptions;
import vapourdrive.hammerz.items.HZ_Items;
import vapourdrive.hammerz.utils.RandomUtils;

@Optional.Interface(modid="RotaryCraft", iface="Reika.RotaryCraft.API.RecipeInterface", striprefs=true)
public class Recipes {
    public static HashMap<Item, IRecipe> recipes = new HashMap();

    public static void init() {
        Recipes.registerStorageBlockRecipe("ingotVoid", "blockVoid");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.WoodHammer, Blocks.field_150364_r);
        Recipes.registerHammerRecipe("stickWood", HZ_Items.StoneHammer, Blocks.field_150348_b);
        Recipes.registerHammerRecipe("stickWood", HZ_Items.IronHammer, Blocks.field_150339_S);
        Recipes.registerHammerRecipe("stickWood", HZ_Items.GoldHammer, Blocks.field_150340_R);
        Recipes.registerHammerRecipe("stickWood", HZ_Items.DiamondHammer, Blocks.field_150484_ah);
        Recipes.registerHammerRecipe("stickWood", HZ_Items.DarkSteelHammer, "blockDarkSteel");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.CopperHammer, "blockCopper");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.TinHammer, "blockTin");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.SilverHammer, "blockSilver");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.LeadHammer, "blockLead");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.NickelHammer, "blockNickel");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.ElectrumHammer, "blockElectrum");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.InvarHammer, "blockInvar");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.BronzeHammer, "blockBronze");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.PlatinumHammer, "blockPlatinum");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.SteelHammer, "blockSteel");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.ThaumiumHammer, "blockThaumium");
        Recipes.registerHammerRecipe("stickWood", HZ_Items.VoidHammer, "blockVoid");
        Recipes.registerHammerRecipe("livingwoodTwig", HZ_Items.ManasteelHammer, "blockManasteel");
        Recipes.registerHammerRecipe("dreamwoodTwig", HZ_Items.ElvenElementiumHammer, "blockElvenElementium");
    }

    public static void registerStorageBlockRecipe(String ingot, String block) {
        ArrayList blocks = OreDictionary.getOres((String)block);
        for (ItemStack stack : blocks) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(stack, new Object[]{"iii", "iii", "iii", Character.valueOf('i'), ingot}));
        }
        ArrayList ingots = OreDictionary.getOres((String)ingot);
        for (ItemStack stack : ingots) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(stack.func_77973_b(), 9, stack.func_77960_j()), new Object[]{block}));
        }
    }

    public static void registerHammerRecipe(String stick, Item result, Block block) {
        Recipes.registerHammerRecipe(stick, result, new ItemStack(block));
    }

    public static void registerHammerRecipe(String stick, Item result, Item item) {
        Recipes.registerHammerRecipe(stick, result, new ItemStack(item));
    }

    public static void registerHammerRecipe(String stick, Item result, ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        for (int i = 0; i < ids.length; ++i) {
            ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack(result), new Object[]{"bbb", " s ", " s ", Character.valueOf('s'), stick, Character.valueOf('b'), OreDictionary.getOreName((int)ids[i])});
            GameRegistry.addRecipe((IRecipe)recipe);
            recipes.put(result, (IRecipe)recipe);
        }
    }

    public static void registerHammerRecipe(String stick, Item result, String OreDict) {
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack(result), new Object[]{"bbb", " s ", " s ", Character.valueOf('s'), stick, Character.valueOf('b'), OreDict});
        GameRegistry.addRecipe((IRecipe)recipe);
        recipes.put(result, (IRecipe)recipe);
    }

    public static void registerRotaryCraftRecipe() {
        ItemStack hammer = new ItemStack(HZ_Items.BedrockHammer);
        if (ConfigOptions.RotaryCraftSilkTouch) {
            hammer.func_77966_a(Enchantment.field_77348_q, 1);
        }
        ItemStack bedrock = new ItemStack(RandomUtils.getItemStackFromString("RotaryCraft", "rotarycraft_block_deco", 1).func_77973_b(), 1, 4);
        ItemStack shaft = new ItemStack(RandomUtils.getItemStackFromString("RotaryCraft", "rotarycraft_item_shaftcraft", 1).func_77973_b(), 1, 2);
        ShapedOreRecipe recipe = new ShapedOreRecipe(hammer, new Object[]{"DDD", " S ", " S ", Character.valueOf('D'), bedrock, Character.valueOf('S'), shaft});
        RecipeInterface.blastfurn.addAPIRecipe(hammer, 1000, (IRecipe)recipe, 4, 0.0f);
        recipes.put(hammer.func_77973_b(), (IRecipe)recipe);
    }
}

