/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.skill.hunter;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.nevermine.assist.AddPackets;
import net.nevermine.skill.hunter.hunterMessage;

public class hunterHelper
implements IExtendedEntityProperties {
    private final EntityPlayer player;
    private static final String NAME = "HunterSkill";
    private float exp;
    private int level;

    public hunterHelper(EntityPlayer player) {
        this.player = player;
        this.level = 1;
        this.exp = 0.0f;
    }

    public void saveNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        tag.func_74768_a("HLevel", this.level);
        tag.func_74776_a("HExp", this.exp);
        n.func_74782_a(NAME, (NBTBase)tag);
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public static void addProperties(EntityPlayer player) {
        player.registerExtendedProperties(NAME, (IExtendedEntityProperties)new hunterHelper(player));
    }

    public static hunterHelper getProperties(EntityPlayer player) {
        return (hunterHelper)player.getExtendedProperties(NAME);
    }

    public void loadNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (!tag.func_74764_b("HLevel")) {
            return;
        }
        this.level = tag.func_74762_e("HLevel");
        this.exp = tag.func_74760_g("HExp");
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public int getLevel() {
        return this.level;
    }

    public float getExperience() {
        return this.exp;
    }

    public float getExpRequired() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0);
    }

    public void setExperience(float i) {
        this.exp = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new hunterMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public void setLevel(int i) {
        this.level = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new hunterMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public int progressPercentage() {
        return (int)Math.floor(this.exp / this.getExpRequired() * 100.0f);
    }

    public void levelUp() {
        if (this.level != 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:LevelUp", 3.85f, 1.0f);
        }
        ++this.level;
        if (this.level == 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:Level100", 3.85f, 1.0f);
        }
        if (this.level == 101) {
            this.level = 100;
        }
        this.exp = 0.0f;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new hunterMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public float getExpLeft() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0) - this.exp;
    }

    public void addExperience(float i) {
        if (i > this.getExpLeft()) {
            float x = i;
            boolean run = true;
            while (run) {
                if (x > this.getExpLeft()) {
                    x -= this.getExpLeft();
                    this.levelUp();
                    continue;
                }
                this.exp += x;
                run = false;
                if (!(this.player instanceof EntityPlayerMP)) continue;
                AddPackets.network.sendTo((IMessage)new hunterMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
            }
        } else {
            this.exp += i;
            if (this.exp >= this.getExpRequired()) {
                this.levelUp();
            } else if (this.player instanceof EntityPlayerMP) {
                AddPackets.network.sendTo((IMessage)new hunterMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
            }
        }
    }

    @SubscribeEvent
    public void init(Entity entity, World world) {
    }
}

