/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.skill.extraction;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.nevermine.assist.AddPackets;
import net.nevermine.skill.extraction.extractionMessage;

public class extractionHelper
implements IExtendedEntityProperties {
    private final EntityPlayer player;
    private static final String NAME = "vitalitySkill";
    private float exp;
    private int level;

    public extractionHelper(EntityPlayer player) {
        this.player = player;
        this.level = 1;
        this.exp = 0.0f;
    }

    public void saveNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        tag.func_74768_a("VtLevel", this.level);
        tag.func_74776_a("VtExp", this.exp);
        n.func_74782_a(NAME, (NBTBase)tag);
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public static void addProperties(EntityPlayer player) {
        player.registerExtendedProperties(NAME, (IExtendedEntityProperties)new extractionHelper(player));
    }

    public static extractionHelper getProperties(EntityPlayer player) {
        return (extractionHelper)player.getExtendedProperties(NAME);
    }

    public void loadNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (!tag.func_74764_b("VtLevel")) {
            return;
        }
        this.level = tag.func_74762_e("VtLevel");
        this.exp = tag.func_74760_g("VtExp");
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public int getLevel() {
        return this.level;
    }

    public int getSmeltingExpAdded() {
        if (this.level <= 2) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 5.0);
        }
        if (this.level <= 8) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 10.0);
        }
        if (this.level <= 16) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 20.0);
        }
        if (this.level <= 25) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 35.0);
        }
        if (this.level <= 40) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 60.0);
        }
        if (this.level <= 60) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 90.0);
        }
        if (this.level <= 75) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 150.0);
        }
        if (this.level <= 100) {
            return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 300.0);
        }
        return (int)(Math.pow(1.1, this.level - 1) * 50.0 / 500.0);
    }

    public float getExperience() {
        return this.exp;
    }

    public float getExpRequired() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0);
    }

    public void setExperience(float i) {
        this.exp = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new extractionMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public void setLevel(int i) {
        this.level = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new extractionMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public int progressPercentage() {
        return (int)Math.floor(this.exp / this.getExpRequired() * 100.0f);
    }

    public void levelUp() {
        if (this.level != 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:LevelUp", 3.85f, 1.0f);
        }
        ++this.level;
        if (this.level == 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:Level100", 3.85f, 1.0f);
        }
        if (this.level == 101) {
            this.level = 100;
        }
        this.exp = 0.0f;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new extractionMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    public float getExpLeft() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0) - this.exp;
    }

    public void addExperience(float i) {
        this.exp += i;
        if (this.exp >= this.getExpRequired()) {
            this.levelUp();
        } else if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new extractionMessage(this.level, this.progressPercentage()), (EntityPlayerMP)this.player);
        }
    }

    @SubscribeEvent
    public void init(Entity entity, World world) {
    }
}

