/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.skill.expedition;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.nevermine.assist.AddPackets;
import net.nevermine.skill.expedition.expeditionMessage;

public class expeditionHelper
implements IExtendedEntityProperties {
    private final EntityPlayer player;
    private static final String NAME = "expeditionSkill";
    private float exp;
    private int level;
    private int boost = 1;

    public expeditionHelper(EntityPlayer player) {
        this.player = player;
        this.level = 1;
        this.exp = 0.0f;
    }

    public void saveNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        tag.func_74768_a("ExLevel", this.level);
        tag.func_74776_a("ExExp", this.exp);
        tag.func_74768_a("ExBoost", this.boost);
        n.func_74782_a(NAME, (NBTBase)tag);
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public static void addProperties(EntityPlayer player) {
        player.registerExtendedProperties(NAME, (IExtendedEntityProperties)new expeditionHelper(player));
    }

    public static expeditionHelper getProperties(EntityPlayer player) {
        return (expeditionHelper)player.getExtendedProperties(NAME);
    }

    public int getBoost() {
        return this.boost;
    }

    public void setBoost(int i) {
        this.boost = i;
    }

    public void boostUp() {
        ++this.boost;
        if (this.boost == 4) {
            this.boost = 0;
        }
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
        }
    }

    public void loadNBTData(NBTTagCompound n) {
        NBTTagCompound tag = this.player.getEntityData().func_74775_l("PlayerPersisted");
        if (!tag.func_74764_b("ExLevel")) {
            return;
        }
        this.level = tag.func_74762_e("ExLevel");
        this.exp = tag.func_74760_g("ExExp");
        this.boost = tag.func_74762_e("ExBoost");
        this.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
    }

    public int getLevel() {
        return this.level;
    }

    public float getExperience() {
        return this.exp;
    }

    public float getExpRequired() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0);
    }

    public int denominator() {
        if (this.level <= 4) {
            return 22;
        }
        if (this.level <= 9) {
            return 35;
        }
        if (this.level <= 14) {
            return 45;
        }
        if (this.level <= 29) {
            return 65;
        }
        if (this.level <= 24) {
            return 90;
        }
        if (this.level <= 39) {
            return 120;
        }
        if (this.level <= 34) {
            return 150;
        }
        if (this.level <= 49) {
            return 190;
        }
        if (this.level <= 44) {
            return 230;
        }
        if (this.level <= 59) {
            return 280;
        }
        if (this.level <= 54) {
            return 360;
        }
        if (this.level <= 69) {
            return 450;
        }
        if (this.level <= 64) {
            return 540;
        }
        if (this.level <= 79) {
            return 650;
        }
        if (this.level <= 74) {
            return 750;
        }
        if (this.level <= 89) {
            return 850;
        }
        if (this.level <= 84) {
            return 950;
        }
        if (this.level <= 99) {
            return 1000;
        }
        if (this.level <= 94) {
            return 1100;
        }
        if (this.level <= 97) {
            return 1200;
        }
        return 1300;
    }

    public void setExperience(float i) {
        this.exp = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
        }
    }

    public void setLevel(int i) {
        this.level = i;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
        }
    }

    public int progressPercentage() {
        return (int)Math.floor(this.exp / this.getExpRequired() * 100.0f);
    }

    public void levelUp() {
        if (this.level != 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:LevelUp", 3.85f, 1.0f);
        }
        ++this.level;
        if (this.level == 100) {
            this.player.field_70170_p.func_72956_a((Entity)this.player, "nevermine:Level100", 3.85f, 1.0f);
        }
        if (this.level == 101) {
            this.level = 100;
        }
        this.exp = 0.0f;
        if (this.player instanceof EntityPlayerMP) {
            AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
        }
    }

    public float getExpLeft() {
        return (float)(Math.pow(1.1, this.level - 1) * 50.0) - this.exp;
    }

    public void addExperience(float i) {
        if (i > this.getExpLeft()) {
            float x = i;
            boolean run = true;
            while (run) {
                if (x > this.getExpLeft()) {
                    x -= this.getExpLeft();
                    this.levelUp();
                    continue;
                }
                this.exp += x;
                run = false;
                if (!(this.player instanceof EntityPlayerMP)) continue;
                AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
            }
        } else {
            this.exp += i;
            if (this.exp >= this.getExpRequired()) {
                this.levelUp();
            } else if (this.player instanceof EntityPlayerMP) {
                AddPackets.network.sendTo((IMessage)new expeditionMessage(this.level, this.progressPercentage(), this.boost), (EntityPlayerMP)this.player);
            }
        }
    }

    @SubscribeEvent
    public void init(Entity entity, World world) {
    }
}

