/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.rendering.indiv;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GreatbladeRender
implements IItemRenderer {
    private final float scale;

    public GreatbladeRender(float scale) {
        this.scale = scale;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                this.renderEquippedItem(item, (EntityLivingBase)data[1], true);
                break;
            }
            case EQUIPPED: {
                this.renderEquippedItem(item, (EntityLivingBase)data[1], false);
                break;
            }
        }
    }

    private void renderEquippedItem(ItemStack stack, EntityLivingBase entity, boolean firstPerson) {
        GL11.glPushMatrix();
        float f = this.scale;
        if (firstPerson) {
            GL11.glTranslatef((float)1.2f, (float)(-0.7f * this.scale), (float)0.0f);
            GL11.glScalef((float)(f *= 1.75f), (float)f, (float)f);
            GL11.glRotatef((float)80.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        } else {
            GL11.glTranslatef((float)(2.9f - (f *= entity instanceof EntityPlayer ? 2.0f : 1.75f)), (float)(-0.04f * this.scale), (float)(0.05f * this.scale));
            GL11.glScalef((float)f, (float)f, (float)f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        IIcon icon = stack.func_77973_b().getIcon(stack, 0);
        Tessellator tessellator = Tessellator.field_78398_a;
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        GL11.glPopMatrix();
    }
}

