/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.dimension.voxponds;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.nevermine.izer.Blockizer;
import net.nevermine.izer.SpecialBlockizer;
import net.nevermine.structures.voxponds.ControlTower;
import net.nevermine.structures.voxponds.DeadTree1;
import net.nevermine.structures.voxponds.DeadTree2;
import net.nevermine.structures.voxponds.DeadTree3;
import net.nevermine.structures.voxponds.DestroyedStore1;
import net.nevermine.structures.voxponds.DestroyedStore2;
import net.nevermine.structures.voxponds.EnigmaStation;
import net.nevermine.structures.voxponds.ExoidPlatform;
import net.nevermine.structures.voxponds.GroundVoxLight;
import net.nevermine.structures.voxponds.HangingVoxLight;
import net.nevermine.structures.voxponds.IVoxpondsStructure;
import net.nevermine.structures.voxponds.IntelligenceTower;
import net.nevermine.structures.voxponds.LottoVoxStructure;
import net.nevermine.structures.voxponds.MiniTentacles;
import net.nevermine.structures.voxponds.NightwingPlatform;
import net.nevermine.structures.voxponds.ObservationTower;
import net.nevermine.structures.voxponds.PoisonRuneShrine;
import net.nevermine.structures.voxponds.ToxicStem1;
import net.nevermine.structures.voxponds.ToxicStem2;
import net.nevermine.structures.voxponds.ToxicStem3;
import net.nevermine.structures.voxponds.ToxicStem4;
import net.nevermine.structures.voxponds.VoxBranch1;
import net.nevermine.structures.voxponds.VoxBranch2;
import net.nevermine.structures.voxponds.VoxFungi;
import net.nevermine.structures.voxponds.VoxPillar1;
import net.nevermine.structures.voxponds.VoxPillar2;
import net.nevermine.structures.voxponds.VoxTentacle1;
import net.nevermine.structures.voxponds.VoxTentacle2;
import net.nevermine.structures.voxponds.VoxTentacle3;
import net.nevermine.structures.voxponds.VoxTentacle4;
import net.nevermine.structures.voxponds.VoxTentacle5;
import net.nevermine.structures.voxponds.VoxxulonAltar;

public class VoxPondsChunkBuilder {
    private static Random rand = new Random();
    private int DT1 = 0;
    private int DT2 = 0;
    private int DT3 = 0;
    private Boolean Cntrl = false;
    private Boolean Pillar = false;
    private Boolean Hang = false;
    private int StemCount = 0;
    private int WhichStem = 0;
    private static IVoxpondsStructure deadtree1 = new DeadTree1();
    private static IVoxpondsStructure deadtree2 = new DeadTree2();
    private static IVoxpondsStructure deadtree3 = new DeadTree3();
    private static IVoxpondsStructure pillar1 = new VoxPillar1();
    private static IVoxpondsStructure pillar2 = new VoxPillar2();
    private static IVoxpondsStructure stem1 = new ToxicStem1();
    private static IVoxpondsStructure stem2 = new ToxicStem2();
    private static IVoxpondsStructure stem3 = new ToxicStem3();
    private static IVoxpondsStructure stem4 = new ToxicStem4();
    private static IVoxpondsStructure hanglight = new HangingVoxLight();
    private static IVoxpondsStructure groundlight = new GroundVoxLight();
    private static IVoxpondsStructure controltower = new ControlTower();
    private static IVoxpondsStructure runeshrine = new PoisonRuneShrine();
    private static Block topper;
    private static Block under;
    private static IVoxpondsStructure EnigmaStation;
    private static IVoxpondsStructure DestroyedStore1;
    private static IVoxpondsStructure DestroyedStore2;
    private static IVoxpondsStructure IntelligenceTower;
    private static IVoxpondsStructure ObservationTower;
    private static IVoxpondsStructure VoxxulonAltar;
    private static IVoxpondsStructure ExoidPlatform;
    private static IVoxpondsStructure nightwingPlatform;
    private static IVoxpondsStructure lotto;
    private static IVoxpondsStructure branch1;
    private static IVoxpondsStructure branch2;
    private static IVoxpondsStructure fungi;
    private static IVoxpondsStructure ten1;
    private static IVoxpondsStructure ten2;
    private static IVoxpondsStructure ten3;
    private static IVoxpondsStructure ten4;
    private static IVoxpondsStructure ten5;
    private static IVoxpondsStructure miniTentacles;

    public Block[][][] buildChunk() {
        Block[][][] chunk = new Block[16][256][16];
        if (rand.nextInt(2) == 1) {
            topper = Blockizer.GrassToxic;
            under = Blockizer.DirtToxic;
        } else {
            topper = Blocks.field_150350_a;
            under = Blockizer.ToxicWaste;
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 50; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (y > 13 && y <= 15 || y > 31 && y <= 38) {
                        chunk[x][y][z] = Blockizer.StoneToxic;
                    }
                    if (y == 38) {
                        chunk[x][y][z] = topper;
                        chunk[x][y - 1][z] = under;
                        if (rand.nextInt(2) == 0) {
                            chunk[x][y - 2][z] = under;
                        }
                    }
                    if ((y == 16 || y == 17) && chunk[x][y][z] == null) {
                        chunk[x][y][z] = Blocks.field_150355_j;
                    }
                    if (y == 18 && rand.nextInt(6200) == 323 && x < 8 && z < 8) {
                        nightwingPlatform.generate(chunk, x, y, z);
                    }
                    if (y == 18 && rand.nextInt(7800) == 144 && x < 3 && z < 3) {
                        EnigmaStation.generate(chunk, x, y, z);
                    }
                    if (topper == Blockizer.GrassToxic) {
                        int full = rand.nextInt(130);
                        if (full < 128) {
                            if (this.DT1 < 2 && y == 39) {
                                if (rand.nextInt(500) == 0 && x < 8 && z < 8) {
                                    deadtree1.generate(chunk, x, y, z);
                                    ++this.DT1;
                                }
                            }
                            if (this.DT2 < 2 && y == 39) {
                                if (rand.nextInt(500) == 0 && x < 9 && z < 9) {
                                    deadtree2.generate(chunk, x, y, z);
                                    ++this.DT2;
                                }
                            }
                            if (this.DT3 < 2 && y == 39) {
                                if (rand.nextInt(500) == 0 && x < 9 && z < 9) {
                                    deadtree3.generate(chunk, x, y, z);
                                    ++this.DT3;
                                }
                            }
                            if (!this.Cntrl.booleanValue() && y == 39) {
                                if (rand.nextInt(3000) == 0 && x < 6 && z < 6) {
                                    lotto.generate(chunk, x, y, z);
                                    this.Cntrl = true;
                                }
                            }
                            if (!this.Cntrl.booleanValue() && y == 39) {
                                if (rand.nextInt(2700) == 0 && x < 4 && z < 4) {
                                    int twr = rand.nextInt(3);
                                    if (twr == 1) {
                                        controltower.generate(chunk, x, y, z);
                                    } else if (twr == 2 && y == 0 && x == 0) {
                                        ObservationTower.generate(chunk, x, y, z);
                                    } else {
                                        IntelligenceTower.generate(chunk, x, y, z);
                                    }
                                    this.Cntrl = true;
                                }
                            }
                            if (y == 39 && x < 13 && z < 13 && chunk[x][y][z] == null && rand.nextInt(14) == 3) {
                                int pick = rand.nextInt(24);
                                if (pick == 1) {
                                    ten5.generate(chunk, x, y, z);
                                } else if (pick == 2) {
                                    ten1.generate(chunk, x, y, z);
                                } else if (pick == 3) {
                                    ten2.generate(chunk, x, y, z);
                                } else if (pick == 4) {
                                    ten3.generate(chunk, x, y, z);
                                } else if (pick == 5) {
                                    ten4.generate(chunk, x, y, z);
                                } else {
                                    fungi.generate(chunk, x, y, z);
                                }
                            }
                            if (y == 39 && chunk[x][y][z] == null && rand.nextInt(2) == 1) {
                                chunk[x][y][z] = Blockizer.DeadGrass;
                            }
                            if (y == 39 && chunk[x][y][z] == null && rand.nextInt(80) == 33) {
                                chunk[x][y][z] = SpecialBlockizer.VoxShroom;
                            }
                            if (y == 39 && z < 12 && chunk[x][y][z] == null && rand.nextInt(45) == 32) {
                                branch1.generate(chunk, x, y, z);
                            }
                            if (y == 39 && x < 12 && chunk[x][y][z] == null && rand.nextInt(45) == 32) {
                                branch2.generate(chunk, x, y, z);
                            }
                        } else if (y == 39 && x == 0 && z == 0) {
                            int choose = rand.nextInt(4);
                            if (choose == 1) {
                                DestroyedStore1.generate(chunk, x, y, z);
                            } else if (choose == 2) {
                                DestroyedStore2.generate(chunk, x, y, z);
                            } else if (choose == 3) {
                                ExoidPlatform.generate(chunk, x, y, z);
                            } else {
                                VoxxulonAltar.generate(chunk, x, y, z);
                            }
                        }
                    } else if (y == 38 && rand.nextInt(30) == 13) {
                        miniTentacles.generate(chunk, x, y, z);
                    }
                    if (!this.Pillar.booleanValue() && y == 16) {
                        if (rand.nextInt(600) == 0 && x < 6 && z < 6) {
                            if (rand.nextInt(2) == 1) {
                                pillar1.generate(chunk, x, y, z);
                            } else {
                                pillar2.generate(chunk, x, y, z);
                            }
                            this.Pillar = true;
                        }
                    }
                    if (this.StemCount < 8 && y == 28) {
                        if (rand.nextInt(40) == 0 && x < 14 && z < 14) {
                            this.WhichStem = rand.nextInt(4);
                            if (this.WhichStem == 1) {
                                stem1.generate(chunk, x, y, z);
                            } else if (this.WhichStem == 2) {
                                stem2.generate(chunk, x, y, z);
                            } else if (this.WhichStem == 3) {
                                stem3.generate(chunk, x, y, z);
                            } else {
                                stem4.generate(chunk, x, y, z);
                            }
                            ++this.StemCount;
                        }
                    }
                    if (!this.Hang.booleanValue() && y == 27) {
                        if (rand.nextInt(600) == 0 && x < 10 && z < 10) {
                            if (rand.nextInt(2) == 1) {
                                hanglight.generate(chunk, x, y, z);
                            } else {
                                groundlight.generate(chunk, x, 16, z);
                            }
                            this.Hang = true;
                        }
                    }
                    if (y != 47 || x >= 9 || z >= 9 || rand.nextInt(30000) != 5141) continue;
                    runeshrine.generate(chunk, x, y, z);
                }
            }
        }
        return chunk;
    }

    public static void toTerrainArray(Block[][][] chunk, Block[] output) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 256; ++y) {
                for (int z = 0; z < 16; ++z) {
                    output[z << 12 | x << 8 | y] = chunk[x][y][z];
                }
            }
        }
    }

    static {
        EnigmaStation = new EnigmaStation();
        DestroyedStore1 = new DestroyedStore1();
        DestroyedStore2 = new DestroyedStore2();
        IntelligenceTower = new IntelligenceTower();
        ObservationTower = new ObservationTower();
        VoxxulonAltar = new VoxxulonAltar();
        ExoidPlatform = new ExoidPlatform();
        nightwingPlatform = new NightwingPlatform();
        lotto = new LottoVoxStructure();
        branch1 = new VoxBranch1();
        branch2 = new VoxBranch2();
        fungi = new VoxFungi();
        ten1 = new VoxTentacle1();
        ten2 = new VoxTentacle2();
        ten3 = new VoxTentacle3();
        ten4 = new VoxTentacle4();
        ten5 = new VoxTentacle5();
        miniTentacles = new MiniTentacles();
    }
}

