/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.dimension.mysterium;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.nevermine.dimension.mysterium.MysteriumChunkBuilder;
import net.nevermine.izer.Blockizer;

public class ChunkProviderMysterium
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen5;
    private NoiseGeneratorOctaves noiseGen6;
    private NoiseGeneratorPerlin noiseGen4;
    private World worldObj;
    private WorldType type;
    private final double[] da;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];
    private BiomeGenBase[] biomesForGeneration;
    private double[] gen1;
    private double[] gen2;
    private double[] gen3;
    private double[] gen4;
    private int[][] ia = new int[32][32];

    public ChunkProviderMysterium(World par1World, long par2) {
        this.worldObj = par1World;
        this.type = par1World.func_72912_H().func_76067_t();
        this.rand = new Random(par2);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.da = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.noiseGen6};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)par1World, (Random)this.rand, (NoiseGenerator[])noiseGens);
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen5 = (NoiseGeneratorOctaves)noiseGens[4];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
    }

    public void generate(int i, int j, Block[] b) {
        MysteriumChunkBuilder builder = new MysteriumChunkBuilder();
        MysteriumChunkBuilder.toTerrainArray(builder.buildChunk(), b);
    }

    public void replaceBlocksForBiome(int i, int j, Block[] ba, byte[] by, BiomeGenBase[] b) {
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(i * 16), (double)(j * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = b[l + k * 16];
                this.genBiomeTerrain(this.worldObj, this.rand, ba, by, i * 16 + k, j * 16 + l, this.stoneNoise[l + k * 16], biomegenbase);
            }
        }
    }

    public final void genBiomeTerrain(World p_150560_1_, Random p_150560_2_, Block[] p_150560_3_, byte[] p_150560_4_, int p_150560_5_, int p_150560_6_, double p_150560_7_, BiomeGenBase b) {
        boolean flag = true;
        Block block = b.field_76752_A;
        byte b0 = (byte)(b.field_150604_aj & 0xFF);
        Block block1 = b.field_76753_B;
        int k = -1;
        int l = (int)(p_150560_7_ / 3.0 + 3.0 + p_150560_2_.nextDouble() * 0.25);
        int i1 = p_150560_5_ & 0xF;
        int j1 = p_150560_6_ & 0xF;
        int k1 = p_150560_3_.length / 256;
        for (int l1 = 255; l1 >= 0; --l1) {
            int i2 = (j1 * 16 + i1) * k1 + l1;
            if (l1 <= 0 + p_150560_2_.nextInt(5)) {
                p_150560_3_[i2] = Blocks.field_150357_h;
                continue;
            }
            Block block2 = p_150560_3_[i2];
            if (block2 != null && block2.func_149688_o() != Material.field_151579_a) {
                if (block2 != Blockizer.StoneToxic) continue;
                if (k == -1) {
                    if (l <= 0) {
                        block = null;
                        b0 = 0;
                        block1 = Blockizer.StoneToxic;
                    } else if (l1 >= 59 && l1 <= 64) {
                        block = b.field_76752_A;
                        b0 = (byte)(b.field_150604_aj & 0xFF);
                        block1 = b.field_76753_B;
                    }
                    if (l1 < 63 && (block == null || block.func_149688_o() == Material.field_151579_a)) {
                        if (b.func_150564_a(p_150560_5_, l1, p_150560_6_) < 0.15f) {
                            block = Blocks.field_150355_j;
                            b0 = 0;
                        } else {
                            block = Blockizer.StoneToxic;
                            b0 = 0;
                        }
                    }
                    k = l;
                    if (l1 >= 62) {
                        p_150560_3_[i2] = block;
                        p_150560_4_[i2] = b0;
                        continue;
                    }
                    if (l1 < 56 - l) {
                        block = null;
                        block1 = Blockizer.StoneToxic;
                        p_150560_3_[i2] = Blockizer.StoneToxic;
                        continue;
                    }
                    p_150560_3_[i2] = block1;
                    continue;
                }
                if (k <= 0) continue;
                p_150560_3_[i2] = block1;
                if (--k != 0 || block1 != Blockizer.StoneToxic) continue;
                k = p_150560_2_.nextInt(4) + Math.max(0, l1 - 63);
                block1 = Blockizer.StoneToxic;
                continue;
            }
            k = -1;
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] ablock = new Block[65536];
        byte[] abyte = new byte[65536];
        this.generate(par1, par2, ablock);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, ablock, abyte, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.worldObj, ablock, abyte, par1, par2);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void generate(int x, int y, int z) {
        double d0 = 684.412;
        double d1 = 684.412;
        double d2 = 512.0;
        double d3 = 512.0;
        this.gen4 = this.noiseGen6.func_76305_a(this.gen4, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.gen1 = this.noiseGen3.func_76304_a(this.gen1, x, y, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.gen2 = this.noiseGen1.func_76304_a(this.gen2, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.gen3 = this.noiseGen2.func_76304_a(this.gen3, x, y, z, 5, 33, 5, 684.412, 684.412, 684.412);
        boolean flag1 = false;
        boolean flag = false;
        int l = 0;
        int i1 = 0;
        double d4 = 8.5;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[j1 + 2 + (k1 + 2) * 10];
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[j1 + l1 + 2 + (k1 + i2 + 2) * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (this.type == WorldType.field_151360_e && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.gen4[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.gen2[l] / 512.0;
                    double d8 = this.gen3[l] / 512.0;
                    double d9 = (this.gen1[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.da[l] = d10;
                    ++l;
                }
            }
        }
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        long p1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed(this.worldObj.func_72905_C());
        this.rand.setSeed((long)par2 * p1 + (long)par3 * j1 ^ this.worldObj.func_72905_C());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                if (this.worldObj.func_147439_a(x + var4, 20, z + var5) == Blockizer.LampVox) {
                    this.worldObj.func_147451_t(x + var4, 20, z + var5);
                    this.worldObj.func_147458_c(x + var4, 20, z + var5, x + var4 + 12, 20, z + var5 + 12);
                }
                if (this.worldObj.func_147439_a(x + var4, 27, z + var5) == Blockizer.LampVox) {
                    this.worldObj.func_147451_t(x + var4, 27, z + var5);
                    this.worldObj.func_147458_c(x + var4, 27, z + var5, x + var4 + 12, 27, z + var5 + 12);
                }
                if (this.worldObj.func_147439_a(x + var4, 19, z + var5) != Blockizer.SpawnerNightwing) continue;
                Block b = this.worldObj.func_147439_a(x + var4, 19, z + var5);
                TileEntity te = b.createTileEntity(this.worldObj, 0);
                this.worldObj.func_147455_a(var4 + x, 19, var5 + z, te);
            }
        }
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "Mysterium";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
    }
}

