/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.dimension.lunalus;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.nevermine.izer.Blockizer;
import net.nevermine.structures.lunalus.LunarIsland1;
import net.nevermine.structures.lunalus.LunarIsland2;
import net.nevermine.structures.lunalus.LunarTree1;
import net.nevermine.structures.lunalus.LunarTree2;
import net.nevermine.structures.lunalus.LunarTree3;
import net.nevermine.structures.lunalus.LunarTree4;
import net.nevermine.structures.lunalus.VisualentEye;
import net.nevermine.structures.voxponds.IVoxpondsStructure;

public class LunalusChunkBuilder {
    private static Random rand = new Random();
    private boolean islandLow;
    private boolean islandHigh;
    private int treelow = 0;
    private int treehigh = 0;
    private int pick;
    private static IVoxpondsStructure Island1 = new LunarIsland1();
    private static IVoxpondsStructure Island2 = new LunarIsland2();
    private static IVoxpondsStructure VisualentEye = new VisualentEye();
    private static IVoxpondsStructure Tree1 = new LunarTree1();
    private static IVoxpondsStructure Tree2 = new LunarTree2();
    private static IVoxpondsStructure Tree3 = new LunarTree3();
    private static IVoxpondsStructure Tree4 = new LunarTree4();

    public Block[][][] buildChunk() {
        Block[][][] chunk = new Block[16][256][16];
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 80; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (y == 4 || y == 5) {
                        chunk[x][y][z] = Blocks.field_150355_j;
                    }
                    if (!this.islandLow && y > 35 && y < 45 && x < 2 && z < 2 && rand.nextInt(45) == 5) {
                        if (rand.nextInt(2) == 1) {
                            Island1.generate(chunk, x, y, z);
                        } else {
                            Island2.generate(chunk, x, y, z);
                        }
                        this.islandLow = true;
                    }
                    if (!this.islandHigh && y > 60 && y < 70 && x < 2 && z < 2 && rand.nextInt(45) == 5) {
                        if (rand.nextInt(2) == 1) {
                            Island1.generate(chunk, x, y, z);
                        } else {
                            Island2.generate(chunk, x, y, z);
                        }
                        this.islandHigh = true;
                    }
                    if (y == 8 && x < 2 && z < 2 && rand.nextInt(1500) == 5) {
                        VisualentEye.generate(chunk, x, y, z);
                    }
                    if (y > 0) {
                        if (this.treelow < 2 && y < 63 && rand.nextInt(12) == 3 && x < 11 && z < 11 && x > 0 && z > 0 && (chunk[x + 2][y - 1][z + 2] == Blockizer.GrassLunasole || chunk[x + 2][y - 1][z + 2] == Blockizer.GrassLunalyte)) {
                            this.pick = rand.nextInt(4);
                            if (this.pick == 1) {
                                Tree1.generate(chunk, x, y, z);
                            } else if (this.pick == 2) {
                                Tree2.generate(chunk, x, y, z);
                            } else if (this.pick == 3) {
                                Tree4.generate(chunk, x, y, z);
                            } else {
                                Tree3.generate(chunk, x, y, z);
                            }
                            ++this.treelow;
                        }
                        if (this.treehigh < 2 && y > 64 && rand.nextInt(12) == 3 && x < 11 && z < 11 && x > 0 && z > 0 && (chunk[x + 2][y - 1][z + 2] == Blockizer.GrassLunasole || chunk[x + 2][y - 1][z + 2] == Blockizer.GrassLunalyte)) {
                            this.pick = rand.nextInt(4);
                            if (this.pick == 1) {
                                Tree1.generate(chunk, x, y, z);
                            } else if (this.pick == 2) {
                                Tree2.generate(chunk, x, y, z);
                            } else if (this.pick == 3) {
                                Tree4.generate(chunk, x, y, z);
                            } else {
                                Tree3.generate(chunk, x, y, z);
                            }
                            ++this.treehigh;
                        }
                    }
                    if (y <= 0 || chunk[x][y - 1][z] != Blockizer.GrassLunasole && chunk[x][y - 1][z] != Blockizer.GrassLunalyte || rand.nextInt(10) != 4 || chunk[x][y][z] != null) continue;
                    chunk[x][y][z] = rand.nextInt(2) == 1 ? Blockizer.Luntar : Blockizer.Lunalip;
                }
            }
        }
        return chunk;
    }

    public static void toTerrainArray(Block[][][] chunk, Block[] output) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 256; ++y) {
                for (int z = 0; z < 16; ++z) {
                    output[z << 12 | x << 8 | y] = chunk[x][y][z];
                }
            }
        }
    }
}

