/*
 * Decompiled with CFR 0.152.
 */
package net.nevermine.boss.cottoncandor;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.nevermine.boss.EntityBoss;
import net.nevermine.common.nevermine;
import net.nevermine.event.creature.BossClear;
import net.nevermine.izer.Blockizer;
import net.nevermine.izer.SpecialBlockizer;
import net.nevermine.izer.equipment.Armorizer;
import net.nevermine.izer.equipment.Weaponizer;
import net.nevermine.mob.ai.EntityAIFlying;
import net.nevermine.mob.placement.EntitySpecialRange;
import net.nevermine.projectiles.enemy.EntityCandorShot;
import net.nevermine.projectiles.staff.EntityLunarFall;
import net.nevermine.projectiles.staff.EntityStaffFire;
import net.nevermine.projectiles.staff.EntityStaffPoison;
import net.nevermine.projectiles.staff.EntityStaffWater;
import net.nevermine.projectiles.staff.EntityStaffWind;
import net.nevermine.projectiles.staff.EntityStaffWither;
import net.nevermine.skill.hunter.hunterHelper;

public class EntityCottonCandor
extends EntityAIFlying
implements EntityBoss,
EntitySpecialRange {
    private ChunkCoordinates currentFlightTarget;
    private int flyTimer;
    private int musicTick = 1;
    private int stateSwitch = 100;

    public EntityCottonCandor(World var1) {
        super(var1);
        double moveSpeed = 0.75;
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, moveSpeed));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, moveSpeed));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.flyTimer = 0;
        this.func_70105_a(3.0f, 3.0f);
    }

    protected void func_70628_a(boolean par1, int par2) {
        int armr = this.field_70146_Z.nextInt(4);
        if (armr == 1) {
            this.func_145779_a(Armorizer.CandyBoots, 1);
        } else if (armr == 2) {
            this.func_145779_a(Armorizer.CandyHelmet, 1);
        } else if (armr == 3) {
            this.func_145779_a(Armorizer.CandyLeggings, 1);
        } else {
            this.func_145779_a(Armorizer.CandyChestplate, 1);
        }
        if (this.field_70146_Z.nextInt(6) == 3) {
            this.func_145779_a(Weaponizer.CottonCrusher, 1);
        }
        this.func_145779_a(this.dropStatue(), 1);
        this.func_145779_a(Item.func_150898_a((Block)Blockizer.CandylandCottonBlue), 64);
        this.func_145779_a(Item.func_150898_a((Block)Blockizer.CandylandCottonPink), 64);
    }

    private Item dropStatue() {
        return Item.func_150898_a((Block)SpecialBlockizer.CottonCandorStatue);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL && this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70623_bb();
        }
        --this.musicTick;
        if (this.musicTick == 0) {
            this.musicTick = 287;
            this.func_85030_a("nevermine:MusicCottonCandor", 3.0f, 1.0f);
        }
        --this.stateSwitch;
        if (this.stateSwitch == 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(25, (Object)this.field_70146_Z.nextInt(6));
            }
            this.stateSwitch = 100;
        }
        if (this.field_70146_Z.nextInt(70) == 37 && this.field_70789_a != null) {
            EntityCandorShot entitylargefireball = new EntityCandorShot(this.field_70170_p, this);
            double var3 = this.field_70789_a.field_70165_t - this.field_70165_t;
            double var5 = this.field_70789_a.field_70163_u + (double)this.field_70789_a.func_70047_e() - (double)1.1f - entitylargefireball.field_70163_u;
            double var7 = this.field_70789_a.field_70161_v - this.field_70161_v;
            float var9 = MathHelper.func_76133_a((double)(var3 * var3 + var7 * var7)) * 0.2f;
            entitylargefireball.func_70186_c(var3, var5 + (double)var9, var7, 1.6f, 12.0f);
            this.field_70170_p.func_72838_d((Entity)entitylargefireball);
            this.func_85030_a("nevermine:CandorRoar", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity entity = par1DamageSource.func_76364_f();
        if (par1DamageSource == DamageSource.field_76368_d) {
            BossClear.clear((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.field_70170_p, (Entity)this);
        }
        int state = this.getState();
        if (par1DamageSource.func_76352_a()) {
            if (state == 1 && entity instanceof EntityStaffWind) {
                return super.func_70097_a(par1DamageSource, par2);
            }
            if (state == 2 && entity instanceof EntityStaffWater) {
                return super.func_70097_a(par1DamageSource, par2);
            }
            if (state == 3 && entity instanceof EntityStaffFire) {
                return super.func_70097_a(par1DamageSource, par2);
            }
            if (state == 4 && entity instanceof EntityStaffPoison) {
                return super.func_70097_a(par1DamageSource, par2);
            }
            if (state == 5 && entity instanceof EntityStaffWither) {
                return super.func_70097_a(par1DamageSource, par2);
            }
            if (entity instanceof EntityLunarFall) {
                return super.func_70097_a(par1DamageSource, par2);
            }
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(25, (Object)1);
        this.func_70096_w().func_75692_b(25, (Object)1);
    }

    public int getState() {
        return this.field_70180_af.func_75679_c(25);
    }

    public void func_70645_a(DamageSource var1) {
        super.func_70645_a(var1);
        if (!this.field_70170_p.field_72995_K && var1.func_76346_g() != null && var1.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)var1.func_76346_g();
            int expDropped = 3500;
            for (EntityPlayer e : p.field_70170_p.func_72872_a(EntityPlayer.class, p.field_70121_D.func_72314_b(50.0, 50.0, 50.0))) {
                e.func_145747_a((IChatComponent)nevermine.addChatMessage(p.getDisplayName() + " defeated Cotton Candor!", new Object[0]));
            }
            boolean run = true;
            if (hunterHelper.getProperties(p).getLevel() < 30) {
                run = false;
            }
            while (run) {
                float req = hunterHelper.getProperties(p).getExpLeft();
                if ((float)expDropped > req) {
                    expDropped = (int)((float)expDropped - req);
                    hunterHelper.getProperties(p).levelUp();
                    continue;
                }
                hunterHelper.getProperties(p).addExperience(expDropped);
                run = false;
            }
        }
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.35f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3000.0);
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 2.95f;
    }

    protected String func_70639_aQ() {
        return "nevermine:CottonCandorLiving";
    }

    protected String func_70673_aS() {
        return "nevermine:CottonCandorDeath";
    }

    protected String func_70621_aR() {
        return "nevermine:CottonCandorHit";
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x *= 0.3000000238418579;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_70638_az() != null) {
            int var1 = (int)this.func_70638_az().field_70165_t;
            int var2 = (int)this.func_70638_az().field_70163_u;
            int var3 = (int)this.func_70638_az().field_70161_v;
            this.currentFlightTarget = new ChunkCoordinates(var1, var2, var3);
        } else if (this.flyTimer != 0) {
            this.flyTimer = 120;
            this.currentFlightTarget = new ChunkCoordinates((int)(this.field_70165_t + (double)this.field_70146_Z.nextInt(16)) - 8, (int)(this.field_70163_u + (double)this.field_70146_Z.nextInt(32)) - 16, (int)(this.field_70161_v + (double)this.field_70146_Z.nextInt(16)) - 8);
        }
        if (this.currentFlightTarget != null) {
            double var1 = (double)this.currentFlightTarget.field_71574_a - this.field_70165_t;
            double var3 = (double)this.currentFlightTarget.field_71572_b + (double)this.field_70146_Z.nextFloat() + 1.0 - this.field_70163_u;
            double var5 = (double)this.currentFlightTarget.field_71573_c - this.field_70161_v;
            if (Math.signum(var1) != 0.0 || Math.signum(var3) != 0.0 || Math.signum(var5) != 0.0) {
                this.field_70159_w += (Math.signum(var1) * 0.15 - this.field_70159_w) * (double)0.1f;
                this.field_70181_x += (Math.signum(var3) * 1.699999988079071 - this.field_70181_x) * (double)0.1f;
                this.field_70179_y += (Math.signum(var5) * 0.15 - this.field_70179_y) * (double)0.1f;
                float var7 = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float var8 = MathHelper.func_76142_g((float)(var7 - this.field_70177_z));
                this.field_70701_bs = 0.5f;
                this.field_70177_z += var8;
            }
            --this.flyTimer;
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70069_a(float par1) {
    }

    @Override
    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        this.func_70652_k((Entity)par1EntityPlayer);
    }

    @Override
    public String getShot() {
        int state = this.getState();
        if (state == 1) {
            return "wind";
        }
        if (state == 2) {
            return "water";
        }
        if (state == 3) {
            return "fire";
        }
        if (state == 4) {
            return "poison";
        }
        if (state == 5) {
            return "wither";
        }
        return "lunar";
    }
}

