/*
 * Decompiled with CFR 0.152.
 */
package exter.fodc.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exter.fodc.container.ContainerAutomaticOreConverter;
import exter.fodc.network.ODCPacketHandler;
import exter.fodc.registry.OreNameRegistry;
import exter.fodc.tileentity.TileEntityAutomaticOreConverter;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiAutomaticOreConverter
extends GuiContainer {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("fodc:textures/gui/aoc_gui.png");
    private TileEntityAutomaticOreConverter te_autoconverter;
    private IInventory player_inventory;
    private TargetSlot[] target_slots;

    public TargetSlot GetTargetSlotAt(int x, int y) {
        for (TargetSlot s : this.target_slots) {
            if (x < s.x + 1 || x > s.x + 17 || y < s.y + 1 || y > s.y + 17) continue;
            return s;
        }
        return null;
    }

    public GuiAutomaticOreConverter(TileEntityAutomaticOreConverter aoc, IInventory player_inv) {
        super((Container)new ContainerAutomaticOreConverter(aoc, player_inv));
        this.player_inventory = player_inv;
        this.field_146291_p = false;
        this.field_147000_g = 210;
        this.te_autoconverter = aoc;
        this.target_slots = new TargetSlot[18];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                int s = i * 9 + j;
                this.target_slots[s] = new TargetSlot(j * 18 + 8, i * 18 + 76, s);
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_73864_a(int x, int y, int par3) {
        super.func_73864_a(x, y, par3);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        TargetSlot slot = this.GetTargetSlotAt(x - window_x, y - window_y);
        if (slot != null) {
            slot.OnClick();
        }
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.te_autoconverter.func_145825_b()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"Targets"), 8, 65, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)this.player_inventory.func_145825_b()), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int window_x = (this.field_146294_l - this.field_146999_f) / 2;
        int window_y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(window_x, window_y, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderHelper.func_74520_c();
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        for (int i = 0; i < 18; ++i) {
            this.target_slots[i].DrawSlot();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74519_b();
    }

    public class TargetSlot {
        public final int x;
        public final int y;
        public final int position;

        public TargetSlot(int xx, int yy, int pos) {
            this.x = xx;
            this.y = yy;
            this.position = pos;
        }

        public void OnClick() {
            ItemStack target_stack;
            ItemStack player_stack = GuiAutomaticOreConverter.this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (player_stack != null && !OreNameRegistry.FindAllOreNames(player_stack).isEmpty()) {
                target_stack = player_stack.func_77946_l();
                target_stack.field_77994_a = 1;
            } else {
                target_stack = null;
            }
            GuiAutomaticOreConverter.this.te_autoconverter.SetTarget(this.position, target_stack);
            ODCPacketHandler.SendAutoOreConverterTarget(GuiAutomaticOreConverter.this.te_autoconverter, this.position, target_stack);
        }

        public void DrawSlot() {
            ItemStack item = GuiAutomaticOreConverter.this.te_autoconverter.GetTarget(this.position);
            if (item != null) {
                int window_x = (GuiAutomaticOreConverter.this.field_146294_l - GuiAutomaticOreConverter.this.field_146999_f) / 2;
                int window_y = (GuiAutomaticOreConverter.this.field_146295_m - GuiAutomaticOreConverter.this.field_147000_g) / 2;
                field_146296_j.field_77023_b = 200.0f;
                field_146296_j.func_82406_b(GuiAutomaticOreConverter.this.field_146289_q, GuiAutomaticOreConverter.this.field_146297_k.field_71446_o, item, window_x + this.x, window_y + this.y);
                field_146296_j.func_77021_b(GuiAutomaticOreConverter.this.field_146289_q, GuiAutomaticOreConverter.this.field_146297_k.field_71446_o, item, window_x + this.x, window_y + this.y);
                field_146296_j.field_77023_b = 0.0f;
            }
        }
    }
}

