/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.texturestitcher;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import wtfcore.WTFCore;
import wtfcore.loader.impl.CodeRefs;
import wtfcore.texturestitcher.AbstractModIntegration;

public class OptifineIntegration
extends AbstractModIntegration {
    public static boolean isPresent = false;

    private OptifineIntegration() {
    }

    public static void init() {
        if (OptifineIntegration.isAllAvailable(CodeRefs.optifineCTF)) {
            WTFCore.log.info("Found Optifine, using CTM support");
            isPresent = true;
        } else if (OptifineIntegration.isSomeAvailable(CodeRefs.optifineCTF)) {
            WTFCore.log.info("Found Optifine, but not all needed elements (wrong version?)");
        }
    }

    public static Collection<IIcon> getAllCTMForBlock(Block block) {
        Object[] connectedProperties;
        HashSet result = Sets.newHashSet();
        if (!isPresent) {
            return result;
        }
        Object[][] blockProperties = (Object[][])CodeRefs.fCTBlockProperties.getStaticField();
        int blockId = Block.func_149682_b((Block)block);
        if (blockProperties != null && blockId < blockProperties.length && blockId >= 0 && (connectedProperties = blockProperties[blockId]) != null) {
            for (Object cp : connectedProperties) {
                IIcon[] icons = (IIcon[])CodeRefs.fCPTileIcons.getInstanceField(cp);
                for (int idx = 0; idx < icons.length; ++idx) {
                    result.add(icons[idx]);
                }
            }
        }
        return result;
    }

    public static Collection<IIcon> getAllCTMForIcon(IIcon icon) {
        Object[] connectedProperties;
        HashSet result = Sets.newHashSet();
        if (!isPresent) {
            return result;
        }
        Object[][] tileProperties = (Object[][])CodeRefs.fCTTileProperties.getStaticField();
        int iconIdx = (Integer)CodeRefs.mGetIndexInMap.invokeInstanceMethod(icon, new Object[0]);
        if (tileProperties != null && iconIdx < tileProperties.length && iconIdx >= 0 && (connectedProperties = tileProperties[iconIdx]) != null) {
            for (Object cp : connectedProperties) {
                IIcon[] icons = (IIcon[])CodeRefs.fCPTileIcons.getInstanceField(cp);
                for (int idx = 0; idx < icons.length; ++idx) {
                    result.add(icons[idx]);
                }
            }
        }
        return result;
    }

    public static IIcon getConnectedTexture(IBlockAccess blockAccess, Block block, int x, int y, int z, int side, IIcon icon) {
        return (IIcon)CodeRefs.mGetConnectedTexture.invokeStaticMethod(blockAccess, block, x, y, z, side, icon);
    }
}

