/*
 * Decompiled with CFR 0.152.
 */
package wtfcore;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import wtfcore.WTFCoreConfig;
import wtfcore.proxy.CommonProxy;
import wtfcore.utilities.EventListener;
import wtfcore.utilities.LoadBlockSets;
import wtfcore.utilities.UBCblocks;
import wtfcore.worldgen.NetherScanner;
import wtfcore.worldgen.OverworldScanner;
import wtfcore.worldgen.WorldGenListener;

@Mod(modid="WTFCore", name="WTFCore", version="1.7", dependencies="after:UndergroundBiomes")
public class WTFCore {
    public static final String modid = "WTFCore";
    public static final String CaveBiomes = "CaveBiomes";
    public static final String WTFOres = "WTFOres";
    public static final String WTFTweaks = "WTFTweaks";
    public static Logger log;
    @SidedProxy(clientSide="wtfcore.proxy.ClientProxy", serverSide="wtfcore.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent preEvent) {
        log = preEvent.getModLog();
        WTFCoreConfig.customConfig();
        for (int dimensionID : WTFCoreConfig.overworlds) {
            WorldGenListener.GetScanner.put(dimensionID, new OverworldScanner());
            log.info("Adding default overworld scanner for dimension " + dimensionID);
        }
        for (int dimensionID : WTFCoreConfig.nethers) {
            WorldGenListener.GetScanner.put(dimensionID, new NetherScanner());
            log.info("Adding default nether scanner for dimension " + dimensionID);
        }
        if (Loader.isModLoaded((String)"UndergroundBiomes")) {
            UBCblocks.loadUBCStone();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenListener());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new WorldGenListener());
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent postEvent) {
        LoadBlockSets.setHashSets();
    }
}

