/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.util.UT;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.Worldgenerator;
import gregtech.worldgen.WorldgenStructureCorridor;
import gregtech.worldgen.WorldgenStructureEndPortal;
import gregtech.worldgen.WorldgenStructureEntrance;
import gregtech.worldgen.WorldgenStructureInteriorBarracks;
import gregtech.worldgen.WorldgenStructureInteriorCrates;
import gregtech.worldgen.WorldgenStructureInteriorDefault;
import gregtech.worldgen.WorldgenStructureInteriorLibrary;
import gregtech.worldgen.WorldgenStructurePistonDoor;
import gregtech.worldgen.WorldgenStructureRoom;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldgenStructure
extends WorldgenObject {
    public final int mProbability;
    public final int mMinSize;
    public final int mMaxSize;
    public final int mMinY;
    public final int mMaxY;
    public final int mRoomChance;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;
    public final boolean mPortalNether;
    public final boolean mPortalEnd;
    public static final int ROOM_ID_COUNT = 5;

    public WorldgenStructure(String aName, boolean aDefault, int aProbability, int aMinSize, int aMaxSize, int aMinY, int aMaxY, int aRoomChance, boolean aOverworld, boolean aNether, boolean aEnd, boolean aPortalNether, boolean aPortalEnd) {
        super(aName, Worldgenerator.sWorldgenList, aDefault);
        this.mOverworld = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mProbability = Math.max(1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "Probability", (long)aProbability));
        this.mMinSize = Math.max(2, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MinSize", (long)aMinSize));
        this.mMaxSize = Math.max(this.mMinSize, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MaxSize", (long)aMaxSize));
        this.mMinY = Math.max(2, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MinY", (long)aMinY));
        this.mMaxY = Math.max(this.mMinY, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "MaxY", (long)aMaxY));
        this.mRoomChance = Math.max(1, CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "RoomChance", (long)aRoomChance));
        this.mPortalNether = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "PortalNether", aPortalNether);
        this.mPortalEnd = CS.ConfigsGT.WORLDGEN.get((Object)("worldgen." + this.mWorldGenName), "PortalEnd", aPortalEnd);
    }

    public WorldgenStructure() {
        this(null, false, 100, 3, 7, 20, 20, 6, false, false, false, false, false);
    }

    @Override
    public synchronized boolean executeWorldgen(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        StructureData aData;
        int tConnectionCount;
        int j;
        int i;
        int i2;
        if (Math.abs(aChunkX / 16) % (this.mMaxSize + 4) != (this.mMaxSize + 4) / 2 || Math.abs(aChunkZ / 16) % (this.mMaxSize + 4) != (this.mMaxSize + 4) / 2 || aWorld.func_147439_a(aChunkX + 8, 0, aChunkZ + 8) != Blocks.field_150357_h || !this.isGenerationAllowed(aWorld, aDimensionType, aDimensionType == -1 && this.mNether || aDimensionType == 0 && this.mOverworld || aDimensionType == 1 && this.mEnd ? aDimensionType : ~aDimensionType) || aRandom.nextInt(this.mProbability) != 0) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        int tOffsetY = this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY));
        int tColor = aRandom.nextInt(16);
        BlockStones tPrimaryBlock = (BlockStones)CS.BlocksGT.stones[aRandom.nextInt(CS.BlocksGT.stones.length)];
        BlockStones tSecondaryBlock = (BlockStones)CS.BlocksGT.stones[aRandom.nextInt(CS.BlocksGT.stones.length)];
        HashSetNoNulls<ChunkCoordinates> tLightUpdateCoords = new HashSetNoNulls<ChunkCoordinates>();
        byte[][] tRoomLayout = new byte[2 + this.mMinSize + aRandom.nextInt(1 + this.mMaxSize - this.mMinSize)][2 + this.mMinSize + aRandom.nextInt(1 + this.mMaxSize - this.mMinSize)];
        boolean[] tGeneratedKeys = new boolean[5];
        boolean tDidntGenerateNetherPortal = true;
        boolean tDidntGenerateEndPortal = true;
        long[] tKeyIDs = new long[tGeneratedKeys.length];
        tKeyIDs[0] = System.nanoTime();
        for (i2 = 1; i2 < tKeyIDs.length; ++i2) {
            tKeyIDs[i2] = tKeyIDs[i2 - 1] - 1L;
        }
        aChunkX -= tRoomLayout.length / 2 * 16;
        aChunkZ -= tRoomLayout[0].length / 2 * 16;
        i2 = 0;
        int j2 = 0;
        int k = -1;
        for (int l = 0; k >= -2 && l < 10000; ++l) {
            i2 = 1 + aRandom.nextInt(tRoomLayout.length - 2);
            if (tRoomLayout[i2][j2 = 1 + aRandom.nextInt(tRoomLayout[i2].length - 2)] != 0) continue;
            tRoomLayout[i2][j2] = (byte)k--;
        }
        for (i2 = 1; i2 < tRoomLayout.length - 1; ++i2) {
            for (j2 = 1; j2 < tRoomLayout[i2].length - 1; ++j2) {
                if (tRoomLayout[i2][j2] != 0 || aRandom.nextInt(this.mRoomChance) != 0) continue;
                tRoomLayout[i2][j2] = (byte)(1 + aRandom.nextInt(5));
            }
        }
        for (i2 = 1; i2 < tRoomLayout.length - 1; ++i2) {
            for (j2 = 1; j2 < tRoomLayout[i2].length - 1; ++j2) {
                if (tRoomLayout[i2][j2] == 0) continue;
                int a = i2;
                int b = j2;
                while (a != tRoomLayout.length / 2 && tRoomLayout[a += a > tRoomLayout.length / 2 ? -1 : 1][b] == 0) {
                    tRoomLayout[a][b] = -128;
                }
                while (b != tRoomLayout[a].length / 2 && tRoomLayout[a][b += b > tRoomLayout[a].length / 2 ? -1 : 1] == 0) {
                    tRoomLayout[a][b] = -128;
                }
            }
        }
        boolean temp = true;
        while (temp) {
            temp = false;
            for (i = 1; i < tRoomLayout.length - 1; ++i) {
                for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                    if (tRoomLayout[i][j] != -128 || tRoomLayout[i + 1][j] != 0 && tRoomLayout[i - 1][j] != 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i][j + 1] == 0 || tRoomLayout[i + 1][j] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i][j + 1] != 0) continue;
                    tConnectionCount = 0;
                    if (tRoomLayout[i + 1][j] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tConnectionCount <= 1) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j - 1] != 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j + 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] != 0 && tRoomLayout[i - 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] == 0 || tRoomLayout[i - 1][j - 1] == 0 || tRoomLayout[i][j - 1] == 0 || tRoomLayout[i + 1][j] != 0 || tRoomLayout[i][j + 1] != 0) continue;
                    tRoomLayout[i][j] = 0;
                    temp = true;
                }
            }
        }
        temp = true;
        while (temp) {
            temp = false;
            for (i = 1; i < tRoomLayout.length - 1; ++i) {
                for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                    if (tRoomLayout[i][j] != -128 || tRoomLayout[i + 1][j] != 0 && tRoomLayout[i - 1][j] != 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i][j + 1] == 0 || tRoomLayout[i + 1][j] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i][j + 1] != 0) continue;
                    tConnectionCount = 0;
                    if (tRoomLayout[i + 1][j] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tConnectionCount <= 1) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i + 1][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j + 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tRoomLayout[i - 1][j - 1] != 0) {
                        ++tConnectionCount;
                    }
                    if (tConnectionCount >= 7) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tConnectionCount == 5) {
                        if (tRoomLayout[i + 1][j - 1] == 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i + 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j - 1] == 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i - 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j + 1] == 0 && tRoomLayout[i][j + 1] == 0 && tRoomLayout[i + 1][j + 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                        if (tRoomLayout[i - 1][j - 1] == 0 && tRoomLayout[i][j - 1] == 0 && tRoomLayout[i + 1][j - 1] == 0) {
                            tRoomLayout[i][j] = 0;
                            temp = true;
                            continue;
                        }
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i + 1][j] != 0 && tRoomLayout[i + 1][j - 1] != 0 && tRoomLayout[i][j - 1] != 0 && tRoomLayout[i - 1][j] == 0 && tRoomLayout[i][j + 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] != 0 && tRoomLayout[i - 1][j + 1] != 0 && tRoomLayout[i][j + 1] != 0 && tRoomLayout[i + 1][j] == 0 && tRoomLayout[i][j - 1] == 0) {
                        tRoomLayout[i][j] = 0;
                        temp = true;
                        continue;
                    }
                    if (tRoomLayout[i - 1][j] == 0 || tRoomLayout[i - 1][j - 1] == 0 || tRoomLayout[i][j - 1] == 0 || tRoomLayout[i + 1][j] != 0 || tRoomLayout[i][j + 1] != 0) continue;
                    tRoomLayout[i][j] = 0;
                    temp = true;
                }
            }
        }
        for (i = 1; i < tRoomLayout.length - 1; ++i) {
            for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                aWorld.func_72964_e((aChunkX >> 4) + i, (aChunkZ >> 4) + j).func_76630_e();
                tConnectionCount = 0;
                if (tRoomLayout[i + 1][j] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i - 1][j] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i][j + 1] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i][j - 1] != 0) {
                    ++tConnectionCount;
                }
                aData = new StructureData(this, tPrimaryBlock, tSecondaryBlock, tRegistry, tLightUpdateCoords, tKeyIDs, tGeneratedKeys, tRoomLayout, i, j, tConnectionCount, tOffsetY, tColor);
                switch (tRoomLayout[i][j]) {
                    case 1: {
                        if (!WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true)) break;
                        WorldgenStructureInteriorDefault.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        break;
                    }
                    case 2: {
                        if (!WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true) || tConnectionCount != 1) break;
                        WorldgenStructurePistonDoor.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        if (this.mPortalEnd && tDidntGenerateEndPortal && WorldgenStructureEndPortal.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData)) {
                            tDidntGenerateEndPortal = false;
                            break;
                        }
                        if (!this.mPortalNether || !tDidntGenerateNetherPortal) break;
                        tDidntGenerateNetherPortal = false;
                        break;
                    }
                    case 3: {
                        if (!WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true) || tConnectionCount != 1) break;
                        WorldgenStructurePistonDoor.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        WorldgenStructureInteriorCrates.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        break;
                    }
                    case 4: {
                        if (!WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true)) break;
                        WorldgenStructureInteriorLibrary.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        break;
                    }
                    case 5: {
                        WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true);
                    }
                }
                aWorld.func_72964_e((aChunkX >> 4) + i, (aChunkZ >> 4) + j).func_76630_e();
            }
        }
        for (i = 1; i < tRoomLayout.length - 1; ++i) {
            for (j = 1; j < tRoomLayout[i].length - 1; ++j) {
                aWorld.func_72964_e((aChunkX >> 4) + i, (aChunkZ >> 4) + j).func_76630_e();
                tConnectionCount = 0;
                if (tRoomLayout[i + 1][j] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i - 1][j] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i][j + 1] != 0) {
                    ++tConnectionCount;
                }
                if (tRoomLayout[i][j - 1] != 0) {
                    ++tConnectionCount;
                }
                aData = new StructureData(this, tPrimaryBlock, tSecondaryBlock, tRegistry, tLightUpdateCoords, tKeyIDs, tGeneratedKeys, tRoomLayout, i, j, tConnectionCount, tOffsetY, tColor);
                switch (tRoomLayout[i][j]) {
                    case -128: {
                        WorldgenStructureCorridor.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        break;
                    }
                    case -2: {
                        WorldgenStructureEntrance.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                        break;
                    }
                    case -1: {
                        if (!WorldgenStructureRoom.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData, true)) break;
                        WorldgenStructureInteriorBarracks.generate(aWorld, aRandom, aChunkX + i * 16, tOffsetY, aChunkZ + j * 16, aData);
                    }
                }
                aWorld.func_72964_e((aChunkX >> 4) + i, (aChunkZ >> 4) + j).func_76630_e();
            }
        }
        for (ChunkCoordinates tCoords : tLightUpdateCoords) {
            aWorld.func_72915_b(EnumSkyBlock.Block, tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, 15);
            for (byte tSide : CS.ALL_SIDES_MIDDLE) {
                aWorld.func_147463_c(EnumSkyBlock.Block, tCoords.field_71574_a + CS.OFFSETS_X[tSide], tCoords.field_71572_b + CS.OFFSETS_Y[tSide], tCoords.field_71573_c + CS.OFFSETS_Z[tSide]);
                aWorld.func_147451_t(tCoords.field_71574_a + CS.OFFSETS_X[tSide], tCoords.field_71572_b + CS.OFFSETS_Y[tSide], tCoords.field_71573_c + CS.OFFSETS_Z[tSide]);
            }
        }
        return true;
    }

    public static boolean setRandomBricks(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 3 + aRandom.nextInt(3), 2);
    }

    public static boolean setStandardBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 3, 2);
    }

    public static boolean setRedstoneBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 9, 3);
    }

    public static boolean setCrackedBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 4, 2);
    }

    public static boolean setMossyBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 5, 2);
    }

    public static boolean setChiseledStone(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 6, 2);
    }

    public static boolean setSmoothBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, aY == aData.mOffsetY + 2 ? aSecondary : aPrimary, 7, 2);
    }

    public static boolean setAirBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
    }

    public static boolean setRandomBricks(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 3 + aRandom.nextInt(3), 2);
    }

    public static boolean setStandardBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 3, 2);
    }

    public static boolean setRedstoneBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 9, 3);
    }

    public static boolean setCrackedBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 4, 2);
    }

    public static boolean setMossyBrick(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 5, 2);
    }

    public static boolean setChiseledStone(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 6, 2);
    }

    public static boolean setSmoothBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)(aY == aData.mOffsetY + 2 ? aData.mSecondaryBlock : aData.mPrimaryBlock), 7, 2);
    }

    public static boolean setAirBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
    }

    public static boolean setGlass(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.Glass, (int)aData.mColor, 2);
    }

    public static boolean setColored(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom) {
        return aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.CFoam, (int)aData.mColor, 2);
    }

    public static boolean setLampBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Block aPrimary, Block aSecondary, Random aRandom, boolean aGenerateRedstoneBrick) {
        aData.mLightUpdateCoords.add(new ChunkCoordinates(aX, aY, aZ));
        aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150379_bu, 0, 2);
        if (aGenerateRedstoneBrick) {
            WorldgenStructure.setRedstoneBrick(aWorld, aX, aY + 1, aZ, aData, aRandom);
        }
        return true;
    }

    public static boolean setLampBlock(World aWorld, int aX, int aY, int aZ, StructureData aData, Random aRandom, boolean aGenerateRedstoneBrick) {
        aData.mLightUpdateCoords.add(new ChunkCoordinates(aX, aY, aZ));
        aWorld.func_147465_d(aX, aY, aZ, Blocks.field_150379_bu, 0, 2);
        if (aGenerateRedstoneBrick) {
            WorldgenStructure.setRedstoneBrick(aWorld, aX, aY + 1, aZ, aData, aRandom);
        }
        return true;
    }

    public static class StructureData {
        public final MultiTileEntityRegistry mRegistry;
        public final BlockStones mPrimaryBlock;
        public final BlockStones mSecondaryBlock;
        public final byte[][] mRoomLayout;
        public final byte mColor;
        public final byte mColorInversed;
        public final int mRoomX;
        public final int mRoomZ;
        public final int mOffsetY;
        public final int mConnectionCount;
        public final long[] mKeyIDs;
        public final boolean[] mGeneratedKeys;
        public final HashSetNoNulls<ChunkCoordinates> mLightUpdateCoords;
        public final WorldgenStructure mStructure;

        public StructureData(WorldgenStructure aStructure, BlockStones aPrimaryBlock, BlockStones aSecondaryBlock, MultiTileEntityRegistry aRegistry, HashSetNoNulls<ChunkCoordinates> aLightUpdateCoords, long[] aKeyIDs, boolean[] aGeneratedKeys, byte[][] aRoomLayout, int aRoomX, int aRoomZ, int aConnectionCount, int aOffsetY, int aColor) {
            this.mStructure = aStructure;
            this.mPrimaryBlock = aPrimaryBlock;
            this.mSecondaryBlock = aSecondaryBlock;
            this.mRegistry = aRegistry;
            this.mRoomLayout = aRoomLayout;
            this.mRoomX = aRoomX;
            this.mRoomZ = aRoomZ;
            this.mConnectionCount = aConnectionCount;
            this.mOffsetY = aOffsetY;
            this.mKeyIDs = aKeyIDs;
            this.mGeneratedKeys = aGeneratedKeys;
            this.mLightUpdateCoords = aLightUpdateCoords;
            this.mColor = UT.Code.bind4(aColor);
            this.mColorInversed = UT.Code.bind4(15 - aColor);
        }
    }
}

