/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.IOreDictConfigurationComponent;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntitySmeltery
extends TileEntityBase07Paintable
implements ITileEntityEnergy,
ITileEntityWeight,
ITileEntityTemperature,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced {
    private static int GAS_RANGE = 3;
    private static int FLAME_RANGE = 3;
    private static long MAX_AMOUNT = 6721228800L;
    private static long KG_PER_ENERGY = 100L;
    private static double HEAT_RESISTANCE_BONUS = 1.25;
    protected byte mDisplayedHeight = 0;
    protected byte oDisplayedHeight = 0;
    protected byte mCooldown = (byte)100;
    protected short mDisplayedFluid = (short)-1;
    protected short oDisplayedFluid = (short)-1;
    protected long mEnergy = 0L;
    protected long mTemperature = 293L;
    protected long oTemperature = 0L;
    protected TagData mEnergyTypeAccepted = TD.Energy.HU;
    protected List<OreDictMaterialStack> mContent = new ArrayListNoNulls<OreDictMaterialStack>();
    private ITexture mTexture;
    private ITexture mTextureMolten;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.temperature")) {
            this.mTemperature = aNBT.func_74763_f("gt.temperature");
        }
        if (aNBT.func_74764_b("gt.temperature.old")) {
            this.oTemperature = aNBT.func_74763_f("gt.temperature.old");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        this.mContent = OreDictMaterialStack.loadList("gt.materials", aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setNumber(aNBT, "gt.temperature", this.mTemperature);
        UT.NBT.setNumber(aNBT, "gt.temperature.old", this.oTemperature);
        OreDictMaterialStack.saveList("gt.materials", aNBT, this.mContent);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " 1 " + this.mEnergyTypeAccepted.getLocalisedNameShort() + " " + LH.get("gt.lang.energy.convert.to") + " +1 K " + LH.get("gt.lang.energy.convert.per") + " " + KG_PER_ENERGY + "kg");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getTemperatureMax((byte)6) + " K)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.fire") + " (" + (FLAME_RANGE + 1) + "m)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (!this.slotHas(0)) {
                this.slot(0, UT.Worlds.suckOneItemStackAt(this.field_145850_b, (float)this.field_145851_c + CS.PIXELS_POS[2], (float)this.field_145848_d + CS.PIXELS_POS[2], (float)this.field_145849_e + CS.PIXELS_POS[2], CS.PIXELS_NEG[4], 1.0, CS.PIXELS_NEG[4]));
            }
            ItemStack tStack = this.slot(0);
            long tTemperature = UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (UT.Stacks.valid(tStack)) {
                OreDictItemData tData = OM.anydata_(tStack);
                if (tData == null) {
                    this.func_70298_a(0, 1);
                } else {
                    ArrayListNoNulls<OreDictMaterialStack> tList = new ArrayListNoNulls<OreDictMaterialStack>();
                    for (OreDictMaterialStack tMaterial : tData.getAllMaterialStacks()) {
                        if (tMaterial.mAmount <= 0L) continue;
                        tList.add(tMaterial.clone());
                    }
                    if (this.addMaterialStacks(tList, tTemperature)) {
                        this.func_70298_a(0, 1);
                    }
                }
            }
            for (int i = 0; i < this.mContent.size(); ++i) {
                OreDictMaterialStack tMaterial = this.mContent.get(i);
                if (tMaterial == null || tMaterial.mMaterial == MT.NULL || tMaterial.mAmount <= 0L) {
                    this.mContent.remove(i--);
                    continue;
                }
                if (tMaterial.mMaterial.mGramPerCubicCentimeter <= 0.0012) {
                    this.mContent.remove(i--);
                    UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    continue;
                }
                if (this.mTemperature >= tMaterial.mMaterial.mBoilingPoint || this.mTemperature > 313L && tMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) && !tMaterial.mMaterial.contains(TD.Processing.MELTING)) {
                    this.mContent.remove(i--);
                    UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (tMaterial.mMaterial.mBoilingPoint >= 320L) {
                        try {
                            for (EntityLivingBase tLiving : this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - GAS_RANGE), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - GAS_RANGE), (double)(this.field_145851_c + GAS_RANGE + 1), (double)(this.field_145848_d + GAS_RANGE + 1), (double)(this.field_145849_e + GAS_RANGE + 1)))) {
                                UT.Entities.applyHeatDamage((Entity)tLiving, (float)(tMaterial.mMaterial.mBoilingPoint - 300L) / 25.0f);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace(CS.ERR);
                        }
                    }
                    if (tMaterial.mMaterial.mBoilingPoint >= 2000L) {
                        int k = Math.max(1, UT.Code.bindInt(9L * tMaterial.mAmount / 420076800L));
                        for (int j = 0; j < k; ++j) {
                            UT.Worlds.setToFire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.getRandomNumber(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), this.getRandomNumber(3) != 0);
                        }
                    }
                    if (tMaterial.mMaterial.contains(TD.Properties.EXPLOSIVE)) {
                        this.explode(UT.Code.scale(tMaterial.mAmount, 6721228800L, 6L, false));
                    }
                    return;
                }
                if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint && this.oTemperature < tMaterial.mMaterial.mMeltingPoint) {
                    int tSize = this.mContent.size();
                    this.mContent.remove(i--);
                    OM.stack(tMaterial.mMaterial.mTargetSmelting.mMaterial, UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetSmelting.mAmount, false)).addToList(this.mContent);
                    if (tSize != this.mContent.size()) continue;
                    ++i;
                    continue;
                }
                if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint || this.oTemperature < tMaterial.mMaterial.mMeltingPoint) continue;
                int tSize = this.mContent.size();
                this.mContent.remove(i--);
                OM.stack(tMaterial.mMaterial.mTargetSolidifying.mMaterial, UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetSolidifying.mAmount, false)).addToList(this.mContent);
                if (tSize != this.mContent.size()) continue;
                ++i;
            }
            HashSetNoNulls<OreDictMaterial> tAlreadyCheckedAlloys = new HashSetNoNulls<OreDictMaterial>();
            OreDictMaterial tPreferredAlloy = null;
            IOreDictConfigurationComponent tPreferredRecipe = null;
            long tMaxConversions = 0L;
            for (OreDictMaterialStack tMaterial : this.mContent) {
                if (this.mTemperature < tMaterial.mMaterial.mMeltingPoint) continue;
                for (OreDictMaterial tAlloy : tMaterial.mMaterial.mAlloyComponentReferences) {
                    if (!tAlreadyCheckedAlloys.add(tAlloy) || this.mTemperature < tAlloy.mMeltingPoint) continue;
                    for (IOreDictConfigurationComponent tAlloyRecipe : tAlloy.mAlloyCreationRecipes) {
                        ArrayListNoNulls<OreDictMaterialStack> tNeededStuff = new ArrayListNoNulls<OreDictMaterialStack>();
                        for (OreDictMaterialStack tComponent : tAlloyRecipe.getUndividedComponents()) {
                            tNeededStuff.add(OM.stack(tComponent.mMaterial, Math.max(1L, tComponent.mAmount / 420076800L)));
                        }
                        if (tNeededStuff.isEmpty()) continue;
                        int tNonMolten = 0;
                        boolean tBreak = false;
                        long tConversions = Long.MAX_VALUE;
                        for (OreDictMaterialStack tComponent : tNeededStuff) {
                            if (this.mTemperature < tComponent.mMaterial.mMeltingPoint) {
                                ++tNonMolten;
                            }
                            tBreak = true;
                            for (OreDictMaterialStack tContent : this.mContent) {
                                if (tContent.mMaterial != tComponent.mMaterial) continue;
                                tConversions = Math.min(tConversions, tContent.mAmount / tComponent.mAmount);
                                tBreak = false;
                                break;
                            }
                            if (!tBreak) continue;
                            break;
                        }
                        if (tBreak || tNonMolten > true || tConversions <= 0L || tPreferredAlloy != null && tPreferredRecipe != null && tConversions * tAlloyRecipe.getCommonDivider() <= tMaxConversions * tPreferredRecipe.getCommonDivider()) continue;
                        tMaxConversions = tConversions;
                        tPreferredRecipe = tAlloyRecipe;
                        tPreferredAlloy = tAlloy;
                    }
                }
            }
            if (tPreferredAlloy != null && tPreferredRecipe != null) {
                block14: for (OreDictMaterialStack tComponent : tPreferredRecipe.getUndividedComponents()) {
                    for (OreDictMaterialStack tContent : this.mContent) {
                        if (tContent.mMaterial != tComponent.mMaterial) continue;
                        tContent.mAmount -= tMaxConversions * tComponent.mAmount / 420076800L;
                        continue block14;
                    }
                }
                OM.stack(tPreferredAlloy, tPreferredRecipe.getCommonDivider() * tMaxConversions).addToList(this.mContent);
            }
            double tWeight = this.mMaterial.getWeight(2940537600L);
            long tTotal = 0L;
            OreDictMaterialStack tLightest = null;
            for (OreDictMaterialStack tMaterial : this.mContent) {
                if (tLightest == null || tMaterial.mMaterial.mGramPerCubicCentimeter < tLightest.mMaterial.mGramPerCubicCentimeter) {
                    tLightest = tMaterial;
                }
                tWeight += tMaterial.mMaterial.getWeight(tMaterial.mAmount);
                tTotal += tMaterial.mAmount;
            }
            this.oTemperature = this.mTemperature;
            this.mDisplayedHeight = (byte)UT.Code.scale(tTotal, MAX_AMOUNT, 255L, false);
            this.mDisplayedFluid = (short)(tLightest == null || tLightest.mMaterial.mMeltingPoint > this.mTemperature ? -1 : (int)tLightest.mMaterial.mID);
            long tRequiredEnergy = 1L + (long)(tWeight / (double)KG_PER_ENERGY);
            long tConversions = this.mEnergy / tRequiredEnergy;
            if (this.mCooldown > 0) {
                this.mCooldown = (byte)(this.mCooldown - 1);
            }
            if (tConversions > 0L) {
                this.mEnergy -= tConversions * tRequiredEnergy;
                this.mTemperature += tConversions;
                this.mCooldown = (byte)100;
            }
            if (this.mCooldown <= 0) {
                this.mCooldown = (byte)10;
                if (this.mTemperature > tTemperature) {
                    --this.mTemperature;
                } else if (this.mTemperature < tTemperature) {
                    ++this.mTemperature;
                }
            }
            if (this.mTemperature > this.getTemperatureMax((byte)6)) {
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.mTemperature >= 320L) {
                    try {
                        for (EntityLivingBase tLiving : this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - GAS_RANGE), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - GAS_RANGE), (double)(this.field_145851_c + GAS_RANGE + 1), (double)(this.field_145848_d + GAS_RANGE + 1), (double)(this.field_145849_e + GAS_RANGE + 1)))) {
                            UT.Entities.applyHeatDamage((Entity)tLiving, (float)(this.mTemperature - 300L) / 25.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                int k = UT.Code.bindInt(this.mTemperature / 25L);
                for (int j = 0; j < k; ++j) {
                    UT.Worlds.setToFire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.getRandomNumber(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.getRandomNumber(2 * FLAME_RANGE + 1), this.getRandomNumber(3) != 0);
                }
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 1, 3);
                return;
            }
        }
    }

    public boolean addMaterialStacks(List<OreDictMaterialStack> aList, long aTemperature) {
        if (OM.total(this.mContent) + OM.total(aList) <= MAX_AMOUNT) {
            double tWeight2;
            double tWeight1 = OM.weight(this.mContent) + this.mMaterial.getWeight(2940537600L);
            if (tWeight1 + (tWeight2 = OM.weight(aList)) > 0.0) {
                this.mTemperature = aTemperature + UT.Code.units(this.mTemperature - aTemperature, (long)(tWeight1 + tWeight2), (long)tWeight1, false);
            }
            for (OreDictMaterialStack tMaterial : aList) {
                if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint) {
                    OM.stack(tMaterial.mMaterial.mTargetSmelting.mMaterial, UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetSmelting.mAmount, false)).addToList(this.mContent);
                    continue;
                }
                if (aTemperature >= tMaterial.mMaterial.mMeltingPoint || tMaterial.mMaterial.contains(TD.Properties.LIQUID)) {
                    OM.stack(tMaterial.mMaterial.mTargetSolidifying.mMaterial, UT.Code.units(tMaterial.mAmount, 420076800L, tMaterial.mMaterial.mTargetSolidifying.mAmount, false)).addToList(this.mContent);
                    continue;
                }
                tMaterial.addToList(this.mContent);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        return this.mTemperature;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        return (long)((double)this.mMaterial.mMeltingPoint * HEAT_RESISTANCE_BONUS);
    }

    @Override
    public double getWeightValue(byte aSide) {
        double rWeight = 0.0;
        for (OreDictMaterialStack tMaterial : this.mContent) {
            rWeight += tMaterial.mMaterial.getWeight(tMaterial.mAmount);
        }
        return rWeight;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (CS.SIDES_TOP[aSide]) {
            if (this.isServerSide() && aPlayer != null) {
                ItemStack aStack = aPlayer.func_71045_bC();
                OreDictMaterialStack tLightest = null;
                for (OreDictMaterialStack tMaterial : this.mContent) {
                    if (tLightest != null && !(tMaterial.mMaterial.mGramPerCubicCentimeter < tLightest.mMaterial.mGramPerCubicCentimeter)) continue;
                    tLightest = tMaterial;
                }
                if (tLightest != null && this.mTemperature < tLightest.mMaterial.mMeltingPoint) {
                    ItemStack tOutputStack = OP.scrapGt.mat(tLightest.mMaterial, 1L);
                    if (tOutputStack == null || tLightest.mAmount < OP.scrapGt.mAmount) {
                        tLightest.mAmount = 0L;
                        if (this.mTemperature > 313L) {
                            UT.Entities.applyHeatDamage((Entity)aPlayer, (float)this.mTemperature / 100.0f);
                        }
                        return true;
                    }
                    if (aStack == null) {
                        aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, tOutputStack);
                        tLightest.mAmount -= OP.scrapGt.mAmount;
                        if (this.mTemperature > 313L) {
                            UT.Entities.applyHeatDamage((Entity)aPlayer, (float)this.mTemperature / 100.0f);
                        }
                        return true;
                    }
                    if (UT.Stacks.equal(aStack, tOutputStack) && aStack.field_77994_a < aStack.func_77976_d()) {
                        ++aStack.field_77994_a;
                        tLightest.mAmount -= OP.scrapGt.mAmount;
                        if (this.mTemperature > 313L) {
                            UT.Entities.applyHeatDamage((Entity)aPlayer, (float)this.mTemperature / 100.0f);
                        }
                        return true;
                    }
                }
                if (aStack != null) {
                    if ((aStack.func_77973_b() == Items.field_151131_as || IL.Woodbucket_Cu_Water.equal(aStack, false, true) || IL.Woodbucket_Sn_Water.equal(aStack, false, true) || IL.Woodbucket_Zn_Water.equal(aStack, false, true) || IL.Woodbucket_Pb_Water.equal(aStack, false, true) || IL.Woodbucket_Bi_Water.equal(aStack, false, true) || IL.Woodbucket_Bronze_Water.equal(aStack, false, true) || IL.Woodbucket_Brass_Water.equal(aStack, false, true) || IL.Woodbucket_BismuthBronze_Water.equal(aStack, false, true)) && this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(MT.Water, 420076800L * (long)aStack.field_77994_a)), MT.Water.mMeltingPoint + 20L)) {
                        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                            aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, UT.Stacks.container(aStack, true, aStack.field_77994_a));
                        }
                        return true;
                    }
                    if (aStack.func_77973_b() == Items.field_151129_at && this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(MT.Lava, 3780691200L * (long)aStack.field_77994_a)), MT.Lava.mMeltingPoint + 50L)) {
                        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                            aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, UT.Stacks.container(aStack, true, aStack.field_77994_a));
                        }
                        return true;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean fillMoldAtSide(ITileEntityMold aMold, byte aSide, byte aSideOfMold) {
        for (OreDictMaterialStack tContent : this.mContent) {
            long tAmount;
            if (tContent == null || this.mTemperature < tContent.mMaterial.mMeltingPoint || (tAmount = aMold.fillMold(tContent, this.mTemperature, aSideOfMold)) <= 0L) continue;
            tContent.mAmount -= tAmount;
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + "K");
            }
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mTemperature = UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplayedHeight != this.oDisplayedHeight || this.mDisplayedFluid != this.oDisplayedFluid;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedFluid = this.mDisplayedFluid;
        this.oDisplayedHeight = this.mDisplayedHeight;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, this.mDisplayedHeight, UT.Code.toByteS(this.mDisplayedFluid, 0), UT.Code.toByteS(this.mDisplayedFluid, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        if (this.mDisplayedFluid != this.oDisplayedFluid) {
            return this.getClientDataPacketByteArray(false, this.mDisplayedHeight, UT.Code.toByteS(this.mDisplayedFluid, 0), UT.Code.toByteS(this.mDisplayedFluid, 1));
        }
        return this.getClientDataPacketByteArray(false, this.mDisplayedHeight);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedHeight = aData[0];
        if (aData.length >= 3) {
            this.mDisplayedFluid = UT.Code.combine(aData[1], aData[2]);
        }
        if (aData.length >= 6) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4]), UT.Code.unsignB(aData[5])});
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], 0.125f + (float)UT.Code.unsignB(this.mDisplayedHeight) / 292.57144f, CS.PIXELS_NEG[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            OreDictMaterial tMaterial;
            this.mTexture = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, UT.Code.getRGBaArray(this.mRGBa), this.mMaterial.contains(TD.Properties.GLOWING));
            this.mTextureMolten = UT.Code.exists(this.mDisplayedFluid, OreDictMaterial.MATERIAL_ARRAY) ? ((tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedFluid]) == MT.Lava ? BlockTextureCopied.get(Blocks.field_150353_l, 6, 0, CS.UNCOLOURED, false, true, true) : (tMaterial == MT.Water ? BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Glowstone ? BlockTextureCopied.get(Blocks.field_150426_aN, 6, 0, CS.UNCOLOURED, false, true, true) : BlockTextureDefault.get(tMaterial, CS.IconsGT.INDEX_BLOCK_MOLTEN, 1, true)))) : BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_64, false);
        }
        switch (aRenderPass) {
            case 0: 
            case 2: {
                return CS.SIDES_AXIS_Z[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 1: 
            case 3: {
                return CS.SIDES_AXIS_X[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 4: {
                return CS.SIDES_VERTICAL[aSide] ? this.mTexture : null;
            }
            case 5: {
                return this.mDisplayedHeight != 0 && CS.SIDES_TOP[aSide] ? this.mTextureMolten : null;
            }
        }
        return this.mTexture;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (UT.Entities.applyTemperatureDamage(aEntity, this.mTemperature, 2.0f) && aEntity instanceof EntityLivingBase && !((EntityLivingBase)aEntity).func_70089_S()) {
            if (aEntity instanceof EntityVillager || aEntity instanceof EntityWitch) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(840153600L, MT.SoylentGreen)), 310L);
            } else if (aEntity instanceof EntitySnowman) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1680307200L, MT.Snow)), 263L);
            } else if (aEntity instanceof EntityIronGolem) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1680307200L, MT.Fe)), UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntitySkeleton) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(420076800L, MT.Bone), ((EntitySkeleton)aEntity).func_82202_m() == 1 ? OM.stack(420076800L, MT.Coal) : null), UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntityZombie) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(420076800L, MT.Bone)), UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntityMooshroom || aEntity instanceof EntityCow || aEntity instanceof EntityHorse) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1260230400L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityPig || aEntity instanceof EntitySheep || aEntity instanceof EntityWolf || aEntity instanceof EntitySquid) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(840153600L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityChicken || aEntity instanceof EntityOcelot || aEntity instanceof EntitySpider || aEntity instanceof EntitySilverfish) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(420076800L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityCreeper) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(420076800L, MT.Gunpowder)), 293L);
            } else if (aEntity instanceof EntityEnderman) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(420076800L, MT.EnderPearl)), 293L);
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.125), (double)((double)this.field_145848_d + 0.125), (double)((double)this.field_145849_e + 0.125), (double)((double)this.field_145851_c + 0.875), (double)((double)this.field_145848_d + 0.875), (double)((double)this.field_145849_e + 0.875));
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List aList, Entity aEntity) {
        AxisAlignedBB tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[14]), (double)((float)this.field_145848_d + CS.PIXELS_POS[1]), (double)((float)this.field_145849_e + CS.PIXELS_POS[1]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[1]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[1]));
        if (aAABB.func_72326_a(tBox)) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[1]), (double)((float)this.field_145848_d + CS.PIXELS_POS[1]), (double)((float)this.field_145849_e + CS.PIXELS_POS[14]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[1]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[1])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[1]), (double)((float)this.field_145848_d + CS.PIXELS_POS[1]), (double)((float)this.field_145849_e + CS.PIXELS_POS[1]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[14]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[1])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[1]), (double)((float)this.field_145848_d + CS.PIXELS_POS[1]), (double)((float)this.field_145849_e + CS.PIXELS_POS[1]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[1]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[14])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[1]), (double)((float)this.field_145848_d + CS.PIXELS_POS[1]), (double)((float)this.field_145849_e + CS.PIXELS_POS[1]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[1]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[14]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[1])))) {
            aList.add(tBox);
        }
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return CS.SIDES_TOP[aSide] && this.slot(0) == null;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aEnergyType == this.mEnergyTypeAccepted && this.getSurfaceSizeAttachable(aSide) > 0.0f;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            this.mEnergy += Math.abs(aAmount * aSize);
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return Long.MAX_VALUE - this.mEnergy;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 0x3FFFFFFFFFFFFFFFL;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.smeltery";
    }
}

