/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntitySiftingTable
extends TileEntityBase07Paintable
implements IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected short mDisplayedInput = 0;
    protected short mDisplayedOutput = 0;
    protected short oDisplayedInput = (short)-1;
    protected short oDisplayedOutput = (short)-1;
    protected byte mState = 0;
    protected byte oState = 0;
    protected byte mClickCount = 0;
    protected Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sSifterRecipes;
    protected Recipe mLastRecipe = null;
    public static IIconContainer sTextureLegs = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/legs");
    public static IIconContainer sTextureGrid = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/grid");
    public static IIconContainer sTextureBorder = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/border");
    public static IIconContainer sTexturePlate = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/colored/plate");
    public static IIconContainer sOverlayLegs = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/legs");
    public static IIconContainer sOverlayGrid = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/grid");
    public static IIconContainer sOverlayBorder = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/border");
    public static IIconContainer sOverlayPlate = new Textures.BlockIcons.CustomIcon("machines/tools/sifting_table/overlay/plate");
    private ITexture mTextureLegs;
    private ITexture mTextureGrid;
    private ITexture mTextureBorder;
    private ITexture mTexturePlate;
    private ITexture mTextureInput;
    private ITexture mTextureOutput;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mState = aNBT.func_74771_c("gt.state");
        }
        if (aNBT.func_74764_b("gt.progress")) {
            this.mClickCount = aNBT.func_74771_c("gt.progress");
        }
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.state", this.mState);
        aNBT.func_74774_a("gt.progress", this.mClickCount);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.sifter.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mState = 0;
            ItemStack tStack = this.slot(0);
            if (UT.Stacks.valid(tStack)) {
                OreDictItemData tData;
                this.mState = (byte)(this.mState | CS.B[0]);
                this.mDisplayedInput = UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150351_n, 1L, 32767L)) ? (short)-1 : (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 0L)) ? (short)-2 : (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 1L)) ? (short)-3 : (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 2L)) ? (short)-4 : (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 0L)) ? (short)-5 : (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 1L)) ? (short)-6 : (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150349_c, 1L, 32767L)) ? (short)-7 : (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150391_bh, 1L, 32767L)) ? (short)-8 : (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150425_aM, 1L, 32767L)) ? (short)-9 : ((tData = OM.data_(tStack)) == null || tData.mMaterial == null ? (short)0 : tData.mMaterial.mMaterial.mID)))))))));
            }
            for (int i = 1; i < 13; ++i) {
                tStack = this.slot(i);
                if (!UT.Stacks.valid(tStack)) continue;
                this.mState = (byte)(this.mState | CS.B[1]);
                if (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150351_n, 1L, 32767L))) {
                    this.mDisplayedOutput = (short)-1;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 0L))) {
                    this.mDisplayedOutput = (short)-2;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 1L))) {
                    this.mDisplayedOutput = (short)-3;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150346_d, 1L, 2L))) {
                    this.mDisplayedOutput = (short)-4;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 0L))) {
                    this.mDisplayedOutput = (short)-5;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150354_m, 1L, 1L))) {
                    this.mDisplayedOutput = (short)-6;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150349_c, 1L, 32767L))) {
                    this.mDisplayedOutput = (short)-7;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make((Block)Blocks.field_150391_bh, 1L, 32767L))) {
                    this.mDisplayedOutput = (short)-8;
                    break;
                }
                if (UT.Stacks.equal(tStack, UT.Stacks.make(Blocks.field_150425_aM, 1L, 32767L))) {
                    this.mDisplayedOutput = (short)-9;
                    break;
                }
                OreDictItemData tData = OM.data_(tStack);
                if (tData == null || tData.mMaterial == null) {
                    this.mDisplayedOutput = 0;
                    break;
                }
                this.mDisplayedOutput = tData.mMaterial.mMaterial.mID;
                break;
            }
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            if (CS.SIDES_TOP[aSide]) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                if (tCoords[0] <= CS.PIXELS_POS[2] && tCoords[1] <= CS.PIXELS_POS[2]) {
                    return true;
                }
                ItemStack aStack = this.slot(0);
                if (aStack == null) {
                    this.mClickCount = 0;
                    UT.Inventories.moveFromSlotToSlot((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, 0, null, false, 64, 1, 64, 1);
                } else {
                    boolean temp = true;
                    for (int i = 1; i < 13; ++i) {
                        if (this.slot(i) == null) continue;
                        temp = false;
                        break;
                    }
                    if (temp && this.mRecipes != null && UT.Entities.isPlayer(aPlayer) && ((this.mClickCount = (byte)(this.mClickCount + 1)) >= 20 || UT.Entities.hasInfiniteItems(aPlayer))) {
                        this.mClickCount = 0;
                        Recipe tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, false, CS.V[1], null, CS.ZL_FLUIDSTACK, aStack);
                        if (tRecipe == null) {
                            for (int i = 1; i < 13; ++i) {
                                if (!this.addStackToSlot(i, aStack)) continue;
                                this.slot(0, null);
                                break;
                            }
                        } else {
                            if (tRecipe.mCanBeBuffered) {
                                this.mLastRecipe = tRecipe;
                            }
                            if (tRecipe.isRecipeInputEqual(true, false, null, aStack)) {
                                if (aStack.field_77994_a <= 0) {
                                    this.slot(0, null);
                                }
                                ItemStack[] tOutputs = tRecipe.getOutputs(this.field_145850_b.field_73012_v);
                                int j = Math.min(tOutputs.length, 12);
                                for (int i = 0; i < j; ++i) {
                                    this.addStackToSlot(i + 1, tOutputs[i]);
                                }
                                aPlayer.func_71020_j((float)(tRecipe.mEUt * tRecipe.mDuration) / 10000.0f);
                            }
                        }
                    }
                }
            } else {
                for (int i = 1; i < 13; ++i) {
                    if (!UT.Inventories.addStackToPlayerInventory(aPlayer, this.slot(i), false)) continue;
                    this.slot(i, null);
                }
            }
        } else if (CS.SIDES_TOP[aSide]) {
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
            if (tCoords[0] <= CS.PIXELS_POS[2] && tCoords[1] <= CS.PIXELS_POS[2]) {
                this.mRecipes.openNEI();
                return true;
            }
            if ((this.mState & CS.B[0]) != 0) {
                UT.Sounds.play("dig.sand", 5, 1.0f, 1.0f, this.getCoords());
            }
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mState != this.oState || this.mDisplayedOutput != this.oDisplayedOutput || this.mDisplayedInput != this.oDisplayedInput;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oState = this.mState;
        this.oDisplayedInput = this.mDisplayedInput;
        this.oDisplayedOutput = this.mDisplayedOutput;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1), UT.Code.toByteS(this.mDisplayedInput, 0), UT.Code.toByteS(this.mDisplayedInput, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        if (this.mDisplayedInput != this.oDisplayedInput) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1), UT.Code.toByteS(this.mDisplayedInput, 0), UT.Code.toByteS(this.mDisplayedInput, 1));
        }
        if (this.mDisplayedOutput != this.oDisplayedOutput) {
            return this.getClientDataPacketByteArray(aSendAll, this.mState, UT.Code.toByteS(this.mDisplayedOutput, 0), UT.Code.toByteS(this.mDisplayedOutput, 1));
        }
        return this.getClientDataPacketByte(aSendAll, this.mState);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mState = aData[0];
        if (aData.length > 2) {
            this.mDisplayedOutput = UT.Code.combine(aData[1], aData[2]);
        }
        if (aData.length > 4) {
            this.mDisplayedInput = UT.Code.combine(aData[3], aData[4]);
        }
        if (aData.length > 7) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[5]), UT.Code.unsignB(aData[6]), UT.Code.unsignB(aData[7])});
        }
        return true;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mState = aData;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 9;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_POS[13], CS.PIXELS_NEG[14]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_POS[13], CS.PIXELS_NEG[14]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[14], CS.PIXELS_POS[13], CS.PIXELS_NEG[0]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_POS[13], CS.PIXELS_NEG[0]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[10], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_POS[12], CS.PIXELS_NEG[0]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_NEG[0] - 1.0E-4f, CS.PIXELS_POS[12], CS.PIXELS_NEG[0] - 1.0E-4f, CS.PIXELS_POS[0] + 1.0E-4f, CS.PIXELS_POS[10], CS.PIXELS_POS[0] + 1.0E-4f);
                return true;
            }
            case 6: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_POS[5], CS.PIXELS_NEG[0]);
                return true;
            }
            case 7: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[10] - 1.0E-4f, CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_POS[this.mDisplayedInput < 0 ? 16 : 14], CS.PIXELS_NEG[2]);
                return true;
            }
            case 8: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[5], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_POS[8], CS.PIXELS_NEG[2]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            OreDictMaterial tMaterial;
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureLegs = BlockTextureMulti.get(BlockTextureDefault.get(sTextureLegs, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayLegs));
            this.mTextureGrid = BlockTextureMulti.get(BlockTextureDefault.get(sTextureGrid, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayGrid));
            this.mTextureBorder = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBorder, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayBorder));
            this.mTexturePlate = BlockTextureMulti.get(BlockTextureDefault.get(sTexturePlate, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayPlate));
            this.mTextureInput = BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_64, false);
            this.mTextureOutput = BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_64, false);
            if (this.mDisplayedInput != 0) {
                if (UT.Code.exists(this.mDisplayedInput, OreDictMaterial.MATERIAL_ARRAY)) {
                    tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedInput];
                    this.mTextureInput = BlockTextureDefault.get(tMaterial, OP.blockDust.mIconIndexBlock, tMaterial.contains(TD.Properties.GLOWING));
                } else if (this.mDisplayedInput < 0) {
                    switch (this.mDisplayedInput) {
                        case -1: {
                            this.mTextureInput = BlockTextureCopied.get(Blocks.field_150351_n, 6, 0);
                            break;
                        }
                        case -2: {
                            this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 0);
                            break;
                        }
                        case -3: {
                            this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 1);
                            break;
                        }
                        case -4: {
                            this.mTextureInput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 2);
                            break;
                        }
                        case -5: {
                            this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 0);
                            break;
                        }
                        case -6: {
                            this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 1);
                            break;
                        }
                        case -7: {
                            this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150349_c, 6, 0, new short[]{106, 170, 64, 255}, false, false, false);
                            break;
                        }
                        case -8: {
                            this.mTextureInput = BlockTextureCopied.get((Block)Blocks.field_150391_bh, 6, 0);
                            break;
                        }
                        case -9: {
                            this.mTextureInput = BlockTextureCopied.get(Blocks.field_150425_aM, 6, 0);
                        }
                    }
                }
            }
            if (this.mDisplayedOutput != 0) {
                if (UT.Code.exists(this.mDisplayedOutput, OreDictMaterial.MATERIAL_ARRAY)) {
                    tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedOutput];
                    this.mTextureOutput = BlockTextureDefault.get(tMaterial, OP.blockDust.mIconIndexBlock, tMaterial.contains(TD.Properties.GLOWING));
                } else if (this.mDisplayedOutput < 0) {
                    switch (this.mDisplayedOutput) {
                        case -1: {
                            this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150351_n, 6, 0);
                            break;
                        }
                        case -2: {
                            this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 0);
                            break;
                        }
                        case -3: {
                            this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 1);
                            break;
                        }
                        case -4: {
                            this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150346_d, 6, 2);
                            break;
                        }
                        case -5: {
                            this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 0);
                            break;
                        }
                        case -6: {
                            this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150354_m, 6, 1);
                            break;
                        }
                        case -7: {
                            this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150349_c, 6, 0, new short[]{106, 170, 64, 255}, false, false, false);
                            break;
                        }
                        case -8: {
                            this.mTextureOutput = BlockTextureCopied.get((Block)Blocks.field_150391_bh, 6, 0);
                            break;
                        }
                        case -9: {
                            this.mTextureOutput = BlockTextureCopied.get(Blocks.field_150425_aM, 6, 0);
                        }
                    }
                }
            }
        }
        if (aRenderPass == 0) {
            return CS.SIDES_TOP[aSide] ? BlockTextureMulti.get(this.mTextureLegs, BI.nei()) : this.mTextureLegs;
        }
        if (aRenderPass < 4) {
            return this.mTextureLegs;
        }
        if (aRenderPass < 6) {
            return CS.SIDES_VERTICAL[aSide] ? this.mTextureGrid : this.mTextureBorder;
        }
        return aRenderPass == 6 ? this.mTexturePlate : (aRenderPass == 7 ? ((this.mState & CS.B[0]) != 0 ? this.mTextureInput : null) : ((this.mState & CS.B[1]) != 0 ? (CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTextureOutput : null) : null));
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[4]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[4]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[4], CS.PIXELS_NEG[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_NEG[4] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[13];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 && this.mRecipes != null && this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI) && !OP.crushedPurifiedTiny.contains(aStack);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot != 0;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.sifter.table";
    }
}

