/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.machines.ITileEntityAnvil;
import gregapi.util.OM;
import gregapi.util.UT;
import gregtech.tileentity.misc.MultiTileEntityCoin;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityMoldCoinage
extends TileEntityBase07Paintable
implements ITileEntityAnvil,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataShort {
    protected boolean mIsUnique = false;
    protected short mDisplayedMetal = (short)-1;
    protected short oDisplayedMetal = (short)-1;
    protected boolean[][][] mShape = new boolean[2][16][16];
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/bottom");
    public static IIconContainer sTextureSide = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/side");
    public static IIconContainer sTextureHole = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/hole");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/bottom");
    public static IIconContainer sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/side");
    public static IIconContainer sOverlayHole = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/hole");
    private ITexture mTextureHole;
    private ITexture[] mTextureSides = new ITexture[3];
    private ITexture mTextureContent;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        for (i = 0; i < this.mShape[0].length; ++i) {
            this.mShape[0][i] = UT.Code.getBitsS(aNBT.func_74765_d("gt.coin.shape.0." + i));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            this.mShape[1][i] = UT.Code.getBitsS(aNBT.func_74765_d("gt.coin.shape.1." + i));
        }
        this.mIsUnique = aNBT.func_74767_n("gt.coin.unique");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.func_74777_a("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.func_74777_a("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        int i;
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.func_74777_a("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.func_74777_a("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold.coinage"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold.select") + " (Doesn't work right now)");
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (UT.Stacks.invalid(this.slot(0))) {
                this.mDisplayedMetal = 0;
            } else {
                OreDictItemData tData = OM.data_(this.slot(0));
                if (tData != null && tData.mMaterial != null) {
                    this.mDisplayedMetal = tData.mMaterial.mMaterial.mID;
                }
            }
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP_HORIZONTAL[aSide]) {
            ItemStack tOutputStack = this.slot(0);
            ItemStack aStack = aPlayer.func_71045_bC();
            if (tOutputStack == null) {
                OreDictItemData tData = OM.anyassociation(aStack);
                if (tData != null && tData.mPrefix == OP.plateTiny) {
                    if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                        --aStack.field_77994_a;
                    }
                    this.slot(0, UT.Stacks.amount(1L, aStack));
                    UT.Sounds.send(this.field_145850_b, "random.click", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    return true;
                }
            } else if (UT.Inventories.addStackToPlayerInventory(aPlayer, tOutputStack, false)) {
                this.slot(0, null);
            }
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("hammer") && CS.SIDES_TOP[aSide]) {
            if (aRemainingDurability >= 2000L) {
                OreDictItemData tData = OM.anyassociation(this.slot(0));
                if (tData != null && tData.mPrefix == OP.plateTiny) {
                    this.slot(0, MultiTileEntityCoin.getCoin(this.slot((int)0).field_77994_a, tData.mMaterial.mMaterial, this.mIsUnique, this.mShape));
                    return 2000L;
                }
                return 0L;
            }
            UT.Sounds.send(this.field_145850_b, "random.break", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return aRemainingDurability;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplayedMetal != this.oDisplayedMetal;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedMetal = this.mDisplayedMetal;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, UT.Code.toByteS(this.mDisplayedMetal, 0), UT.Code.toByteS(this.mDisplayedMetal, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketShort(false, this.mDisplayedMetal);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedMetal = UT.Code.combine(aData[0], aData[1]);
        if (aData.length >= 5) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedMetal = aData;
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[4], CS.PIXELS_NEG[0]);
            return true;
        }
        if (aRenderPass == 1) {
            aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[12], CS.PIXELS_POS[4], CS.PIXELS_NEG[4], CS.PIXELS_NEG[2], CS.PIXELS_NEG[4]);
            return true;
        }
        if (aRenderPass == 2) {
            aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[11], CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[3], CS.PIXELS_NEG[5]);
            return true;
        }
        if (aRenderPass == 3) {
            aBlock.func_149676_a(CS.PIXELS_POS[11], CS.PIXELS_POS[12], CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[2], CS.PIXELS_NEG[5]);
            return true;
        }
        if (aRenderPass == 4) {
            aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[12], CS.PIXELS_POS[11], CS.PIXELS_NEG[5], CS.PIXELS_NEG[2], CS.PIXELS_NEG[5]);
            return true;
        }
        if (aRenderPass == 5) {
            aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[12], CS.PIXELS_POS[5], CS.PIXELS_NEG[11], CS.PIXELS_NEG[2], CS.PIXELS_NEG[5]);
            return true;
        }
        if (aRenderPass == 6) {
            aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[12], CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[2], CS.PIXELS_NEG[11]);
            return true;
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureHole = BlockTextureMulti.get(BlockTextureDefault.get(sTextureHole, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole));
            this.mTextureSides[0] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayBottom));
            this.mTextureSides[1] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayTop));
            this.mTextureSides[2] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureSide, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlaySide));
            if (this.mDisplayedMetal != 0 && UT.Code.exists(this.mDisplayedMetal, OreDictMaterial.MATERIAL_ARRAY)) {
                OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedMetal];
                this.mTextureContent = BlockTextureDefault.get(tMaterial, OP.blockSolid.mIconIndexBlock, tMaterial.contains(TD.Properties.GLOWING));
            } else {
                this.mTextureContent = null;
            }
        }
        if (aRenderPass == 1) {
            return CS.SIDES_TOP[aSide] ? this.mTextureHole : this.mTextureSides[CS.FACES_TBS[aSide]];
        }
        if (aRenderPass == 2) {
            return this.mTextureContent;
        }
        if (aRenderPass == 3) {
            return aSide == 4 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 4) {
            return aSide == 2 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 5) {
            return aSide == 5 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 6) {
            return aSide == 3 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        return this.mTextureSides[CS.FACES_TBS[aSide]];
    }

    @Override
    public boolean isAnvil(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[4]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[4]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[4], CS.PIXELS_NEG[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_NEG[4] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        OreDictItemData tData = OM.anyassociation(aStack);
        return tData != null && tData.mPrefix == OP.plateTiny;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        OreDictItemData tData = OM.anyassociation(this.slot(aSlot));
        return tData == null || tData.mPrefix != OP.plateTiny;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.mold.coins";
    }
}

