/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.util.OM;
import gregapi.util.UT;
import gregtech.tileentity.tools.MultiTileEntitySmeltery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityMold
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityTemperature,
ITileEntityMold,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_SyncDataShort {
    private static double HEAT_RESISTANCE_BONUS;
    public static final Map<Integer, OreDictPrefix> MOLD_RECIPES;
    protected boolean mUseRedstone = false;
    protected byte mAutoPullDirections = 0;
    protected short mDisplayedFluid = (short)-1;
    protected short oDisplayedFluid = (short)-1;
    protected int mShape = 0;
    protected long mTemperature = 293L;
    protected OreDictMaterialStack mContent = null;
    protected static final float[][] MOLD_BOUNDS;
    private ITexture mTexture;
    private ITexture mTextureMolten;
    private static final int[] ACCESSIBLE_SLOTS;

    public static OreDictPrefix getMoldRecipe(int aShape) {
        if (aShape == 0) {
            return null;
        }
        OreDictPrefix rRecipe = MOLD_RECIPES.get(aShape & CS.B[25] - 1);
        return rRecipe == null ? OP.nugget : rRecipe;
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mold")) {
            this.mShape = aNBT.func_74762_e("gt.mold");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mUseRedstone = aNBT.func_74767_n("gt.mode");
        }
        if (aNBT.func_74764_b("gt.connection")) {
            this.mAutoPullDirections = aNBT.func_74771_c("gt.connection");
        }
        if (aNBT.func_74764_b("gt.temperature")) {
            this.mTemperature = aNBT.func_74763_f("gt.temperature");
        }
        this.mContent = OreDictMaterialStack.load("gt.materials", aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.connection", this.mAutoPullDirections);
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mUseRedstone);
        UT.NBT.setNumber(aNBT, "gt.temperature", this.mTemperature);
        UT.NBT.setNumber(aNBT, "gt.mold", this.mShape);
        if (this.mContent != null) {
            this.mContent.save("gt.materials", aNBT);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.func_74768_a("gt.mold", this.mShape);
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        if (this.mShape == 0) {
            aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold.select"));
        } else {
            aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold") + " " + MultiTileEntityMold.getMoldRecipe((int)this.mShape).mNameCategory);
        }
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getMoldMaxTemperature() + " K)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.inputs"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            long tTemperature = UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.mTemperature > tTemperature) {
                this.mTemperature -= Math.min(5L, this.mTemperature - tTemperature);
            } else if (this.mTemperature < tTemperature) {
                this.mTemperature += Math.min(5L, tTemperature - this.mTemperature);
            }
            if (this.slot(0) == null) {
                if (this.mContent != null && this.mContent.mAmount <= 0L) {
                    this.mContent = null;
                    this.mTemperature = tTemperature;
                }
                if ((this.mInventoryChanged || this.mTimer % 50L == 0L || this.mBlockUpdated && this.mUseRedstone) && (!this.mUseRedstone || this.hasRedstoneIncoming()) && this.mContent == null && this.mAutoPullDirections != 0) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (!CS.FACE_CONNECTED[tSide][this.mAutoPullDirections]) continue;
                        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                        if (!(tDelegator.mTileEntity instanceof MultiTileEntitySmeltery)) continue;
                        ((MultiTileEntitySmeltery)tDelegator.mTileEntity).fillMoldAtSide(this, tDelegator.mSideOfTileEntity, tSide);
                    }
                }
            }
            if (this.mContent != null && this.mTemperature > this.mContent.mMaterial.mBoilingPoint) {
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.mContent = null;
            }
            if (this.mContent == null) {
                this.mDisplayedFluid = 0;
            } else {
                this.mDisplayedFluid = this.mContent.mMaterial.mID;
                if (this.mDisplayedFluid < 0) {
                    this.mDisplayedFluid = MT.Tc.mID;
                }
                if (this.mTemperature < this.mContent.mMaterial.mMeltingPoint) {
                    this.mContent.mMaterial = this.mContent.mMaterial.mTargetSolidifying.mMaterial;
                    this.mDisplayedFluid = ~this.mDisplayedFluid;
                    if (this.mContent.mAmount > 0L && this.slot(0) == null) {
                        OreDictPrefix tPrefix = MultiTileEntityMold.getMoldRecipe(this.mShape);
                        if (tPrefix == OP.plate && this.mContent.mMaterial == MT.Glass) {
                            tPrefix = OP.plateGem;
                        }
                        if (tPrefix != null) {
                            this.slot(0, tPrefix.mat(this.mContent.mMaterial, this.mContent.mMaterial == MT.Blaze && (tPrefix == OP.stick || tPrefix == OP.stickLong) ? 1L : this.mContent.mAmount / tPrefix.mAmount));
                            this.mContent.mAmount = 0L;
                        }
                    }
                }
            }
            if (this.mTemperature > this.getMoldMaxTemperature()) {
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 1, 3);
                return;
            }
        }
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        return this.mTemperature;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        return this.getMoldMaxTemperature();
    }

    @Override
    public boolean isMoldInputSide(byte aSide) {
        return CS.SIDES_HORIZONTAL[aSide];
    }

    @Override
    public long getMoldMaxTemperature() {
        return (long)((double)this.mMaterial.mMeltingPoint * HEAT_RESISTANCE_BONUS);
    }

    @Override
    public long getMoldRequiredMaterialUnits() {
        OreDictPrefix tPrefix = MultiTileEntityMold.getMoldRecipe(this.mShape);
        if (tPrefix == null) {
            return 0L;
        }
        if (tPrefix == OP.nugget) {
            long rAmount = 0L;
            for (int i = 0; i < 25; ++i) {
                if ((this.mShape & CS.B[i]) == 0) continue;
                rAmount += 46675200L;
            }
            return rAmount;
        }
        return tPrefix.mAmount;
    }

    @Override
    public long fillMold(OreDictMaterialStack aMaterial, long aTemperature, byte aSide) {
        OreDictPrefix tPrefix = MultiTileEntityMold.getMoldRecipe(this.mShape);
        if (tPrefix != null && this.mContent == null && this.slot(0) == null && this.isMoldInputSide(aSide) && aMaterial != null && aMaterial.mAmount > 0L) {
            long tRequiredAmount;
            long rAmount;
            if (tPrefix == OP.plate && aMaterial.mMaterial == MT.Glass) {
                tPrefix = OP.plateGem;
            }
            if (tPrefix.mat(aMaterial.mMaterial.mTargetSolidifying.mMaterial, 1L) != null && aMaterial.mAmount >= (rAmount = UT.Code.units(tRequiredAmount = aMaterial.mMaterial == MT.Blaze && (tPrefix == OP.stick || tPrefix == OP.stickLong) ? this.getMoldRequiredMaterialUnits() * 16L : this.getMoldRequiredMaterialUnits(), 420076800L, aMaterial.mMaterial.mTargetSolidifying.mAmount, true))) {
                this.mContent = OM.stack(aMaterial.mMaterial, tRequiredAmount);
                this.mTemperature = aTemperature;
                return rAmount;
            }
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP_HORIZONTAL[aSide] && !this.pickUpItem(aPlayer, true) && CS.SIDES_TOP[aSide]) {
            byte tSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.isMoldInputSide(tSide)) {
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (tDelegator.mTileEntity instanceof MultiTileEntitySmeltery) {
                    ((MultiTileEntitySmeltery)tDelegator.mTileEntity).fillMoldAtSide(this, tDelegator.mSideOfTileEntity, tSide);
                    return true;
                }
            }
            if (CS.SIDES_VERTICAL[tSide]) {
                for (byte tSide2 : CS.ALL_SIDES_HORIZONTAL) {
                    if (!this.isMoldInputSide(tSide2)) continue;
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide2);
                    if (!(tDelegator.mTileEntity instanceof MultiTileEntitySmeltery)) continue;
                    ((MultiTileEntitySmeltery)tDelegator.mTileEntity).fillMoldAtSide(this, tDelegator.mSideOfTileEntity, tSide2);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean pickUpItem(EntityPlayer aPlayer, boolean aCauseDamage) {
        ItemStack tOutputStack = this.slot(0);
        if (tOutputStack != null) {
            ItemStack aStack;
            OreDictItemData tData = OM.anyassociation(tOutputStack);
            if (tData != null) {
                for (Achievement tAchievement : tData.mMaterial.mMaterial.mAchievementsForCreation) {
                    aPlayer.func_71029_a((StatBase)tAchievement);
                }
            }
            if ((aStack = aPlayer.func_71045_bC()) == null) {
                aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, tOutputStack);
                this.slot(0, null);
                if (aCauseDamage) {
                    UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f);
                }
                return true;
            }
            if (UT.Stacks.equal(aStack, tOutputStack) && aStack.field_77994_a < aStack.func_77976_d()) {
                int tDifference = Math.min(tOutputStack.field_77994_a, aStack.func_77976_d() - aStack.field_77994_a);
                aStack.field_77994_a += tDifference;
                this.func_70298_a(0, tDifference);
                if (aCauseDamage) {
                    UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f);
                }
                return true;
            }
            if (UT.Inventories.addStackToPlayerInventory(aPlayer, this.slot(0), false)) {
                if (aCauseDamage) {
                    UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f);
                }
                this.slot(0, null);
                return true;
            }
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        int tBit;
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + "K");
            }
            return 10000L;
        }
        if (aTool.equals("chisel") && this.mContent == null && this.slot(0) == null && aHitX > CS.PIXELS_POS[2] && aHitX < CS.PIXELS_NEG[2] && aHitZ > CS.PIXELS_POS[2] && aHitZ < CS.PIXELS_NEG[2] && (this.mShape & (tBit = CS.B[(int)(5.0f * (aHitX - CS.PIXELS_POS[2]) / CS.PIXELS_POS[12]) * 5 + (int)(5.0f * (aHitZ - CS.PIXELS_POS[2]) / CS.PIXELS_POS[12])])) == 0) {
            UT.Sounds.send(this.field_145850_b, "dig.stone", 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.mShape |= tBit;
            this.updateClientData();
            return 10000L;
        }
        if (aTool.equals("monkeywrench") && CS.SIDES_TOP[aSide]) {
            byte tSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (this.isMoldInputSide(tSide)) {
                this.mAutoPullDirections = (byte)(this.mAutoPullDirections ^ CS.SBIT[tSide]);
                if (aChatReturn != null) {
                    aChatReturn.add(CS.FACE_CONNECTED[tSide][this.mAutoPullDirections] ? "Crucible Auto-Input: ON" : "Crucible Auto-Input: OFF");
                }
                return 10000L;
            }
            boolean bl = this.mUseRedstone = !this.mUseRedstone;
            if (aChatReturn != null) {
                aChatReturn.add(this.mUseRedstone ? "Crucible Auto-Input: REDSTONE" + (this.mAutoPullDirections == 0 ? " (WARNING: No Direction Selected!)" : "") : "Crucible Auto-Input: NO REDSTONE");
            }
            return 10000L;
        }
        if (aTool.equals("pincers") && aPlayer instanceof EntityPlayer && this.pickUpItem((EntityPlayer)aPlayer, false)) {
            return 10000L;
        }
        if (aTool.equals("wrench") || aTool.equals("screwdriver") || aTool.equals("rotator")) {
            int tResult = 0;
            if ((this.mShape & CS.B[0]) != 0) {
                tResult |= CS.B[4];
            }
            if ((this.mShape & CS.B[1]) != 0) {
                tResult |= CS.B[9];
            }
            if ((this.mShape & CS.B[2]) != 0) {
                tResult |= CS.B[14];
            }
            if ((this.mShape & CS.B[3]) != 0) {
                tResult |= CS.B[19];
            }
            if ((this.mShape & CS.B[4]) != 0) {
                tResult |= CS.B[24];
            }
            if ((this.mShape & CS.B[5]) != 0) {
                tResult |= CS.B[3];
            }
            if ((this.mShape & CS.B[6]) != 0) {
                tResult |= CS.B[8];
            }
            if ((this.mShape & CS.B[7]) != 0) {
                tResult |= CS.B[13];
            }
            if ((this.mShape & CS.B[8]) != 0) {
                tResult |= CS.B[18];
            }
            if ((this.mShape & CS.B[9]) != 0) {
                tResult |= CS.B[23];
            }
            if ((this.mShape & CS.B[10]) != 0) {
                tResult |= CS.B[2];
            }
            if ((this.mShape & CS.B[11]) != 0) {
                tResult |= CS.B[7];
            }
            if ((this.mShape & CS.B[12]) != 0) {
                tResult |= CS.B[12];
            }
            if ((this.mShape & CS.B[13]) != 0) {
                tResult |= CS.B[17];
            }
            if ((this.mShape & CS.B[14]) != 0) {
                tResult |= CS.B[22];
            }
            if ((this.mShape & CS.B[15]) != 0) {
                tResult |= CS.B[1];
            }
            if ((this.mShape & CS.B[16]) != 0) {
                tResult |= CS.B[6];
            }
            if ((this.mShape & CS.B[17]) != 0) {
                tResult |= CS.B[11];
            }
            if ((this.mShape & CS.B[18]) != 0) {
                tResult |= CS.B[16];
            }
            if ((this.mShape & CS.B[19]) != 0) {
                tResult |= CS.B[21];
            }
            if ((this.mShape & CS.B[20]) != 0) {
                tResult |= CS.B[0];
            }
            if ((this.mShape & CS.B[21]) != 0) {
                tResult |= CS.B[5];
            }
            if ((this.mShape & CS.B[22]) != 0) {
                tResult |= CS.B[10];
            }
            if ((this.mShape & CS.B[23]) != 0) {
                tResult |= CS.B[15];
            }
            if ((this.mShape & CS.B[24]) != 0) {
                tResult |= CS.B[20];
            }
            this.mShape = tResult;
            this.updateClientData();
            return 10000L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mTemperature = UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplayedFluid != this.oDisplayedFluid;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedFluid = this.mDisplayedFluid;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, UT.Code.toByteS(this.mDisplayedFluid, 0), UT.Code.toByteS(this.mDisplayedFluid, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), UT.Code.toByteI(this.mShape, 0), UT.Code.toByteI(this.mShape, 1), UT.Code.toByteI(this.mShape, 2), UT.Code.toByteI(this.mShape, 3));
        }
        return this.getClientDataPacketShort(false, this.mDisplayedFluid);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedFluid = UT.Code.combine(aData[0], aData[1]);
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        this.mShape = UT.Code.combine(aData[5], aData[6], aData[7], aData[8]);
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedFluid = aData;
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return MOLD_BOUNDS.length;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass != 0) {
            aBlock.func_149676_a(MOLD_BOUNDS[aRenderPass][0], MOLD_BOUNDS[aRenderPass][1], MOLD_BOUNDS[aRenderPass][2], MOLD_BOUNDS[aRenderPass][3], MOLD_BOUNDS[aRenderPass][4], MOLD_BOUNDS[aRenderPass][5]);
            return true;
        }
        aBlock.func_149676_a(CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[this.mDisplayedFluid < 0 ? 14 : 13] - 0.005f, CS.PIXELS_NEG[1]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            OreDictMaterial tMaterial;
            this.mTexture = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, UT.Code.getRGBaArray(this.mRGBa), this.mMaterial.contains(TD.Properties.GLOWING), false);
            short tDisplayedFluid = (short)(this.mDisplayedFluid < 0 ? ~this.mDisplayedFluid : this.mDisplayedFluid);
            this.mTextureMolten = tDisplayedFluid != 0 && UT.Code.exists(tDisplayedFluid, OreDictMaterial.MATERIAL_ARRAY) ? ((tMaterial = OreDictMaterial.MATERIAL_ARRAY[tDisplayedFluid]) == MT.Lava ? BlockTextureCopied.get(Blocks.field_150353_l, 6, 0, CS.UNCOLOURED, false, true, true) : (tMaterial == MT.Water ? BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false) : (this.mDisplayedFluid < 0 ? (tMaterial == MT.Stone ? BlockTextureCopied.get(Blocks.field_150348_b, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Glass ? BlockTextureCopied.get(Blocks.field_150359_w, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Au ? BlockTextureCopied.get(Blocks.field_150340_R, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Fe ? BlockTextureCopied.get(Blocks.field_150339_S, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Redstone ? BlockTextureCopied.get(Blocks.field_150451_bX, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Obsidian ? BlockTextureCopied.get(Blocks.field_150343_Z, 6, 0, CS.UNCOLOURED, false, false, false) : (tMaterial == MT.Glowstone ? BlockTextureCopied.get(Blocks.field_150426_aN, 6, 0, CS.UNCOLOURED, false, true, true) : (tMaterial == MT.Ice ? BlockTextureCopied.get(Blocks.field_150403_cj, 6, 0, CS.UNCOLOURED, false, false, false) : BlockTextureDefault.get(tMaterial, OP.blockSolid.mIconIndexBlock, 0, tMaterial.contains(TD.Properties.GLOWING)))))))))) : BlockTextureDefault.get(tMaterial, CS.IconsGT.INDEX_BLOCK_MOLTEN, 1, true)))) : null;
        }
        switch (aRenderPass) {
            case 0: {
                return CS.SIDES_TOP[aSide] ? this.mTextureMolten : null;
            }
            case 1: {
                return CS.SIDES_VERTICAL[aSide] ? this.mTexture : null;
            }
            case 2: 
            case 4: {
                return CS.SIDES_BOTTOM[aSide] || CS.SIDES_AXIS_Z[aSide] ? null : this.mTexture;
            }
            case 3: 
            case 5: {
                return CS.SIDES_BOTTOM[aSide] || CS.SIDES_AXIS_X[aSide] ? null : this.mTexture;
            }
            case 8: 
            case 11: 
            case 14: 
            case 17: {
                return this.mTexture;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                return CS.SIDES_HORIZONTAL[aSide] ? this.mTexture : null;
            }
        }
        if ((this.mShape & CS.B[aRenderPass -= 18]) != 0 || CS.SIDES_BOTTOM[aSide]) {
            return null;
        }
        switch (aSide) {
            case 5: {
                return aRenderPass < 20 && (this.mShape & CS.B[aRenderPass + 5]) != 0 ? this.mTexture : null;
            }
            case 4: {
                return aRenderPass >= 5 && (this.mShape & CS.B[aRenderPass - 5]) != 0 ? this.mTexture : null;
            }
            case 3: {
                return aRenderPass % 5 != 4 && (this.mShape & CS.B[aRenderPass + 1]) != 0 ? this.mTexture : null;
            }
            case 2: {
                return aRenderPass % 5 != 0 && (this.mShape & CS.B[aRenderPass - 1]) != 0 ? this.mTexture : null;
            }
        }
        return this.mTexture;
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mTemperature > 313L) {
            UT.Entities.applyHeatDamage(aEntity, (float)this.mTemperature / 100.0f);
        }
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] && super.checkObstruction(aPlayer, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[14]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[13]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[13], CS.PIXELS_NEG[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_POS[10] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return this.mTemperature - 50L < UT.Worlds.getEnvironmentalTemperature(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        return aFluid != null && this.fill(aDirection, UT.Fluids.make(aFluid, Integer.MAX_VALUE), false) > 0;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        if (aFluid == null || aFluid.amount <= 0 || UT.Fluids.gas(aFluid) || this.mContent != null || this.slot(0) != null) {
            return 0;
        }
        OreDictMaterialStack aFluidRatio = OreDictMaterial.FLUID_MAP.get(aFluid.getFluid().getName());
        OreDictMaterialStack aMaterial = null;
        if (aFluidRatio == null || aFluidRatio.mAmount <= 0L) {
            return 0;
        }
        aMaterial = OM.stack(aFluidRatio.mMaterial, UT.Code.units(aFluid.amount, aFluidRatio.mAmount, 420076800L, false));
        if (aMaterial == null || aMaterial.mAmount <= 0L) {
            return 0;
        }
        OreDictPrefix tPrefix = MultiTileEntityMold.getMoldRecipe(this.mShape);
        if (tPrefix == OP.plate && aMaterial.mMaterial == MT.Glass) {
            tPrefix = OP.plateGem;
        }
        if (tPrefix == null || tPrefix.mat(aMaterial.mMaterial.mTargetSolidifying.mMaterial, 1L) == null) {
            return 0;
        }
        long tRequiredAmount = aMaterial.mMaterial == MT.Blaze && (tPrefix == OP.stick || tPrefix == OP.stickLong) ? this.getMoldRequiredMaterialUnits() * 16L : this.getMoldRequiredMaterialUnits();
        long rAmount = UT.Code.units(tRequiredAmount, 420076800L, aMaterial.mMaterial.mTargetSolidifying.mAmount, true);
        if (aMaterial.mAmount >= rAmount) {
            if (aDoFill) {
                this.mContent = OM.stack(aMaterial.mMaterial, tRequiredAmount);
                this.mTemperature = Math.max(UT.Fluids.temperature(aFluid), aMaterial.mMaterial.mMeltingPoint);
            }
            return UT.Code.bindInt(UT.Code.units(rAmount, 420076800L, aFluidRatio.mAmount, true));
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aAmountToDrain, boolean aDoDrain) {
        return CS.NF;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aDirection) {
        return CS.L1_FLUIDTANKINFO_DUMMY;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.mold";
    }

    static {
        int tResult2;
        int tResult1;
        int tKey;
        int i;
        HEAT_RESISTANCE_BONUS = 1.25;
        MOLD_RECIPES = new HashMap<Integer, OreDictPrefix>();
        MOLD_BOUNDS = new float[][]{{CS.PIXELS_POS[1], CS.PIXELS_POS[2], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[15], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[12] + 0.001f, CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[12], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[12] + 0.001f, CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[12], CS.PIXELS_NEG[14]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[4], CS.PIXELS_POS[0], CS.PIXELS_POS[7], CS.PIXELS_POS[6], CS.PIXELS_POS[2]}, {CS.PIXELS_POS[9], CS.PIXELS_POS[4], CS.PIXELS_POS[0], CS.PIXELS_POS[10], CS.PIXELS_POS[6], CS.PIXELS_POS[2]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_POS[10], CS.PIXELS_POS[7], CS.PIXELS_POS[2]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[4], CS.PIXELS_POS[14], CS.PIXELS_POS[7], CS.PIXELS_POS[6], CS.PIXELS_POS[16]}, {CS.PIXELS_POS[9], CS.PIXELS_POS[4], CS.PIXELS_POS[14], CS.PIXELS_POS[10], CS.PIXELS_POS[6], CS.PIXELS_POS[16]}, {CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[14], CS.PIXELS_POS[10], CS.PIXELS_POS[7], CS.PIXELS_POS[16]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[4], CS.PIXELS_POS[6], CS.PIXELS_POS[2], CS.PIXELS_POS[6], CS.PIXELS_POS[7]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[4], CS.PIXELS_POS[9], CS.PIXELS_POS[2], CS.PIXELS_POS[6], CS.PIXELS_POS[10]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[2], CS.PIXELS_POS[7], CS.PIXELS_POS[10]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[4], CS.PIXELS_POS[6], CS.PIXELS_POS[16], CS.PIXELS_POS[6], CS.PIXELS_POS[7]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[4], CS.PIXELS_POS[9], CS.PIXELS_POS[16], CS.PIXELS_POS[6], CS.PIXELS_POS[10]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[16], CS.PIXELS_POS[7], CS.PIXELS_POS[10]}, {CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]}, {CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]}, {CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]}, {CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]}, {CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 4.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 3.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 2.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - 2.0f * CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 3.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2] - CS.PIXELS_POS[12] / 5.0f}, {CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_POS[0], CS.PIXELS_POS[2] + 4.0f * CS.PIXELS_POS[12] / 5.0f, CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]}};
        ACCESSIBLE_SLOTS = new int[]{0};
        HashMap<Integer, OreDictPrefix> TEMP_MOLD_RECIPES = new HashMap<Integer, OreDictPrefix>();
        TEMP_MOLD_RECIPES.put(CS.B[0] | CS.B[1] | CS.B[2] | CS.B[3] | CS.B[5] | CS.B[6] | CS.B[7] | CS.B[8] | CS.B[10] | CS.B[11] | CS.B[12] | CS.B[13] | CS.B[14] | CS.B[15] | CS.B[16] | CS.B[17] | CS.B[18] | CS.B[20] | CS.B[21] | CS.B[22] | CS.B[23], OP.toolHeadRawPlow);
        TEMP_MOLD_RECIPES.put(CS.B[4] | CS.B[8] | CS.B[12] | CS.B[16] | CS.B[20], OP.stickLong);
        TEMP_MOLD_RECIPES.put(CS.B[0] | CS.B[1] | CS.B[2] | CS.B[3] | CS.B[4] | CS.B[5] | CS.B[6] | CS.B[7] | CS.B[8] | CS.B[9] | CS.B[10] | CS.B[11] | CS.B[12] | CS.B[13] | CS.B[14] | CS.B[15] | CS.B[16] | CS.B[17] | CS.B[18] | CS.B[19] | CS.B[20] | CS.B[21] | CS.B[22] | CS.B[23] | CS.B[24], OP.plate);
        TEMP_MOLD_RECIPES.put(CS.B[0] | CS.B[1] | CS.B[2] | CS.B[4] | CS.B[5] | CS.B[6] | CS.B[7] | CS.B[9] | CS.B[10] | CS.B[11] | CS.B[12] | CS.B[14] | CS.B[19] | CS.B[20] | CS.B[21] | CS.B[22], OP.casingSmall);
        TEMP_MOLD_RECIPES.put(CS.B[0] | CS.B[2] | CS.B[4] | CS.B[6] | CS.B[7] | CS.B[8] | CS.B[10] | CS.B[11] | CS.B[13] | CS.B[14] | CS.B[16] | CS.B[17] | CS.B[18] | CS.B[20] | CS.B[22] | CS.B[24], OP.gearGt);
        TEMP_MOLD_RECIPES.put(CS.B[1] | CS.B[3] | CS.B[5] | CS.B[6] | CS.B[7] | CS.B[8] | CS.B[9] | CS.B[11] | CS.B[13] | CS.B[15] | CS.B[16] | CS.B[17] | CS.B[18] | CS.B[19] | CS.B[21] | CS.B[23], OP.gearGtSmall);
        for (i = 0; i < 3; ++i) {
            int j;
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 2] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 7] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 12] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 17] | CS.B[i + 20] | CS.B[i + 21] | CS.B[i + 22], OP.ingot);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 2] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 20] | CS.B[i + 21] | CS.B[i + 22], OP.toolHeadRawAxeDouble);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 2] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 7] | CS.B[i + 10] | CS.B[i + 12] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 17] | CS.B[i + 20] | CS.B[i + 21] | CS.B[i + 22], OP.toolHeadHammer);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 5] | CS.B[i + 10] | CS.B[i + 15] | CS.B[i + 20], OP.stick);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 2] | CS.B[i + 6] | CS.B[i + 11] | CS.B[i + 16] | CS.B[i + 21], OP.toolHeadRawChisel);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 2] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 7] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 12] | CS.B[i + 16] | CS.B[i + 21], OP.toolHeadFile);
            TEMP_MOLD_RECIPES.put(CS.B[i + 1] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 7] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 12] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 17] | CS.B[i + 20] | CS.B[i + 21] | CS.B[i + 22], OP.toolHeadRawSword);
            for (j = 0; j < 4; ++j) {
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 2] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 7], OP.toolHeadRawHoe);
            }
            for (j = 0; j < 3; ++j) {
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 11] | CS.B[i + j * 5 + 12], OP.toolHeadRawArrow);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 2] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 7] | CS.B[i + j * 5 + 10], OP.toolHeadRawAxe);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6], OP.chunkGt);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 2] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 7] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 11] | CS.B[i + j * 5 + 12], OP.ring);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 2] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 7] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 11] | CS.B[i + j * 5 + 12], OP.plateTiny);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 5], OP.bolt);
            }
            for (j = 0; j < 2; ++j) {
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 7] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 11] | CS.B[i + j * 5 + 12] | CS.B[i + j * 5 + 15] | CS.B[i + j * 5 + 16] | CS.B[i + j * 5 + 17], OP.toolHeadRawShovel);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 1] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 6] | CS.B[i + j * 5 + 7] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 11] | CS.B[i + j * 5 + 15] | CS.B[i + j * 5 + 16] | CS.B[i + j * 5 + 17], OP.toolHeadRawUniversalSpade);
                TEMP_MOLD_RECIPES.put(CS.B[i + j * 5 + 0] | CS.B[i + j * 5 + 5] | CS.B[i + j * 5 + 10] | CS.B[i + j * 5 + 15], OP.toolHeadScrewdriver);
            }
        }
        for (i = 0; i < 4; ++i) {
            TEMP_MOLD_RECIPES.put(CS.B[i + 1] | CS.B[i + 5] | CS.B[i + 10] | CS.B[i + 15] | CS.B[i + 21], OP.toolHeadRawPickaxe);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 20] | CS.B[i + 21], OP.toolHeadRawSaw);
            TEMP_MOLD_RECIPES.put(CS.B[i + 0] | CS.B[i + 1] | CS.B[i + 5] | CS.B[i + 6] | CS.B[i + 10] | CS.B[i + 11] | CS.B[i + 15] | CS.B[i + 16] | CS.B[i + 21], OP.toolHeadRawSense);
        }
        for (Map.Entry tEntry : TEMP_MOLD_RECIPES.entrySet()) {
            tKey = (Integer)tEntry.getKey();
            tResult1 = 0;
            tResult2 = 0;
            int tResult3 = 0;
            MOLD_RECIPES.put(tKey, (OreDictPrefix)tEntry.getValue());
            if ((tKey & CS.B[0]) != 0) {
                tResult1 |= CS.B[4];
                tResult2 |= CS.B[24];
                tResult3 |= CS.B[20];
            }
            if ((tKey & CS.B[1]) != 0) {
                tResult1 |= CS.B[9];
                tResult2 |= CS.B[23];
                tResult3 |= CS.B[15];
            }
            if ((tKey & CS.B[2]) != 0) {
                tResult1 |= CS.B[14];
                tResult2 |= CS.B[22];
                tResult3 |= CS.B[10];
            }
            if ((tKey & CS.B[3]) != 0) {
                tResult1 |= CS.B[19];
                tResult2 |= CS.B[21];
                tResult3 |= CS.B[5];
            }
            if ((tKey & CS.B[4]) != 0) {
                tResult1 |= CS.B[24];
                tResult2 |= CS.B[20];
                tResult3 |= CS.B[0];
            }
            if ((tKey & CS.B[5]) != 0) {
                tResult1 |= CS.B[3];
                tResult2 |= CS.B[19];
                tResult3 |= CS.B[21];
            }
            if ((tKey & CS.B[6]) != 0) {
                tResult1 |= CS.B[8];
                tResult2 |= CS.B[18];
                tResult3 |= CS.B[16];
            }
            if ((tKey & CS.B[7]) != 0) {
                tResult1 |= CS.B[13];
                tResult2 |= CS.B[17];
                tResult3 |= CS.B[11];
            }
            if ((tKey & CS.B[8]) != 0) {
                tResult1 |= CS.B[18];
                tResult2 |= CS.B[16];
                tResult3 |= CS.B[6];
            }
            if ((tKey & CS.B[9]) != 0) {
                tResult1 |= CS.B[23];
                tResult2 |= CS.B[15];
                tResult3 |= CS.B[1];
            }
            if ((tKey & CS.B[10]) != 0) {
                tResult1 |= CS.B[2];
                tResult2 |= CS.B[14];
                tResult3 |= CS.B[22];
            }
            if ((tKey & CS.B[11]) != 0) {
                tResult1 |= CS.B[7];
                tResult2 |= CS.B[13];
                tResult3 |= CS.B[17];
            }
            if ((tKey & CS.B[12]) != 0) {
                tResult1 |= CS.B[12];
                tResult2 |= CS.B[12];
                tResult3 |= CS.B[12];
            }
            if ((tKey & CS.B[13]) != 0) {
                tResult1 |= CS.B[17];
                tResult2 |= CS.B[11];
                tResult3 |= CS.B[7];
            }
            if ((tKey & CS.B[14]) != 0) {
                tResult1 |= CS.B[22];
                tResult2 |= CS.B[10];
                tResult3 |= CS.B[2];
            }
            if ((tKey & CS.B[15]) != 0) {
                tResult1 |= CS.B[1];
                tResult2 |= CS.B[9];
                tResult3 |= CS.B[23];
            }
            if ((tKey & CS.B[16]) != 0) {
                tResult1 |= CS.B[6];
                tResult2 |= CS.B[8];
                tResult3 |= CS.B[18];
            }
            if ((tKey & CS.B[17]) != 0) {
                tResult1 |= CS.B[11];
                tResult2 |= CS.B[7];
                tResult3 |= CS.B[13];
            }
            if ((tKey & CS.B[18]) != 0) {
                tResult1 |= CS.B[16];
                tResult2 |= CS.B[6];
                tResult3 |= CS.B[8];
            }
            if ((tKey & CS.B[19]) != 0) {
                tResult1 |= CS.B[21];
                tResult2 |= CS.B[5];
                tResult3 |= CS.B[3];
            }
            if ((tKey & CS.B[20]) != 0) {
                tResult1 |= CS.B[0];
                tResult2 |= CS.B[4];
                tResult3 |= CS.B[24];
            }
            if ((tKey & CS.B[21]) != 0) {
                tResult1 |= CS.B[5];
                tResult2 |= CS.B[3];
                tResult3 |= CS.B[19];
            }
            if ((tKey & CS.B[22]) != 0) {
                tResult1 |= CS.B[10];
                tResult2 |= CS.B[2];
                tResult3 |= CS.B[14];
            }
            if ((tKey & CS.B[23]) != 0) {
                tResult1 |= CS.B[15];
                tResult2 |= CS.B[1];
                tResult3 |= CS.B[9];
            }
            if ((tKey & CS.B[24]) != 0) {
                tResult1 |= CS.B[20];
                tResult2 |= CS.B[0];
                tResult3 |= CS.B[4];
            }
            MOLD_RECIPES.put(tResult1, (OreDictPrefix)tEntry.getValue());
            MOLD_RECIPES.put(tResult2, (OreDictPrefix)tEntry.getValue());
            MOLD_RECIPES.put(tResult3, (OreDictPrefix)tEntry.getValue());
        }
        TEMP_MOLD_RECIPES.putAll(MOLD_RECIPES);
        for (Map.Entry tEntry : TEMP_MOLD_RECIPES.entrySet()) {
            tKey = (Integer)tEntry.getKey();
            tResult1 = 0;
            tResult2 = 0;
            if ((tKey & CS.B[0]) != 0) {
                tResult1 |= CS.B[4];
                tResult2 |= CS.B[20];
            }
            if ((tKey & CS.B[1]) != 0) {
                tResult1 |= CS.B[3];
                tResult2 |= CS.B[21];
            }
            if ((tKey & CS.B[2]) != 0) {
                tResult1 |= CS.B[2];
                tResult2 |= CS.B[22];
            }
            if ((tKey & CS.B[3]) != 0) {
                tResult1 |= CS.B[1];
                tResult2 |= CS.B[23];
            }
            if ((tKey & CS.B[4]) != 0) {
                tResult1 |= CS.B[0];
                tResult2 |= CS.B[24];
            }
            if ((tKey & CS.B[5]) != 0) {
                tResult1 |= CS.B[9];
                tResult2 |= CS.B[15];
            }
            if ((tKey & CS.B[6]) != 0) {
                tResult1 |= CS.B[8];
                tResult2 |= CS.B[16];
            }
            if ((tKey & CS.B[7]) != 0) {
                tResult1 |= CS.B[7];
                tResult2 |= CS.B[17];
            }
            if ((tKey & CS.B[8]) != 0) {
                tResult1 |= CS.B[6];
                tResult2 |= CS.B[18];
            }
            if ((tKey & CS.B[9]) != 0) {
                tResult1 |= CS.B[5];
                tResult2 |= CS.B[19];
            }
            if ((tKey & CS.B[10]) != 0) {
                tResult1 |= CS.B[14];
                tResult2 |= CS.B[10];
            }
            if ((tKey & CS.B[11]) != 0) {
                tResult1 |= CS.B[13];
                tResult2 |= CS.B[11];
            }
            if ((tKey & CS.B[12]) != 0) {
                tResult1 |= CS.B[12];
                tResult2 |= CS.B[12];
            }
            if ((tKey & CS.B[13]) != 0) {
                tResult1 |= CS.B[11];
                tResult2 |= CS.B[13];
            }
            if ((tKey & CS.B[14]) != 0) {
                tResult1 |= CS.B[10];
                tResult2 |= CS.B[14];
            }
            if ((tKey & CS.B[15]) != 0) {
                tResult1 |= CS.B[19];
                tResult2 |= CS.B[5];
            }
            if ((tKey & CS.B[16]) != 0) {
                tResult1 |= CS.B[18];
                tResult2 |= CS.B[6];
            }
            if ((tKey & CS.B[17]) != 0) {
                tResult1 |= CS.B[17];
                tResult2 |= CS.B[7];
            }
            if ((tKey & CS.B[18]) != 0) {
                tResult1 |= CS.B[16];
                tResult2 |= CS.B[8];
            }
            if ((tKey & CS.B[19]) != 0) {
                tResult1 |= CS.B[15];
                tResult2 |= CS.B[9];
            }
            if ((tKey & CS.B[20]) != 0) {
                tResult1 |= CS.B[24];
                tResult2 |= CS.B[0];
            }
            if ((tKey & CS.B[21]) != 0) {
                tResult1 |= CS.B[23];
                tResult2 |= CS.B[1];
            }
            if ((tKey & CS.B[22]) != 0) {
                tResult1 |= CS.B[22];
                tResult2 |= CS.B[2];
            }
            if ((tKey & CS.B[23]) != 0) {
                tResult1 |= CS.B[21];
                tResult2 |= CS.B[3];
            }
            if ((tKey & CS.B[24]) != 0) {
                tResult1 |= CS.B[20];
                tResult2 |= CS.B[4];
            }
            MOLD_RECIPES.put(tResult1, (OreDictPrefix)tEntry.getValue());
            MOLD_RECIPES.put(tResult2, (OreDictPrefix)tEntry.getValue());
        }
    }
}

