/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.render.IconContainerDefault;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityJuicer
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityConnectedTank,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected short mDisplay = 0;
    protected short oDisplay = (short)-1;
    protected Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sJuicerRecipes;
    protected Recipe mLastRecipe = null;
    protected FluidTank[] mTanks = CS.ZL_FLUIDTANK;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/bottom");
    public static IIconContainer sTextureMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/middletop");
    public static IIconContainer sTextureMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/middleside");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/bottom");
    public static IIconContainer sOverlayMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/middletop");
    public static IIconContainer sOverlayMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/middleside");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        int tCapacity = 1000;
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = UT.Code.bindInt(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanks = new FluidTank[this.mRecipes.mOutputFluidCount];
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i] = new FluidTank(tCapacity).readFromNBT(aNBT.func_74775_l("gt.tank." + i));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        for (int i = 0; i < this.mTanks.length; ++i) {
            if (this.mTanks[i] == null) continue;
            aNBT.func_74782_a("gt.tank." + i, (NBTBase)this.mTanks[i].writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mixingbowl.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            this.updateInventory();
            for (FluidTank tTank : this.mTanks) {
                if (tTank.drain(1000, true) == CS.NF) continue;
                return 10000L;
            }
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mDisplay = 0;
            for (FluidTank tTank : this.mTanks) {
                if (tTank.getFluidAmount() <= 0) continue;
                this.mDisplay = (short)(tTank.getFluid().getFluidID() + 1);
                break;
            }
        }
    }

    protected boolean canOutput(Recipe aRecipe) {
        for (int i = 0; i < this.mTanks.length && i < aRecipe.mFluidOutputs.length; ++i) {
            if (this.mTanks[i].getFluidAmount() == 0 || !aRecipe.mNeedsEmptyOutput && (aRecipe.mFluidOutputs[i] == null || UT.Fluids.equal(this.mTanks[i].getFluid(), aRecipe.mFluidOutputs[i], false) && UT.Fluids.temperature(aRecipe.mFluidOutputs[i]) < this.mMaterial.mMeltingPoint - 100L && aRecipe.mFluidOutputs[i].getFluid().getDensity(aRecipe.mFluidOutputs[i]) >= 0 && this.mTanks[i].getFluidAmount() <= Math.max(999, aRecipe.mFluidOutputs[i].amount))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide()) {
            float[] tCoords2;
            ItemStack aStack = aPlayer.func_71045_bC();
            if (CS.SIDES_TOP[aSide] && (tCoords2 = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PIXELS_POS[4] && tCoords2[1] <= CS.PIXELS_POS[4]) {
                return true;
            }
            if (!UT.Entities.isPlayer(aPlayer)) {
                return true;
            }
            Recipe tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, false, CS.V[1], CS.NI, CS.ZL_FLUIDSTACK, aStack);
            if (tRecipe != null) {
                if (tRecipe.mCanBeBuffered) {
                    this.mLastRecipe = tRecipe;
                }
                if (this.canOutput(tRecipe) && tRecipe.isRecipeInputEqual(true, false, CS.ZL_FLUIDSTACK, aStack)) {
                    for (ItemStack tStack : tRecipe.getOutputs(this.field_145850_b.field_73012_v)) {
                        if (!UT.Stacks.valid(tStack) || UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) continue;
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                    }
                    FluidStack[] tOutputFluids = tRecipe.getFluidOutputs(this.field_145850_b.field_73012_v);
                    for (int i = 0; i < this.mTanks.length && i < tOutputFluids.length; ++i) {
                        this.mTanks[i].fill(tOutputFluids[i], true);
                    }
                    aPlayer.func_71020_j((float)(tRecipe.mEUt * tRecipe.mDuration) / 10000.0f);
                    UT.Sounds.send(this.field_145850_b, "mob.slime.big", 1.0f, 1.0f, this.getCoords());
                    return true;
                }
            }
            ItemStack tStack = null;
            if (aStack != null) {
                for (FluidTank tTank : this.mTanks) {
                    tStack = UT.Fluids.fillFluidContainer(tTank.getFluid(), UT.Stacks.amount(1L, aStack), true, true, true);
                    if (tStack == null) continue;
                    --aStack.field_77994_a;
                    if (!UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                    }
                    if (tTank.getFluidAmount() == 0) {
                        tTank.setFluid(null);
                    }
                    return true;
                }
            }
        } else if (CS.SIDES_TOP[aSide] && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PIXELS_POS[4] && tCoords[1] <= CS.PIXELS_POS[4]) {
            this.mRecipes.openNEI();
            return true;
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplay != this.oDisplay;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplay = this.mDisplay;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        if (aData.length > 1) {
            this.mDisplay = UT.Code.combine(aData[0], aData[1]);
        }
        if (aData.length > 4) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanks.length; ++i) {
                if (this.mTanks[i].getFluidAmount() == 0) continue;
                return this.mTanks[i];
            }
        } else {
            for (int i = 0; i < this.mTanks.length; ++i) {
                if (!UT.Fluids.equal(aFluidToDrain, this.mTanks[i].getFluid(), false)) continue;
                return this.mTanks[i];
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 8;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[12], CS.PIXELS_NEG[2]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[12]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[2]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_NEG[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[2]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[15], CS.PIXELS_NEG[2]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[13], CS.PIXELS_NEG[2]);
                return true;
            }
            case 6: {
                aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_POS[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[9], CS.PIXELS_NEG[6]);
                return true;
            }
            case 7: {
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[12] + 0.001f, CS.PIXELS_NEG[12]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return 5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 2: {
                return 4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 1: {
                return 3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 3: {
                return 2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 4: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa), BlockTextureDefault.get(sOverlayBottom)) : null);
            }
            case 5: {
                if (this.mDisplay <= 0 || 1 != aSide) {
                    return null;
                }
                Fluid tFluid = UT.Fluids.fluid(this.mDisplay - 1);
                if (tFluid == null) {
                    return BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false);
                }
                return BlockTextureDefault.get((IIconContainer)new IconContainerDefault(tFluid.getIcon()), tFluid.getColor());
            }
            case 6: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleTop, this.mRGBa), BlockTextureDefault.get(sOverlayMiddleTop)) : (0 == aSide ? null : BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleSide, this.mRGBa), BlockTextureDefault.get(sOverlayMiddleSide)));
            }
            case 7: {
                return 1 == aSide ? BI.nei() : null;
            }
        }
        return null;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List aList, Entity aEntity) {
        AxisAlignedBB tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[12]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
        if (aAABB.func_72326_a(tBox)) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[12]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[12]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[12])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[15]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2])))) {
            aList.add(tBox);
        }
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[12]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[12], CS.PIXELS_NEG[2]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_POS[12] : CS.PIXELS_POS[2];
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        return 0;
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (aFluid == CS.NF) {
            return 0;
        }
        for (FluidTank tTank : this.mTanks) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid) || tTank.getFluidAmount() < (aOnlyRemoveIfItCanRemoveAllAtOnce ? aFluid.amount : 1)) continue;
            return tTank.drain((int)aFluid.amount, (boolean)true).amount;
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        if (aFluid == CS.NF) {
            return 0L;
        }
        long rAmount = 0L;
        for (FluidTank tTank : this.mTanks) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid)) continue;
            rAmount += (long)tTank.getFluidAmount();
        }
        return rAmount;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.juicer";
    }
}

