/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityGrindStone
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    protected byte mClickCount = 0;
    protected byte mStone = 0;
    protected byte oStone = 0;
    protected Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sSharpeningRecipes;
    protected Recipe mLastRecipe = null;
    public static IIconContainer sTextureLegs = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/colored/legs");
    public static IIconContainer sTextureAxle = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/colored/axle");
    public static IIconContainer sTextureStone = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/colored/stone");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/colored/bottom");
    public static IIconContainer sOverlayLegs = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/overlay/legs");
    public static IIconContainer sOverlayAxle = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/overlay/axle");
    public static IIconContainer sOverlayStone = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/overlay/stone");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/grindstone/overlay/bottom");
    private ITexture mTextureLegs;
    private ITexture mTextureAxle;
    private ITexture mTextureStone;
    private ITexture mTextureBottom;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mStone = aNBT.func_74771_c("gt.state");
        }
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.state", this.mStone);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.func_74774_a("gt.state", this.mStone);
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.grindstone.init"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.grindstone.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.any.but.sides") + ")");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing && !CS.SIDES_TOP[aSide]) {
            return false;
        }
        if (this.isServerSide()) {
            if (CS.SIDES_TOP[aSide]) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                float f = tCoords[0];
                int n = CS.SIDES_AXIS_Z[this.mFacing] ? 8 : 4;
                if (f <= CS.PIXELS_POS[n]) {
                    float f2 = tCoords[1];
                    int n2 = CS.SIDES_AXIS_X[this.mFacing] ? 8 : 4;
                    if (f2 <= CS.PIXELS_POS[n2]) {
                        return true;
                    }
                }
            }
            if (CS.SIDES_VERTICAL[aSide] || CS.ALONG_AXIS[this.mFacing][aSide]) {
                ItemStack aStack = aPlayer.func_71045_bC();
                if (aStack == null || this.mRecipes == null || !UT.Entities.isPlayer(aPlayer)) {
                    this.mClickCount = 0;
                } else if (this.mStone <= 0) {
                    if (UT.Stacks.equal(UT.Stacks.make(Blocks.field_150322_A, 1L, 32767L), aStack, true) && aStack.field_77994_a > 0) {
                        this.mClickCount = 0;
                        this.mStone = (byte)4;
                        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                            --aStack.field_77994_a;
                        }
                    }
                } else if (UT.Entities.hasInfiniteItems(aPlayer) || (this.mClickCount = (byte)(this.mClickCount + 1)) >= 20) {
                    this.mClickCount = 0;
                    Recipe tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, false, CS.V[1], null, CS.ZL_FLUIDSTACK, aStack);
                    if (tRecipe != null) {
                        this.mLastRecipe = tRecipe;
                        if (tRecipe.isRecipeInputEqual(true, false, null, aStack)) {
                            for (ItemStack tStack : tRecipe.getOutputs(this.field_145850_b.field_73012_v)) {
                                if (!UT.Stacks.valid(tStack) || UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, false)) continue;
                                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                            }
                            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                                this.mStone = (byte)(this.mStone - 1);
                            }
                            aPlayer.func_71020_j((float)(tRecipe.mEUt * tRecipe.mDuration) / 10000.0f);
                        }
                    }
                }
            }
        } else {
            if (CS.SIDES_TOP[aSide] && this.mStone != 0) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                float f = tCoords[0];
                int n = CS.SIDES_AXIS_Z[this.mFacing] ? 8 : 4;
                if (f <= CS.PIXELS_POS[n]) {
                    float f3 = tCoords[1];
                    int n3 = CS.SIDES_AXIS_X[this.mFacing] ? 8 : 4;
                    if (f3 <= CS.PIXELS_POS[n3]) {
                        this.mRecipes.openNEI();
                        return true;
                    }
                }
            }
            if ((CS.SIDES_VERTICAL[aSide] || CS.ALONG_AXIS[this.mFacing][aSide]) && this.mStone != 0) {
                UT.Sounds.play("dig.sand", 5, 1.0f, 1.0f, this.getCoords());
            }
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mStone != this.oStone;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oStone = this.mStone;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mStone = aData;
    }

    @Override
    public byte getVisualData() {
        return this.mStone;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PIXELS_POS[3], CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 8 : 4], CS.PIXELS_NEG[1] + 1.0E-4f, CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 8 : 4]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[0], CS.PIXELS_POS[5], CS.SIDES_AXIS_Z[this.mFacing] ? CS.PIXELS_POS[6] : CS.PIXELS_NEG[5], CS.PIXELS_NEG[5], CS.SIDES_AXIS_X[this.mFacing] ? CS.PIXELS_POS[6] : CS.PIXELS_NEG[5]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.SIDES_AXIS_Z[this.mFacing] ? CS.PIXELS_NEG[6] : CS.PIXELS_POS[5], CS.PIXELS_POS[0], CS.SIDES_AXIS_X[this.mFacing] ? CS.PIXELS_NEG[6] : CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[5]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 3], CS.PIXELS_POS[8], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 3], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 3], CS.PIXELS_NEG[6], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 3]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PIXELS_POS[3], CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 6 : 2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 6 : 2]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureLegs = BlockTextureMulti.get(BlockTextureDefault.get(sTextureLegs, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayLegs));
            this.mTextureAxle = BlockTextureMulti.get(BlockTextureDefault.get(sTextureAxle, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayAxle));
            this.mTextureStone = BlockTextureMulti.get(BlockTextureDefault.get(sTextureStone, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayStone));
            this.mTextureBottom = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayBottom));
        }
        if (aRenderPass == 0) {
            return this.mStone != 0 && CS.SIDES_TOP[aSide] ? BI.nei() : null;
        }
        if (aRenderPass == 1) {
            return this.mTextureBottom;
        }
        if (aRenderPass == 4) {
            return this.mTextureAxle;
        }
        if (aRenderPass == 5) {
            return this.mStone != 0 ? this.mTextureStone : null;
        }
        return this.mTextureLegs;
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[2]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[2]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[2]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[2]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_BOTTOM[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_BOTTOM[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.sharpener.grindstone";
    }
}

