/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import gregtech.tileentity.tools.MultiTileEntityBathingPot;
import gregtech.tileentity.tools.MultiTileEntityMixingBowl;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityFluidTap
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public boolean mAcidProof = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/tap/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            FluidStack tFluid;
            DelegatorTileEntity<IFluidHandler> tDelegator = this.getAdjacentTank(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityTapAccessible && !UT.Fluids.gas(tFluid = ((IFluidHandler)tDelegator.mTileEntity).drain(tDelegator.getForgeSideOfTileEntity(), Integer.MAX_VALUE, false), true) && tFluid.amount > 0 && (this.mAcidProof || !UT.Fluids.acid(tFluid))) {
                ItemStack aStack = aPlayer.func_71045_bC();
                if (aStack == null) {
                    DelegatorTileEntity<IFluidHandler> tDelegator2 = this.getAdjacentTank((byte)0);
                    if (tDelegator2.mTileEntity instanceof MultiTileEntityBathingPot || tDelegator2.mTileEntity instanceof MultiTileEntityMixingBowl) {
                        OreDictMaterialStack tMaterial = OreDictMaterial.FLUID_MAP.get(tFluid.getFluid().getName());
                        tFluid = tFluid.copy();
                        tFluid.amount = Math.min(tFluid.amount, UT.Fluids.lava(tFluid) ? 1000 : (!UT.Fluids.water(tFluid) && tMaterial != null && tMaterial.mAmount > 0L ? UT.Code.bindInt(tMaterial.mAmount) : 250));
                        if (((IFluidHandler)tDelegator.mTileEntity).drain(tDelegator.getForgeSideOfTileEntity(), ((IFluidHandler)tDelegator2.mTileEntity).fill(tDelegator2.getForgeSideOfTileEntity(), tFluid, true), true) != null) {
                            UT.Sounds.send(this.field_145850_b, CS.SFX.IC_SPRAY, 1.0f, 2.0f, this.getCoords());
                            UT.Sounds.send(this.field_145850_b, "liquid.water", 1.0f, 1.0f, this.getCoords());
                            return true;
                        }
                    }
                } else {
                    FluidStack tNewFluid = tFluid.copy();
                    ItemStack tStack = UT.Fluids.fillFluidContainer(tNewFluid, UT.Stacks.amount(1L, aStack), true, true, true);
                    if (tFluid.amount > tNewFluid.amount && ((IFluidHandler)tDelegator.mTileEntity).drain(tDelegator.getForgeSideOfTileEntity(), tFluid.amount - tNewFluid.amount, true) != null) {
                        UT.Sounds.send(this.field_145850_b, CS.SFX.IC_SPRAY, 1.0f, 2.0f, this.getCoords());
                        --aStack.field_77994_a;
                        if (tStack != null && !UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                        }
                        return true;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[2], CS.PIXELS_NEG[6], CS.PIXELS_NEG[9], CS.PIXELS_NEG[12]);
                        return true;
                    }
                    default: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_POS[12], CS.PIXELS_NEG[6], CS.PIXELS_NEG[9], CS.PIXELS_NEG[2]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_NEG[12], CS.PIXELS_NEG[9], CS.PIXELS_NEG[6]);
                        return true;
                    }
                    case 5: 
                }
                aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[6], CS.PIXELS_POS[6], CS.PIXELS_NEG[2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[6]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[4], CS.PIXELS_POS[0], CS.PIXELS_NEG[7], CS.PIXELS_NEG[10], CS.PIXELS_NEG[12]);
                        return true;
                    }
                    default: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[4], CS.PIXELS_POS[12], CS.PIXELS_NEG[7], CS.PIXELS_NEG[10], CS.PIXELS_NEG[0]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[4], CS.PIXELS_POS[7], CS.PIXELS_NEG[12], CS.PIXELS_NEG[10], CS.PIXELS_NEG[7]);
                        return true;
                    }
                    case 5: 
                }
                aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[4], CS.PIXELS_POS[7], CS.PIXELS_NEG[0], CS.PIXELS_NEG[10], CS.PIXELS_NEG[7]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[3], CS.PIXELS_POS[4], CS.PIXELS_NEG[7], CS.PIXELS_NEG[10], CS.PIXELS_NEG[10]);
                        return true;
                    }
                    default: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[3], CS.PIXELS_POS[10], CS.PIXELS_NEG[7], CS.PIXELS_NEG[10], CS.PIXELS_NEG[4]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[3], CS.PIXELS_POS[7], CS.PIXELS_NEG[10], CS.PIXELS_NEG[10], CS.PIXELS_NEG[7]);
                        return true;
                    }
                    case 5: 
                }
                aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[3], CS.PIXELS_POS[7], CS.PIXELS_NEG[4], CS.PIXELS_NEG[10], CS.PIXELS_NEG[7]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 1 && (aSide == this.mFacing ? !aShouldSideBeRendered[aSide] : aSide == CS.OPPOSITES[this.mFacing]) ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]));
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[6]), (double)((float)this.field_145848_d + CS.PIXELS_POS[3]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[6]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[9]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[10]));
            }
            default: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[6]), (double)((float)this.field_145848_d + CS.PIXELS_POS[3]), (double)((float)this.field_145849_e + CS.PIXELS_POS[10]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[6]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[9]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[3]), (double)((float)this.field_145849_e + CS.PIXELS_POS[6]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[10]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[9]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[6]));
            }
            case 5: 
        }
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[10]), (double)((float)this.field_145848_d + CS.PIXELS_POS[3]), (double)((float)this.field_145849_e + CS.PIXELS_POS[6]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[9]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[6]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[3], CS.PIXELS_POS[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[9], CS.PIXELS_NEG[10]);
                break;
            }
            default: {
                aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[3], CS.PIXELS_POS[10], CS.PIXELS_NEG[6], CS.PIXELS_NEG[9], CS.PIXELS_NEG[0]);
                break;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[3], CS.PIXELS_POS[6], CS.PIXELS_NEG[10], CS.PIXELS_NEG[9], CS.PIXELS_NEG[6]);
                break;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[3], CS.PIXELS_POS[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[9], CS.PIXELS_NEG[6]);
            }
        }
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.tap";
    }
}

