/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityFluidFunnel
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public boolean mAcidProof = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/funnel/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/funnel/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/funnel/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/funnel/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/funnel/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/funnel/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (this.isServerSide() && (aStack = aPlayer.func_71045_bC()) != null) {
            ItemStack tStack = UT.Stacks.container(UT.Stacks.amount(1L, aStack), true);
            FluidStack tFluid = UT.Fluids.getFluidForFilledItem(UT.Stacks.amount(1L, aStack), true);
            if (!(UT.Fluids.gas(tFluid, true) || tFluid.amount <= 0 || !this.mAcidProof && UT.Fluids.acid(tFluid))) {
                DelegatorTileEntity<IFluidHandler> tDelegator = this.getAdjacentTank(this.mFacing);
                if (tDelegator.mTileEntity instanceof ITileEntityFunnelAccessible && ((IFluidHandler)tDelegator.mTileEntity).fill(tDelegator.getForgeSideOfTileEntity(), tFluid, false) == tFluid.amount && ((IFluidHandler)tDelegator.mTileEntity).fill(tDelegator.getForgeSideOfTileEntity(), tFluid, true) > 0) {
                    UT.Sounds.send(this.field_145850_b, "liquid.water", 1.0f, 1.0f, this.getCoords());
                    --aStack.field_77994_a;
                    if (tStack != null && !UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                    }
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[9], CS.PIXELS_POS[0], CS.PIXELS_NEG[5], CS.PIXELS_NEG[6], CS.PIXELS_NEG[10]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[9], CS.PIXELS_POS[10], CS.PIXELS_NEG[5], CS.PIXELS_NEG[6], CS.PIXELS_NEG[0]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[9], CS.PIXELS_POS[5], CS.PIXELS_NEG[10], CS.PIXELS_NEG[6], CS.PIXELS_NEG[5]);
                        return true;
                    }
                    case 5: {
                        aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[9], CS.PIXELS_POS[5], CS.PIXELS_NEG[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[5]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[2], CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[13], CS.PIXELS_NEG[5]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[8], CS.PIXELS_POS[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[7], CS.PIXELS_NEG[12]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[8], CS.PIXELS_POS[12], CS.PIXELS_NEG[6], CS.PIXELS_NEG[7], CS.PIXELS_NEG[0]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[8], CS.PIXELS_POS[6], CS.PIXELS_NEG[12], CS.PIXELS_NEG[7], CS.PIXELS_NEG[6]);
                        return true;
                    }
                    case 5: {
                        aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[8], CS.PIXELS_POS[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[7], CS.PIXELS_NEG[6]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[1], CS.PIXELS_POS[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[14], CS.PIXELS_NEG[6]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[7], CS.PIXELS_POS[0], CS.PIXELS_NEG[7], CS.PIXELS_NEG[8], CS.PIXELS_NEG[14]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[7], CS.PIXELS_POS[14], CS.PIXELS_NEG[7], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[7], CS.PIXELS_POS[7], CS.PIXELS_NEG[14], CS.PIXELS_NEG[8], CS.PIXELS_NEG[7]);
                        return true;
                    }
                    case 5: {
                        aBlock.func_149676_a(CS.PIXELS_POS[14], CS.PIXELS_POS[7], CS.PIXELS_POS[7], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[7]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PIXELS_POS[7], CS.PIXELS_POS[0], CS.PIXELS_POS[7], CS.PIXELS_NEG[7], CS.PIXELS_NEG[15], CS.PIXELS_NEG[7]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass > 0 && CS.SIDES_TOP[aSide] || !aShouldSideBeRendered[aSide] && (CS.SIDES_HORIZONTAL[this.mFacing] || aRenderPass == 2 && CS.SIDES_BOTTOM[aSide]) ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]));
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[5]), (double)((float)this.field_145848_d + CS.PIXELS_POS[7]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[6]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[10]));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[5]), (double)((float)this.field_145848_d + CS.PIXELS_POS[7]), (double)((float)this.field_145849_e + CS.PIXELS_POS[10]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[6]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[7]), (double)((float)this.field_145849_e + CS.PIXELS_POS[5]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[10]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[6]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[5]));
            }
            case 5: {
                return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[10]), (double)((float)this.field_145848_d + CS.PIXELS_POS[7]), (double)((float)this.field_145849_e + CS.PIXELS_POS[5]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[6]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[5]));
            }
        }
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[5]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[5]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[13]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[5]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[7], CS.PIXELS_POS[0], CS.PIXELS_NEG[5], CS.PIXELS_NEG[6], CS.PIXELS_NEG[10]);
                break;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[7], CS.PIXELS_POS[10], CS.PIXELS_NEG[5], CS.PIXELS_NEG[6], CS.PIXELS_NEG[0]);
                break;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[7], CS.PIXELS_POS[5], CS.PIXELS_NEG[10], CS.PIXELS_NEG[6], CS.PIXELS_NEG[5]);
                break;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[10], CS.PIXELS_POS[7], CS.PIXELS_POS[5], CS.PIXELS_NEG[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[5]);
                break;
            }
            default: {
                aBlock.func_149676_a(CS.PIXELS_POS[5], CS.PIXELS_POS[0], CS.PIXELS_POS[5], CS.PIXELS_NEG[5], CS.PIXELS_NEG[13], CS.PIXELS_NEG[5]);
            }
        }
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_BOTTOM_HORIZONTAL;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.funnel";
    }
}

