/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityDustFunnel
extends TileEntityBase07Paintable
implements ITileEntityAdjacentInventoryUpdatable,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataShort {
    public static final OreDictPrefix[] DUST_TYPES = new OreDictPrefix[]{OP.blockDust, OP.dust, OP.dustSmall, OP.dustTiny, OP.dustDiv72};
    protected byte mMode = 0;
    protected short mDust = 0;
    protected short oDust = (short)-1;
    protected OreDictMaterialStack mContent = null;
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/top");
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/sides");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/bottom");
    public static IIconContainer sTextureHole = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/colored/hole");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/top");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/sides");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/bottom");
    public static IIconContainer sOverlayHole = new Textures.BlockIcons.CustomIcon("machines/tools/dust_funnel/overlay/hole");
    private ITexture mTextureSides;
    private ITexture mTextureBottom;
    private ITexture mTextureInput;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        this.mContent = OreDictMaterialStack.load("gt.materials", aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.mode", this.mMode);
        if (this.mContent != null) {
            this.mContent.save("gt.materials", aNBT);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.func_74774_a("gt.mode", this.mMode);
        if (this.mContent != null) {
            this.mContent.save("gt.materials", aNBT);
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.dustfunnel"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            ItemStack tStack;
            OreDictItemData tData;
            boolean temp = false;
            if ((this.mContent == null || this.mContent.mAmount < MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount) && OM.prefixcontainsmaterialmatches(tData = OM.anydata(this.slot(0)), this.mContent == null || this.mContent.mAmount == 0L ? null : this.mContent.mMaterial, TD.Prefix.DUST_BASED)) {
                this.mContent = OM.stack(tData.mMaterial.mMaterial, tData.mMaterial.mAmount + (this.mContent == null ? 0L : this.mContent.mAmount));
                this.func_70298_a(0, 1);
            }
            short s = this.mDust = this.mContent != null && (this.mContent.mAmount > 0L || this.slot(1) != null) ? this.mContent.mMaterial.mID : (short)0;
            if (this.mContent != null && this.slot(1) == null && this.mContent.mAmount >= MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount && (tStack = DUST_TYPES[this.mMode].mat(this.mContent.mMaterial, 1L)) != null) {
                this.slot(1, tStack);
                this.mContent.mAmount -= MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mAmount;
                temp = true;
            }
            if (temp || this.mInventoryChanged || aTimer % 100L == 0L) {
                DelegatorTileEntity<IInventory> tTileEntity;
                if (this.slotHas(1)) {
                    tTileEntity = this.getAdjacentInventory((byte)0);
                    UT.Inventories.moveOneItemStack(this, tTileEntity, (byte)0, tTileEntity.mSideOfTileEntity, null, false, 64, 1, 64, 1);
                }
                if (!this.slotHas(0)) {
                    tTileEntity = this.getAdjacentInventory((byte)1);
                    UT.Inventories.moveOneItemStack(tTileEntity.mTileEntity, this, tTileEntity.mSideOfTileEntity, (byte)1, null, false, 64, 1, 64, 1);
                }
            }
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP[aSide] && this.slot(0) == null) {
            UT.Inventories.moveFromSlotToSlot((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, 0, null, false, 64, 1, 64, 1);
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("monkeywrench")) {
            this.mMode = (byte)((this.mMode + 1) % DUST_TYPES.length);
            if (aChatReturn != null) {
                aChatReturn.add("Outputs in the Size of " + MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mNameCategory);
            }
            this.updateClientData();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Outputs in the Size of " + MultiTileEntityDustFunnel.DUST_TYPES[this.mMode].mNameCategory);
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDust != this.oDust;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDust = this.mDust;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDust, 0), UT.Code.toByteS(this.mDust, 1), this.mMode, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketShort(aSendAll, this.mDust);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDust = UT.Code.combine(aData[0], aData[1]);
        this.mMode = aData[2];
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4]), UT.Code.unsignB(aData[5])});
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDust = aData;
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[8], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[2 + this.mMode], CS.PIXELS_POS[0], CS.PIXELS_POS[2 + this.mMode], CS.PIXELS_NEG[2 + this.mMode], CS.PIXELS_NEG[8], CS.PIXELS_NEG[2 + this.mMode]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[2], CS.PIXELS_POS[8], CS.PIXELS_POS[2]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[2], CS.PIXELS_POS[2], CS.PIXELS_POS[8], CS.PIXELS_NEG[0]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_NEG[2], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_POS[8], CS.PIXELS_POS[2]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_NEG[2], CS.PIXELS_POS[0], CS.PIXELS_NEG[2], CS.PIXELS_NEG[0], CS.PIXELS_POS[8], CS.PIXELS_NEG[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureSides = BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlaySides));
            this.mTextureBottom = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayBottom));
            if (this.mDust == 0) {
                this.mTextureInput = BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayTop), BlockTextureDefault.get(sTextureHole, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole));
            } else if (UT.Code.exists(this.mDust, OreDictMaterial.MATERIAL_ARRAY)) {
                OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDust];
                this.mTextureInput = BlockTextureMulti.get(BlockTextureDefault.get(tMaterial, OP.blockDust.mIconIndexBlock, tMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sTextureHole, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole));
            } else {
                this.mTextureInput = BlockTextureMulti.get(BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_64, false), BlockTextureDefault.get(sTextureHole, UT.Code.getRGBaArray(this.mRGBa), false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole));
            }
        }
        return CS.SIDES_TOP[aSide] ? (aRenderPass == 0 ? this.mTextureInput : null) : (CS.SIDES_BOTTOM[aSide] ? this.mTextureBottom : this.mTextureSides);
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_POS[16] : (CS.SIDES_BOTTOM[aSide] ? CS.PIXELS_POS[12 - 2 * this.mMode] : 0.0f);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_POS[12] : CS.PIXELS_POS[12 - 2 * this.mMode];
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_HORIZONTAL[aSide] ? CS.PIXELS_POS[2 + this.mMode] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.SIDES_VERTICAL[aSide]) {
            this.updateInventory();
        }
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot == 0 && this.slot(0) == null && CS.SIDES_TOP_HORIZONTAL[aSide]) {
            OreDictItemData tData = OM.anydata(aStack);
            return OM.prefixcontains(tData, TD.Prefix.DUST_BASED) && (this.mContent == null || this.mContent.mAmount == 0L || this.mContent.mMaterial == tData.mMaterial.mMaterial) && DUST_TYPES[this.mMode].mat(tData.mMaterial.mMaterial, 1L) != null;
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 1;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.funnel.dust";
    }
}

