/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.render.IconContainerDefault;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityBathingPot
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityConnectedTank,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected short mDisplay = 0;
    protected short oDisplay = (short)-1;
    protected Recipe.RecipeMap mRecipes = Recipe.RecipeMap.sMixerRecipes;
    protected Recipe mLastRecipe = null;
    protected FluidTank[] mTanksInput = CS.ZL_FLUIDTANK;
    protected FluidTank[] mTanksOutput = CS.ZL_FLUIDTANK;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/bottom");
    public static IIconContainer sTextureTableBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/tablebottom");
    public static IIconContainer sTextureTableSide = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/tableside");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/bottom");
    public static IIconContainer sOverlayTableBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/tablebottom");
    public static IIconContainer sOverlayTableSide = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/tableside");
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        int tCapacity = Math.max(1000, this.mRecipes.mMaxFluidInputSize * 2);
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = UT.Code.bindInt(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanksInput = new FluidTank[this.mRecipes.mInputFluidCount];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i] = new FluidTank(tCapacity).readFromNBT(aNBT.func_74775_l("gt.tank.in." + i));
        }
        this.mTanksOutput = new FluidTank[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i] = new FluidTank(tCapacity).readFromNBT(aNBT.func_74775_l("gt.tank.out." + i));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (this.mTanksInput[i] == null) continue;
            aNBT.func_74782_a("gt.tank.in." + i, (NBTBase)this.mTanksInput[i].writeToNBT(new NBTTagCompound()));
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            if (this.mTanksOutput[i] == null) continue;
            aNBT.func_74782_a("gt.tank.out." + i, (NBTBase)this.mTanksOutput[i].writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.bathingsink.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            this.updateInventory();
            for (FluidTank tTank : this.mTanksOutput) {
                if (tTank.drain(1000, true) == CS.NF) continue;
                return 10000L;
            }
            for (FluidTank tTank : this.mTanksInput) {
                if (tTank.drain(1000, true) == CS.NF) continue;
                return 10000L;
            }
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            boolean tBreak = false;
            this.mDisplay = 0;
            for (FluidTank tTank : this.mTanksOutput) {
                if (tTank.getFluidAmount() <= 0) continue;
                this.mDisplay = (short)(-2 - tTank.getFluid().getFluidID());
                tBreak = true;
                break;
            }
            if (!tBreak) {
                for (FluidTank tTank : this.mTanksInput) {
                    if (tTank.getFluidAmount() <= 0) continue;
                    this.mDisplay = (short)(-2 - tTank.getFluid().getFluidID());
                    tBreak = true;
                    break;
                }
                if (!tBreak) {
                    for (int i = 0; i < 7; ++i) {
                        ItemStack tStack = this.slot(6 - i);
                        if (!UT.Stacks.valid(tStack)) continue;
                        OreDictItemData tData = OM.data_(tStack);
                        this.mDisplay = tData == null || tData.mMaterial == null ? (short)-1 : tData.mMaterial.mMaterial.mID;
                        tBreak = true;
                        break;
                    }
                }
            }
        }
    }

    protected boolean canOutput(Recipe aRecipe) {
        int i;
        for (i = 0; i < 6; ++i) {
            if (this.slot(i + 6) == null || !aRecipe.mNeedsEmptyOutput && (aRecipe.mOutputs.length <= 0 || aRecipe.mOutputs[i] == null || UT.Stacks.equal(this.slot(i + 6), aRecipe.mOutputs[i], false) && this.slot((int)(i + 6)).field_77994_a + aRecipe.mOutputs[i].field_77994_a <= this.slot(i + 6).func_77976_d())) continue;
            return false;
        }
        for (i = 0; i < this.mTanksOutput.length && i < aRecipe.mFluidOutputs.length; ++i) {
            if (this.mTanksOutput[i].getFluidAmount() == 0 || !aRecipe.mNeedsEmptyOutput && (aRecipe.mFluidOutputs[i] == null || UT.Fluids.equal(this.mTanksOutput[i].getFluid(), aRecipe.mFluidOutputs[i], false) && UT.Fluids.temperature(aRecipe.mFluidOutputs[i]) < this.mMaterial.mMeltingPoint - 100L && aRecipe.mFluidOutputs[i].getFluid().getDensity(aRecipe.mFluidOutputs[i]) >= 0 && this.mTanksOutput[i].getFluidAmount() <= Math.max(999, aRecipe.mFluidOutputs[i].amount))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            if (CS.SIDES_TOP[aSide]) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                if (tCoords[0] <= CS.PIXELS_POS[2] && tCoords[1] <= CS.PIXELS_POS[2]) {
                    return true;
                }
                if (!UT.Entities.isPlayer(aPlayer)) {
                    return true;
                }
                ItemStack[] tInputItems = new ItemStack[]{this.slot(0), this.slot(1), this.slot(2), this.slot(3), this.slot(4), this.slot(5)};
                FluidStack[] tInputFluids = new FluidStack[this.mTanksInput.length];
                for (int i = 0; i < this.mTanksInput.length; ++i) {
                    tInputFluids[i] = this.mTanksInput[i].getFluid();
                }
                Recipe tRecipe = this.mRecipes.findRecipe(this, this.mLastRecipe, false, CS.V[1], CS.NI, tInputFluids, tInputItems);
                if (tRecipe != null) {
                    if (tRecipe.mCanBeBuffered) {
                        this.mLastRecipe = tRecipe;
                    }
                    if (this.canOutput(tRecipe) && tRecipe.isRecipeInputEqual(true, false, tInputFluids, tInputItems)) {
                        int i;
                        ItemStack[] tOutputItems = tRecipe.getOutputs(this.field_145850_b.field_73012_v);
                        FluidStack[] tOutputFluids = tRecipe.getFluidOutputs(this.field_145850_b.field_73012_v);
                        for (i = 0; i < this.mRecipes.mOutputItemsCount && i < tOutputItems.length; ++i) {
                            this.addStackToSlot(i + 6, tOutputItems[i]);
                        }
                        for (i = 0; i < this.mTanksOutput.length && i < tOutputFluids.length; ++i) {
                            this.mTanksOutput[i].fill(tOutputFluids[i], true);
                        }
                        aPlayer.func_71020_j((float)(tRecipe.mEUt * tRecipe.mDuration) / 10000.0f);
                        this.removeAllDroppableNullStacks();
                        for (i = 0; i < this.mTanksInput.length; ++i) {
                            if (this.mTanksInput[i].getFluidAmount() != 0) continue;
                            this.mTanksInput[i].setFluid(null);
                        }
                        return true;
                    }
                }
            }
            for (int i = 6; i < 12; ++i) {
                if (!UT.Inventories.addStackToPlayerInventory(aPlayer, this.slot(i), true)) continue;
                this.slot(i, null);
                return true;
            }
            ItemStack aStack = aPlayer.func_71045_bC();
            ItemStack tStack = UT.Stacks.container(UT.Stacks.amount(1L, aStack), true);
            FluidStack tFluid = UT.Fluids.getFluidForFilledItem(UT.Stacks.amount(1L, aStack), true);
            if (aStack != null && tFluid != null && this.fill(CS.FORGE_DIR[6], tFluid, false) == tFluid.amount && this.fill(CS.FORGE_DIR[6], tFluid, true) > 0) {
                --aStack.field_77994_a;
                if (tStack != null && !UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                }
                return true;
            }
            if (aStack != null) {
                for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    if (UT.Inventories.moveFromSlotToSlot((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, i, null, false, 64, 1, 64, 1) <= 0) continue;
                    return true;
                }
            }
            if (aStack != null) {
                for (FluidTank tTank : this.mTanksOutput) {
                    tStack = UT.Fluids.fillFluidContainer(tTank.getFluid(), UT.Stacks.amount(1L, aStack), true, true, true);
                    if (tStack == null) continue;
                    --aStack.field_77994_a;
                    if (!UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                    }
                    if (tTank.getFluidAmount() == 0) {
                        tTank.setFluid(null);
                    }
                    return true;
                }
            }
            if (aStack != null) {
                for (FluidTank tTank : this.mTanksInput) {
                    tStack = UT.Fluids.fillFluidContainer(tTank.getFluid(), UT.Stacks.amount(1L, aStack), true, true, true);
                    if (tStack == null) continue;
                    --aStack.field_77994_a;
                    if (!UT.Inventories.addStackToPlayerInventory(aPlayer, tStack, true)) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
                    }
                    if (tTank.getFluidAmount() == 0) {
                        tTank.setFluid(null);
                    }
                    return true;
                }
            }
            if (this.slot(6) == null && this.slot(7) == null && this.slot(8) == null && this.slot(9) == null && this.slot(10) == null && this.slot(11) == null) {
                for (int i = 0; i < 6; ++i) {
                    if (!UT.Inventories.addStackToPlayerInventory(aPlayer, this.slot(i), true)) continue;
                    this.slot(i, null);
                    return true;
                }
            }
        } else if (CS.SIDES_TOP[aSide]) {
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
            if (tCoords[0] <= CS.PIXELS_POS[2] && tCoords[1] <= CS.PIXELS_POS[2]) {
                this.mRecipes.openNEI();
                return true;
            }
            if (this.mDisplay != 0) {
                if (this.mDisplay < -1) {
                    UT.Sounds.play("liquid.water", 5, 1.0f, 1.0f, this.getCoords());
                } else {
                    UT.Sounds.play("dig.sand", 5, 1.0f, 1.0f, this.getCoords());
                }
            }
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplay != this.oDisplay;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplay = this.mDisplay;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        if (aData.length > 1) {
            this.mDisplay = UT.Code.combine(aData[0], aData[1]);
        }
        if (aData.length > 4) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        int i;
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!UT.Fluids.equal(aFluidToFill, this.mTanksInput[i].getFluid(), false)) continue;
            return this.mTanksInput[i];
        }
        if (UT.Fluids.temperature(aFluidToFill) >= this.mMaterial.mMeltingPoint - 100L || aFluidToFill.getFluid().getDensity(aFluidToFill) < 0) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (this.mTanksInput[i].getFluidAmount() != 0) continue;
            return this.mTanksInput[i];
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (this.mTanksOutput[i].getFluidAmount() == 0) continue;
                return this.mTanksOutput[i];
            }
        } else {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (!UT.Fluids.equal(aFluidToDrain, this.mTanksOutput[i].getFluid(), false)) continue;
                return this.mTanksOutput[i];
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        int i;
        IFluidTank[] rTanks = new IFluidTank[this.mTanksInput.length + this.mTanksOutput.length];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            rTanks[i] = this.mTanksInput[i];
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            rTanks[this.mTanksInput.length + i] = this.mTanksOutput[i];
        }
        return rTanks;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[14]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[9], CS.PIXELS_NEG[0]);
                return true;
            }
            case 6: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[8] + 0.001f, CS.PIXELS_NEG[14]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return 5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 2: {
                return 4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 1: {
                return 3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 3: {
                return 2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 4: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa), BlockTextureDefault.get(sOverlayBottom)) : null);
            }
            case 5: {
                if (this.mDisplay == 0 || 1 != aSide) {
                    return null;
                }
                if (this.mDisplay < -1) {
                    Fluid tFluid = FluidRegistry.getFluid((int)(-this.mDisplay - 2));
                    if (tFluid == null) {
                        return BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false);
                    }
                    return BlockTextureDefault.get((IIconContainer)new IconContainerDefault(tFluid.getIcon()), tFluid.getColor());
                }
                if (UT.Code.exists(this.mDisplay, OreDictMaterial.MATERIAL_ARRAY)) {
                    return BlockTextureDefault.get(OreDictMaterial.MATERIAL_ARRAY[this.mDisplay], OP.blockDust, OreDictMaterial.MATERIAL_ARRAY[this.mDisplay].contains(TD.Properties.GLOWING));
                }
                return BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_128, false);
            }
            case 6: {
                return 1 == aSide ? BI.nei() : null;
            }
            case 7: {
                return 1 != aSide ? (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTableBottom, this.mRGBa), BlockTextureDefault.get(sOverlayTableBottom)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureTableSide, this.mRGBa), BlockTextureDefault.get(sOverlayTableSide))) : null;
            }
        }
        return null;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List aList, Entity aEntity) {
        AxisAlignedBB tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[14]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
        if (aAABB.func_72326_a(tBox)) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[14]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[14]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[14])))) {
            aList.add(tBox);
        }
        if (aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[14]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0])))) {
            aList.add(tBox);
        }
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[0]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0]), (double)((float)this.field_145849_e + CS.PIXELS_POS[0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[0]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[8]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_NEG[8] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[12];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot >= 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (!UT.Stacks.equal(aStack, this.slot(i), true)) continue;
            return i == aSlot;
        }
        return this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot >= 6;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        return 0;
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (aFluid == CS.NF) {
            return 0;
        }
        for (FluidTank tTank : this.mTanksInput) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid) || tTank.getFluidAmount() < (aOnlyRemoveIfItCanRemoveAllAtOnce ? aFluid.amount : 1)) continue;
            return tTank.drain((int)aFluid.amount, (boolean)true).amount;
        }
        for (FluidTank tTank : this.mTanksOutput) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid) || tTank.getFluidAmount() < (aOnlyRemoveIfItCanRemoveAllAtOnce ? aFluid.amount : 1)) continue;
            return tTank.drain((int)aFluid.amount, (boolean)true).amount;
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        if (aFluid == CS.NF) {
            return 0L;
        }
        long rAmount = 0L;
        for (FluidTank tTank : this.mTanksInput) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid)) continue;
            rAmount += (long)tTank.getFluidAmount();
        }
        for (FluidTank tTank : this.mTanksOutput) {
            if (!UT.Fluids.equal(tTank.getFluid(), aFluid)) continue;
            rAmount += (long)tTank.getFluidAmount();
        }
        return rAmount;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bathing.pot";
    }
}

