/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tanks;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.recipes.Recipe;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileEntityBarrel
extends TileEntityBase07Paintable
implements IMultiTileEntity.IMTE_AddToolTips,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible,
ITileEntityProgress,
ITileEntityConnectedTank,
IFluidHandler,
IFluidContainerItem {
    public FluidTank[] mTanks = new FluidTank[]{new FluidTank(16000)};
    public byte mMode = 0;
    public long mSealedTime = 0L;
    public long mMaxSealedTime = 0L;
    public Recipe mRecipe = null;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.gasproof")) {
            this.mGasProof = aNBT.func_74767_n("gt.gasproof");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        this.mMode = aNBT.func_74771_c("gt.mode");
        this.mSealedTime = aNBT.func_74763_f("gt.progress");
        this.mTanks[0].setCapacity(aNBT.func_74762_e("gt.tankcap"));
        this.mTanks[0].readFromNBT(aNBT.func_74775_l("gt.tank"));
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.progress", this.mSealedTime);
        if (this.mTanks[0].getFluidAmount() > 0) {
            aNBT.func_74782_a("gt.tank", (NBTBase)this.mTanks[0].writeToNBT(new NBTTagCompound()));
        } else {
            aNBT.func_82580_o("gt.tank");
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        UT.NBT.setNumber(aNBT, "gt.progress", this.mSealedTime);
        if (this.mTanks[0].getFluidAmount() > 0) {
            aNBT.func_74782_a("gt.tank", (NBTBase)this.mTanks[0].writeToNBT(new NBTTagCompound()));
        } else {
            aNBT.func_82580_o("gt.tank");
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        if (this.mTanks[0].getFluidAmount() > 0) {
            aList.add(this.mTanks[0].getFluidAmount() + " L of " + UT.Fluids.name(this.mTanks[0].getFluid(), true) + " (" + (UT.Fluids.gas(this.mTanks[0].getFluid()) ? "Gaseous" : "Liquid") + "; Max: " + this.mTanks[0].getCapacity() + " L)");
            if ((this.mMode & CS.B[1]) != 0) {
                aList.add(LH.Chat.CYAN + "Sealed (" + this.mSealedTime + ")");
            }
        } else {
            aList.add(LH.Chat.CYAN + "Can store up to " + this.mTanks[0].getCapacity() + " L");
        }
        aList.add(LH.Chat.ORANGE + "Will void any Steam entering!");
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.mMaterial.mMeltingPoint + " K)");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            this.mMode = (byte)(this.mMode ^ CS.B[1]);
            aChatReturn.add((this.mMode & CS.B[1]) == 0 ? "Normal" : "Sealed");
            this.mMaxSealedTime = 0L;
            this.mSealedTime = 0L;
            return 10000L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanks[0].drain(1000, true) != CS.NF) {
                this.mMaxSealedTime = 0L;
                this.mSealedTime = 0L;
                return 10000L;
            }
            return 0L;
        }
        if (aTool.equals("wrench") || aTool.equals("monkeywrench")) {
            this.mMode = (byte)(this.mMode ^ CS.B[0]);
            aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill adjacent Tanks" : "Will fill adjacent Tanks");
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                FluidStack tFluid = this.mTanks[0].getFluid();
                if (tFluid == null) {
                    aChatReturn.add("Tank is empty");
                } else {
                    aChatReturn.add("Contains: " + tFluid.amount + " L of " + UT.Fluids.name(tFluid, true) + " (" + (UT.Fluids.gas(this.mTanks[0].getFluid()) ? "Gaseous" : "Liquid") + ")");
                    if ((this.mMode & CS.B[1]) != 0) {
                        if (this.mMaxSealedTime > 0L) {
                            aChatReturn.add("Sealed (" + this.mSealedTime + " / " + this.mMaxSealedTime + ")");
                        } else {
                            aChatReturn.add("Sealed");
                        }
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        FluidStack tFluid;
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && (tFluid = this.mTanks[0].getFluid()) != null && tFluid.amount > 0) {
            if (UT.Fluids.temperature(tFluid) >= this.mMaterial.mMeltingPoint && this.meltdown()) {
                return;
            }
            if (!this.mAcidProof && UT.Fluids.acid(tFluid)) {
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 0.5f, this.getCoords());
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!this.mGasProof && UT.Fluids.gas(tFluid)) {
                this.mTanks[0].setFluid(CS.NF);
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.getCoords());
            } else if (!this.allowFluid(tFluid)) {
                this.mTanks[0].setFluid(CS.NF);
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.getCoords());
            } else if ((this.mMode & CS.B[1]) != 0) {
                if (this.mMaxSealedTime == 0L) {
                    this.mRecipe = Recipe.RecipeMap.sFermenterRecipes.findRecipe(this, this.mRecipe, true, Long.MAX_VALUE, CS.NI, new FluidStack[]{this.mTanks[0].getFluid()}, CS.ZL_ITEMSTACK);
                    if (this.mRecipe != null && this.mRecipe.mFluidInputs.length > 0 && this.mRecipe.mFluidOutputs.length > 0 && !UT.Fluids.gas(this.mRecipe.mFluidInputs[0]) && !UT.Fluids.gas(this.mRecipe.mFluidOutputs[0])) {
                        this.mMaxSealedTime = this.mRecipe.mDuration * this.mRecipe.mEUt * (long)this.mTanks[0].getFluidAmount() / (long)this.mRecipe.mFluidInputs[0].amount;
                    } else {
                        this.mRecipe = null;
                    }
                }
                ++this.mSealedTime;
                if (this.mRecipe != null && this.mMaxSealedTime > 0L && this.mSealedTime >= this.mMaxSealedTime) {
                    this.mTanks[0].setFluid(UT.Fluids.mul(this.mRecipe.mFluidOutputs[0], this.mTanks[0].getFluidAmount(), this.mRecipe.mFluidInputs[0].amount, false));
                    this.mMaxSealedTime = 0L;
                    this.mSealedTime = 0L;
                    this.mRecipe = null;
                }
            } else if ((this.mMode & CS.B[0]) != 0) {
                FluidStack tDrained;
                DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(tFluid.getFluid().getDensity() < 0 ? (byte)1 : 0);
                if (tTileEntity.mTileEntity != null && (tDrained = this.mTanks[0].drain(Integer.MAX_VALUE, false)) != null) {
                    tDrained.amount = ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tDrained, false);
                    if (tDrained.amount > 0 && ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], this.mTanks[0].drain(tDrained.amount, true), true) > 0) {
                        this.updateInventory();
                    }
                }
            }
        }
    }

    public boolean meltdown() {
        if (UT.Fluids.lava(this.mTanks[0].getFluid()) && this.mTanks[0].getFluidAmount() >= 1000) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 0, 3);
        } else {
            this.setToFire();
        }
        UT.Worlds.setOnFire(this.field_145850_b, this.getCoords(), false, false);
        return true;
    }

    public boolean allowFluid(FluidStack aFluid) {
        return !UT.Fluids.anysteam(aFluid) && UT.Fluids.temperature(aFluid) < this.mMaterial.mMeltingPoint;
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.mTanks[0].getFluid();
    }

    public int getCapacity(ItemStack aStack) {
        return this.mTanks[0].getCapacity();
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        if (!this.allowFluid(aFluid)) {
            return 0;
        }
        if (!this.mGasProof && UT.Fluids.gas(aFluid)) {
            return 0;
        }
        if (!this.mAcidProof && UT.Fluids.acid(aFluid)) {
            return 0;
        }
        int tFilled = this.fill(CS.FORGE_DIR[6], aFluid, true);
        if (tFilled > 0 && aDoFill) {
            NBTTagCompound aNBT = this.writeItemNBT(aStack.func_77942_o() ? aStack.func_77978_p() : new NBTTagCompound());
            aStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        }
        return tFilled;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        FluidStack tDrained = this.drain(CS.FORGE_DIR[6], aMaxDrain, true);
        if (tDrained != CS.NF && aDoDrain) {
            NBTTagCompound aNBT = this.writeItemNBT(aStack.func_77942_o() ? aStack.func_77978_p() : new NBTTagCompound());
            aStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        }
        return tDrained;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mSealedTime;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mMaxSealedTime;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return false;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return (this.mMode & CS.B[1]) != 0 ? null : this.mTanks[0];
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return (this.mMode & CS.B[1]) != 0 ? null : this.mTanks[0];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        if (aFluid == CS.NF || this.mTanks[0].getFluidAmount() <= 0 && aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
            return 0;
        }
        return this.mTanks[0].fill(aFluid, true);
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (aFluid == CS.NF || this.mTanks[0].getFluidAmount() < (aOnlyRemoveIfItCanRemoveAllAtOnce ? aFluid.amount : 1)) {
            return 0;
        }
        return this.mTanks[0].drain((int)aFluid.amount, (boolean)true).amount;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        return aFluid == CS.NF || this.mTanks[0].getFluid() == CS.NF || !UT.Fluids.equal(this.mTanks[0].getFluid(), aFluid) ? 0L : (long)this.mTanks[0].getFluidAmount();
    }
}

