/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileEntityTank3x3x3
extends TileEntityBase10MultiBlockBase
implements IMultiBlockFluidHandler,
IFluidHandler,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible {
    public FluidTank[] mTanks = new FluidTank[]{new FluidTank(432000)};
    public short mTankWalls = (short)18002;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.design")) {
            this.mTankWalls = aNBT.func_74765_d("gt.design");
        }
        if (aNBT.func_74764_b("gt.gasproof")) {
            this.mGasProof = aNBT.func_74767_n("gt.gasproof");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        this.mTanks[0].setCapacity(aNBT.func_74762_e("gt.tankcap"));
        this.mTanks[0].readFromNBT(aNBT.func_74775_l("gt.tank"));
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74782_a("gt.tank", (NBTBase)this.mTanks[0].writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + "Can store up to " + this.mTanks[0].getCapacity() + " L");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + "3x3x3 Hollow of the Block you crafted this one with");
        aList.add(LH.Chat.WHITE + "This Block centered on Side/Top/Bottom and facing outwards");
        aList.add(LH.Chat.WHITE + "Auto-Emits Fluids from the Main Block if not against Gravity");
        aList.add(LH.Chat.ORANGE + "Will void any Steam entering!");
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.mMaterial.mMeltingPoint + " K)");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean checkStructure2() {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.field_145850_b.func_72899_e(tX - 1, tY = this.getOffsetYN(this.mFacing), (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ - 1) && this.field_145850_b.func_72899_e(tX - 1, tY, tZ + 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.field_145850_b.func_147468_f(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, this.mTankWalls, this.getMultiTileEntityRegistryID(), 1, (byte)-13)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.getOffsetYN(this.mFacing);
        int tZ = this.getOffsetZN(this.mFacing);
        return aX >= tX - 1 && aY >= tY - 1 && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 1 && aZ <= tZ + 1;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger") && this.mTanks[0].drain(1000, true) != CS.NF) {
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (!this.checkStructure(false)) {
                    this.checkStructure(true);
                }
                if (this.checkStructure(false)) {
                    FluidStack tFluid = this.mTanks[0].getFluid();
                    if (tFluid == null) {
                        aChatReturn.add("Tank is empty");
                    } else {
                        aChatReturn.add("Contains: " + tFluid.amount + " L of " + UT.Fluids.name(this.mTanks[0].getFluid(), true) + " (" + (UT.Fluids.gas(this.mTanks[0].getFluid()) ? "Gaseous" : "Liquid") + ")");
                    }
                } else {
                    aChatReturn.add("Tank did not form!");
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        FluidStack tFluid;
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.checkStructure(false) && (tFluid = this.mTanks[0].getFluid()) != null && tFluid.amount > 0) {
            if (UT.Fluids.temperature(tFluid) >= this.mMaterial.mMeltingPoint && this.meltdown()) {
                return;
            }
            if (!this.mAcidProof && UT.Fluids.acid(tFluid)) {
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 0.5f, this.getCoords());
                int tX = this.getOffsetXN(this.mFacing);
                int tY = this.getOffsetYN(this.mFacing);
                int tZ = this.getOffsetZN(this.mFacing);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (this.getRandomNumber(3) != 0) continue;
                            this.field_145850_b.func_147468_f(tX + i, tY + j, tZ + k);
                        }
                    }
                }
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!this.mGasProof && UT.Fluids.gas(tFluid)) {
                this.mTanks[0].setFluid(CS.NF);
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.getCoords());
            } else if (!this.allowFluid(tFluid)) {
                this.mTanks[0].setFluid(CS.NF);
                UT.Sounds.send(this.field_145850_b, "random.fizz", 1.0f, 1.0f, this.getCoords());
            } else if (CS.SIDES_HORIZONTAL[this.mFacing] || UT.Fluids.gas(tFluid) || (tFluid.getFluid().getDensity() < 0 ? CS.SIDES_TOP : CS.SIDES_BOTTOM)[this.mFacing]) {
                FluidStack tDrained;
                DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.mFacing);
                if (tTileEntity.mTileEntity != null && (tDrained = this.mTanks[0].drain(Integer.MAX_VALUE, false)) != null) {
                    tDrained.amount = ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], tDrained, false);
                    if (tDrained.amount > 0 && ((IFluidHandler)tTileEntity.mTileEntity).fill(CS.FORGE_DIR[tTileEntity.mSideOfTileEntity], this.mTanks[0].drain(tDrained.amount, true), true) > 0) {
                        this.updateInventory();
                    }
                }
            }
        }
    }

    public boolean allowFluid(FluidStack aFluid) {
        return !UT.Fluids.anysteam(aFluid) && UT.Fluids.temperature(aFluid) < this.mMaterial.mMeltingPoint;
    }

    public boolean meltdown() {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.getOffsetYN(this.mFacing);
        int tZ = this.getOffsetZN(this.mFacing);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    UT.Worlds.setOnFire(this.field_145850_b, tX + i, tY + j, tZ + k, false, false);
                    if (this.getRandomNumber(4) != 0) continue;
                    this.field_145850_b.func_147465_d(tX + i, tY + j, tZ + k, (Block)Blocks.field_150480_ab, 0, 3);
                }
            }
        }
        if (UT.Fluids.lava(this.mTanks[0].getFluid()) && this.mTanks[0].getFluidAmount() >= 1000) {
            this.field_145850_b.func_147465_d(tX, tY, tZ, (Block)Blocks.field_150356_k, 0, 3);
        }
        this.setToFire();
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.mTanks[0];
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[0];
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.mTanks;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[0];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }
}

