/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntityFluidSpring
extends TileEntityBase04MultiTileEntities
implements IMultiTileEntity.IMTE_OnRegistration,
ITileEntitySurface,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_SyncDataShort {
    public FluidStack mFluid = UT.Fluids.water(1L);
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityFluidSpring INSTANCE;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.spring")) {
            this.mFluid = UT.Fluids.load(aNBT, "gt.spring");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.Fluids.save(aNBT, "gt.spring", this.mFluid);
    }

    @Override
    public final NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(aNBT);
        UT.Fluids.save(aNBT, "gt.spring", this.mFluid);
        return aNBT;
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, FluidStack aSpring) {
        return MultiTileEntityFluidSpring.MTE_REGISTRY.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)1, INSTANCE.getMultiTileEntityID(), UT.NBT.getNBTs(null, "gt.spring", aSpring), true, false);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketShort(aSendAll, (short)this.mFluid.getFluid().getID());
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mFluid = UT.Fluids.make(UT.Fluids.fluid(aData), 1200L);
        return true;
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (aIsServerSide && this.getRandomNumber(this.mFluid.amount) == 0) {
            Block tBlock = this.mFluid.getFluid().getBlock();
            Block tAbove = this.getBlockAtSide((byte)1);
            byte tNeededMetaData = (byte)(tBlock instanceof BlockFluidFinite ? 7 : 0);
            if (tAbove == tBlock && this.getMetaDataAtSide((byte)1) != tNeededMetaData || tAbove.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, tBlock, (int)tNeededMetaData, 3);
            }
        }
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureFluid.get(this.mFluid), BlockTextureDefault.get(Textures.BlockIcons.FLUID_SPRING)) : null;
    }

    @Override
    public int getLightOpacity() {
        return 255;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return Blocks.field_150357_h.func_149638_a(aExploder);
    }

    @Override
    public float getExplosionResistance() {
        return Blocks.field_150357_h.func_149638_a(null);
    }

    @Override
    public float getBlockHardness() {
        return -1.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return true;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return true;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.fluid.spring";
    }
}

