/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import gregtech.GT_Mod;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntityCertificate
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_OnRegistration,
IMultiTileEntity.IMTE_GetLifeSpan,
IMultiTileEntity.IMTE_OnServerLoad,
IMultiTileEntity.IMTE_OnServerSave,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public static final ArrayListNoNulls<String> ALREADY_RECEIVED = new ArrayListNoNulls();
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityCertificate INSTANCE;
    public boolean mSilver = false;
    public boolean mGold = false;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSilver;
    public static IIconContainer sTextureGold;

    @Override
    public void onServerSave(File aSaveLocation) {
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "certificates.support.dat");
        if (!aTargetFile.exists()) {
            try {
                aTargetFile.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        NBTTagCompound aNBT = new NBTTagCompound();
        for (int i = 0; i < ALREADY_RECEIVED.size(); ++i) {
            aNBT.func_74778_a("" + i, (String)ALREADY_RECEIVED.get(i));
        }
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)aNBT, (File)aTargetFile);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    @Override
    public void onServerLoad(File aSaveLocation) {
        ALREADY_RECEIVED.clear();
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "certificates.support.dat");
        if (aTargetFile.exists()) {
            NBTTagCompound aNBT = new NBTTagCompound();
            try {
                aNBT = CompressedStreamTools.func_74797_a((File)aTargetFile);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            for (int i = 0; i < Integer.MAX_VALUE && aNBT.func_74764_b("" + i); ++i) {
                ALREADY_RECEIVED.add(aNBT.func_74779_i("" + i));
            }
        }
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    public static ItemStack getCertificate(int aAmount, String aName) {
        NBTTagCompound tNBT = new NBTTagCompound();
        if (UT.Code.stringValid(aName)) {
            tNBT.func_74782_a("display", (NBTBase)UT.NBT.getNBTString(tNBT.func_74775_l("display"), "Name", aName));
        }
        return MTE_REGISTRY.getItem(INSTANCE.getMultiTileEntityID(), aAmount, tNBT);
    }

    @Override
    public int getLifeSpan(World aWorld, ItemStack aStack) {
        return 0x7FFFFFFE;
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        String tName = this.getCustomName();
        if (UT.Code.stringValid(tName)) {
            this.mGold = GT_Mod.gregtechproxy.mSupporterListGold.contains(tName.toLowerCase());
            this.mSilver = GT_Mod.gregtechproxy.mSupporterListSilver.contains(tName.toLowerCase());
        }
    }

    @Override
    public void setCustomName(String aName) {
        super.setCustomName(aName);
        if (UT.Code.stringValid(aName)) {
            this.mGold = GT_Mod.gregtechproxy.mSupporterListGold.contains(aName.toLowerCase());
            this.mSilver = GT_Mod.gregtechproxy.mSupporterListSilver.contains(aName.toLowerCase());
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.certificate"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && (this.mGold || this.mSilver)) {
            if (this.mGold) {
                UT.Entities.sendchat((Object)aPlayer, "This Certificate is owned by " + LH.Chat.YELLOW + this.getCustomName());
                return true;
            }
            if (this.mSilver) {
                UT.Entities.sendchat((Object)aPlayer, "This Certificate is owned by " + LH.Chat.CYAN + this.getCustomName());
                return true;
            }
            UT.Entities.sendchat((Object)aPlayer, "This Certificate is invalid!");
            return true;
        }
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        aBlock.func_149676_a(CS.PIXELS_POS[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PIXELS_POS[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PIXELS_POS[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aSide == CS.OPPOSITES[this.mFacing]) {
            return aShouldSideBeRendered[aSide] ? BlockTextureDefault.get(sTextureBack) : null;
        }
        return BlockTextureDefault.get(this.mGold ? sTextureGold : (this.mSilver ? sTextureSilver : sTextureBack));
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145848_d + CS.PIXELS_POS[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145849_e + CS.PIXELS_POS[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145848_d + CS.PIXELS_NEG[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)]), (double)((float)this.field_145849_e + CS.PIXELS_NEG[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[4 == this.mFacing ? 15 : (5 == this.mFacing ? 0 : 1)], CS.PIXELS_POS[0 == this.mFacing ? 15 : (1 == this.mFacing ? 0 : 1)], CS.PIXELS_POS[2 == this.mFacing ? 15 : (3 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[5 == this.mFacing ? 15 : (4 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[1 == this.mFacing ? 15 : (0 == this.mFacing ? 0 : 1)], CS.PIXELS_NEG[3 == this.mFacing ? 15 : (2 == this.mFacing ? 0 : 1)]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PIXELS_POS[15] : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? CS.PIXELS_POS[15] : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide == this.mFacing ? CS.PIXELS_NEG[1] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public int getPaint() {
        return 0xFFFFFF;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mGold ? 2 : (this.mSilver ? 1 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        if (aData == 2) {
            this.mGold = true;
        }
        if (aData == 1) {
            this.mSilver = true;
        }
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.certificate";
    }

    static {
        LH.add("gt.tooltip.certificate", "Certified Support of GregTech");
        sTextureBack = new Textures.BlockIcons.CustomIcon("BACK");
        sTextureSilver = new Textures.BlockIcons.CustomIcon("SILVER");
        sTextureGold = new Textures.BlockIcons.CustomIcon("GOLD");
    }
}

