/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntityCFoamScaffoldWood
extends TileEntityBase07Paintable
implements ITileEntityFoamable,
IMultiTileEntity.IMTE_GetSubItems,
IMultiTileEntity.IMTE_OnRegistration {
    public boolean mFoamDried = false;
    public static MultiTileEntityRegistry MTE_REGISTRY = null;
    public static MultiTileEntityCFoamScaffoldWood INSTANCE;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.foamdried")) {
            this.mFoamDried = aNBT.func_74767_n("gt.foamdried");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        super.writeItemNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.foamdried", this.mFoamDried);
        return aNBT;
    }

    public static boolean setBlock(World aWorld, int aX, int aY, int aZ, byte aSide, EntityPlayer aPlayer, ItemStack aStack, short[] aRGB) {
        return MultiTileEntityCFoamScaffoldWood.MTE_REGISTRY.mBlock.placeBlock(aWorld, aX, aY, aZ, aSide, INSTANCE.getMultiTileEntityID(), UT.NBT.getNBTs(null, "gt.color", UT.Code.getRGBInt(aRGB), "gt.painted", true), true, false);
    }

    @Override
    public void onRegistration(MultiTileEntityRegistry aRegistry, short aID) {
        INSTANCE = this;
        MTE_REGISTRY = aRegistry;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer >= 100L && this.getRandomNumber(5900) == 0) {
            this.dryFoam((byte)6);
        }
    }

    @Override
    public boolean dryFoam(byte aSide) {
        if (this.mFoamDried || this.isClientSide()) {
            return false;
        }
        this.mFoamDried = true;
        this.updateClientData();
        return true;
    }

    @Override
    public boolean removeFoam(byte aSide) {
        if (this.isClientSide()) {
            return false;
        }
        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, CS.NB, 0, 3);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureDefault.get((IIconContainer)(this.mFoamDried ? Textures.BlockIcons.CFOAM_HARDENED : Textures.BlockIcons.CFOAM_FRESH), this.mRGBa) : null;
    }

    @Override
    public int getLightOpacity() {
        return this.mFoamDried ? 255 : 3;
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.mFoamDried ? 24.0f : 6.0f;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mFoamDried ? 1 : 0);
    }

    @Override
    public void setVisualData(byte aData) {
        this.mFoamDried = aData != 0;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean hasFoam(byte aSide) {
        return true;
    }

    @Override
    public boolean driedFoam(byte aSide) {
        return this.mFoamDried;
    }

    @Override
    public boolean applyFoam(byte aSide, short[] aCFoamRGB, byte aVanillaColor) {
        return false;
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List aList, short aID) {
        return false;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.cfoam.scaffold.wood";
    }
}

