/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.inventories.MultiTileEntitySafe;
import gregapi.util.UT;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntitySafeMechanical
extends MultiTileEntitySafe {
    public UUID mOwner;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/front"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/back"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/safes/mechanical/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.owner")) {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("gt.owner"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mOwner != null) {
            aNBT.func_74778_a("gt.owner", this.mOwner.toString());
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer != null && aPlayer.func_70093_af()) {
            this.allowInteraction((Entity)aPlayer);
        }
        return super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        if (aEntity != null) {
            UUID tUUID = aEntity.func_110124_au();
            if (this.mOwner == null) {
                this.mOwner = tUUID;
                this.updateClientData();
            }
            return this.mOwner == null || tUUID != null && tUUID.equals(this.mOwner);
        }
        return false;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            byte[] tName = this.mOwner == null ? CS.ZL_BYTE : this.mOwner.toString().getBytes();
            byte[] tData = new byte[tName.length + 4];
            tData[0] = (byte)UT.Code.getR(this.mRGBa);
            tData[1] = (byte)UT.Code.getG(this.mRGBa);
            tData[2] = (byte)UT.Code.getB(this.mRGBa);
            tData[3] = this.getDirectionData();
            for (int i = 0; i < tName.length; i = (int)((short)(i + 1))) {
                tData[i + 4] = tName[i];
            }
            return this.getClientDataPacketByteArray(aSendAll, tData);
        }
        return null;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        if (aData.length > 4) {
            this.mOwner = UUID.fromString(new String(aData, 4, aData.length - 4));
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPPOSITES[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.safe.mechanical";
    }
}

