/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.render.RenderHelper;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.opengl.GL11;

public abstract class MultiTileEntityMassStorage
extends TileEntityBase09FacingSingle
implements ITileEntityConnectedInventory,
ITileEntityProgress,
ITileEntityAdjacentInventoryUpdatable,
IMultiTileEntity.IMTE_SyncDataInteger,
IMultiTileEntity.IMTE_OnRegistrationFirstClient {
    public int oStacksize = 0;
    public int mMaxStorage = 1000000;
    public long mPartialUnits = 0L;
    public byte mMode = 0;
    public static final int[] ACCESSIBLE_SLOTS;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mMode = aNBT.func_74771_c("gt.mode");
        if (aNBT.func_74764_b("gt.capacity")) {
            this.mMaxStorage = aNBT.func_74762_e("gt.capacity");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mPartialUnits = aNBT.func_74763_f("gt.input");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.mode", this.mMode);
        UT.NBT.setNumber(aNBT, "gt.input", this.mPartialUnits);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.isClientSide() && this.slotHas(1)) {
            aNBT.func_74782_a("display", (NBTBase)UT.NBT.getNBTString(aNBT.func_74775_l("display"), "Name", this.slot(1).func_82833_r()));
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.massstorage.tooltip.1") + this.mMaxStorage);
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.massstorage.tooltip.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.cutter.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            if (this.slotHas(0)) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + CS.OFFSETS_X[this.mFacing]) + 0.5, (double)(this.field_145848_d + CS.OFFSETS_Y[this.mFacing]) + 0.5, (double)(this.field_145849_e + CS.OFFSETS_Z[this.mFacing]) + 0.5, UT.Stacks.copy(this.slot(0))));
                this.slot(0, CS.NI);
                this.updateInventory();
                return 10000L;
            }
            if (this.slotHas(1)) {
                for (int i = 0; i < 128 && this.slot((int)1).field_77994_a > Math.max(1, this.slot(1).func_77976_d()); ++i) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + CS.OFFSETS_X[this.mFacing]) + 0.5, (double)(this.field_145848_d + CS.OFFSETS_Y[this.mFacing]) + 0.5, (double)(this.field_145849_e + CS.OFFSETS_Z[this.mFacing]) + 0.5, UT.Stacks.amount(Math.max(1, this.slot(1).func_77976_d()), this.slot(1))));
                    this.slot((int)1).field_77994_a -= Math.max(1, this.slot(1).func_77976_d());
                }
                if (this.slot((int)1).field_77994_a > 0) {
                    if (this.slot((int)1).field_77994_a <= Math.max(1, this.slot(1).func_77976_d())) {
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)(this.field_145851_c + CS.OFFSETS_X[this.mFacing]) + 0.5, (double)(this.field_145848_d + CS.OFFSETS_Y[this.mFacing]) + 0.5, (double)(this.field_145849_e + CS.OFFSETS_Z[this.mFacing]) + 0.5, UT.Stacks.copy(this.slot(1))));
                        this.slot(1, CS.NI);
                        this.updateClientData();
                    }
                } else {
                    this.slot(1, CS.NI);
                    this.updateClientData();
                }
                this.updateInventory();
                return 2000L;
            }
        }
        if (aTool.equals("cutter")) {
            this.mMode = (byte)(this.mMode ^ CS.B[2]);
            aChatReturn.add((this.mMode & CS.B[2]) == 0 ? "Won't emit Overflow" : "Will emit Overflow to Inventories below");
            if ((this.mMode & CS.B[2]) != 0 && this.slot((int)1).field_77994_a <= 0) {
                this.slot(1, CS.NI);
            }
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("screwdriver")) {
            this.mMode = (byte)(this.mMode ^ CS.B[1]);
            aChatReturn.add((this.mMode & CS.B[1]) == 0 ? "Filter stays when empty" : "Filter resets when empty");
            if ((this.mMode & CS.B[1]) != 0 && this.slot((int)1).field_77994_a <= 0) {
                this.slot(1, CS.NI);
            }
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mMode = (byte)(this.mMode ^ CS.B[0]);
            aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill Inventories below" : "Will fill Inventories below");
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.slotHas(1)) {
                    aChatReturn.add("Contains: " + this.slot((int)1).field_77994_a + " " + this.slot(1).func_82833_r());
                } else {
                    aChatReturn.add("Storage is empty");
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
        if (tCoords[0] < CS.PIXELS_POS[1] || tCoords[0] > CS.PIXELS_NEG[1] || tCoords[1] < CS.PIXELS_POS[1] || tCoords[1] > CS.PIXELS_NEG[1]) {
            return false;
        }
        if (this.isServerSide() && aPlayer != null) {
            ItemStack aStack = aPlayer.func_71045_bC();
            if (this.slotHas(1)) {
                int tAmount = 0;
                if (tCoords[1] >= CS.PIXELS_POS[6] && tCoords[1] <= CS.PIXELS_POS[8]) {
                    if (tCoords[0] >= CS.PIXELS_POS[1] && tCoords[0] <= CS.PIXELS_POS[3]) {
                        tAmount = 8;
                    }
                    if (tCoords[0] >= CS.PIXELS_NEG[3] && tCoords[0] <= CS.PIXELS_NEG[1]) {
                        tAmount = 64;
                    }
                }
                if (tCoords[1] >= CS.PIXELS_POS[9] && tCoords[1] <= CS.PIXELS_POS[11]) {
                    if (tCoords[0] >= CS.PIXELS_POS[1] && tCoords[0] <= CS.PIXELS_POS[3]) {
                        tAmount = 4;
                    }
                    if (tCoords[0] >= CS.PIXELS_NEG[3] && tCoords[0] <= CS.PIXELS_NEG[1]) {
                        tAmount = 32;
                    }
                }
                if (tCoords[1] >= CS.PIXELS_POS[12] && tCoords[1] <= CS.PIXELS_POS[14]) {
                    if (tCoords[0] >= CS.PIXELS_POS[1] && tCoords[0] <= CS.PIXELS_POS[3]) {
                        tAmount = 1;
                    }
                    if (tCoords[0] >= CS.PIXELS_NEG[3] && tCoords[0] <= CS.PIXELS_NEG[1]) {
                        tAmount = 16;
                    }
                }
                if (tCoords[1] >= CS.PIXELS_POS[6] && tCoords[0] >= CS.PIXELS_POS[4] && tCoords[0] <= CS.PIXELS_NEG[4]) {
                    tAmount = -1;
                }
                if (tAmount > 0) {
                    ItemStack tStack;
                    this.slot((int)1).field_77994_a -= tAmount;
                    for (tAmount = Math.min(tAmount, this.slot((int)1).field_77994_a); tAmount > 0; tAmount -= tStack.field_77994_a) {
                        tStack = UT.Stacks.amount(Math.min(tAmount, Math.max(1, this.slot(1).func_77976_d())), this.slot(1));
                        EntityItem rEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(this.mFacing) + 0.5, (double)this.getOffsetY(this.mFacing) + 0.5, (double)this.getOffsetZ(this.mFacing) + 0.5, tStack);
                        rEntity.field_70179_y = 0.0;
                        rEntity.field_70181_x = 0.0;
                        rEntity.field_70159_w = 0.0;
                        this.field_145850_b.func_72838_d((Entity)rEntity);
                    }
                    this.updateInventory();
                    this.playClick();
                } else if (UT.Stacks.valid(aStack)) {
                    ItemStack tStack = this.insertItems(aStack, true);
                    if (tStack == null) {
                        aStack.field_77994_a = 0;
                        this.playClick();
                    } else if (tStack.field_77994_a < aStack.field_77994_a) {
                        aStack.field_77994_a = tStack.field_77994_a;
                        this.playClick();
                    }
                } else if (tAmount == -1) {
                    boolean temp = false;
                    for (int i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
                        if (aPlayer.field_71071_by.field_70462_a[i] == null || !this.allowInsertion(aPlayer.field_71071_by.field_70462_a[i])) continue;
                        ItemStack tStack = this.insertItems(aPlayer.field_71071_by.field_70462_a[i], false);
                        if (tStack == null) {
                            temp = true;
                            aPlayer.field_71071_by.field_70462_a[i] = null;
                            continue;
                        }
                        if (tStack.field_77994_a >= aPlayer.field_71071_by.field_70462_a[i].field_77994_a) break;
                        temp = true;
                        aPlayer.field_71071_by.field_70462_a[i] = tStack;
                    }
                    if (temp) {
                        if (aPlayer.field_71069_bz != null) {
                            aPlayer.field_71069_bz.func_75142_b();
                        }
                        this.playClick();
                    }
                } else if (this.slot((int)1).field_77994_a > 0) {
                    ItemStack tStack = UT.Stacks.amount(Math.min(this.slot((int)1).field_77994_a, Math.max(1, this.slot(1).func_77976_d())), this.slot(1));
                    this.slot((int)1).field_77994_a -= tStack.field_77994_a;
                    EntityItem rEntity = new EntityItem(this.field_145850_b, (double)this.getOffsetX(this.mFacing) + 0.5, (double)this.getOffsetY(this.mFacing) + 0.5, (double)this.getOffsetZ(this.mFacing) + 0.5, tStack);
                    rEntity.field_70179_y = 0.0;
                    rEntity.field_70181_x = 0.0;
                    rEntity.field_70159_w = 0.0;
                    this.field_145850_b.func_72838_d((Entity)rEntity);
                    this.updateInventory();
                    this.playClick();
                }
                if ((this.mMode & CS.B[1]) != 0 && this.slot((int)1).field_77994_a <= 0 && this.mPartialUnits <= 0L) {
                    this.slot(1, CS.NI);
                    this.updateClientData();
                    this.updateInventory();
                }
            } else if (UT.Stacks.valid(aStack)) {
                ItemStack tStack = this.insertItems(aStack, true);
                if (tStack == null) {
                    aStack.field_77994_a = 0;
                    this.playClick();
                } else if (tStack.field_77994_a < aStack.field_77994_a) {
                    aStack.field_77994_a = tStack.field_77994_a;
                    this.playClick();
                }
            }
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.slotHas(0)) {
                this.slot(0, this.insertItems(this.slot(0), false));
            }
            boolean temp = false;
            if ((this.mInventoryChanged || aTimer % 100L == 0L) && this.slotHas(1)) {
                if ((this.mMode & CS.B[0]) != 0 && this.slot((int)1).field_77994_a > 0) {
                    DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory((byte)0);
                    if (UT.Inventories.moveOneItemStack(this, tTileEntity, (byte)0, tTileEntity.mSideOfTileEntity, null, false, 64, 1, 64, 1) > 0) {
                        temp = true;
                    }
                } else if ((this.mMode & CS.B[2]) != 0 && this.slot((int)1).field_77994_a > this.mMaxStorage) {
                    this.emitOverflow();
                }
            }
            if (this.mInventoryChanged || temp) {
                for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                }
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.isFaceVisible() && (this.slotHas(1) ? Math.abs(this.slot((int)1).field_77994_a - this.oStacksize) > (CS.SERVER_TIME % 20L == 0L ? 0 : 64) : this.oStacksize != 0);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oStacksize = this.slotHas(1) ? this.slot((int)1).field_77994_a : 0;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        if (aSlot == 0) {
            this.slot(0, this.insertItems(OM.get(aStack), false));
        }
    }

    public int getMaxContent() {
        return (this.mMode & CS.B[2]) != 0 ? this.mMaxStorage + 256 : this.mMaxStorage;
    }

    public ItemStack insertItems(ItemStack aStack, boolean aCheckForNEI) {
        if (UT.Stacks.invalid(aStack)) {
            return null;
        }
        if (!this.slotHas(1)) {
            if (aCheckForNEI && aStack.field_77994_a == 111) {
                this.slot(1, UT.Stacks.amount(this.mMaxStorage, aStack));
                this.mPartialUnits = 0L;
                this.updateClientData();
                this.updateInventory();
                return aStack;
            }
            this.slot(1, UT.Stacks.copy(aStack));
            this.updateClientData();
            this.updateInventory();
            if ((this.mMode & CS.B[2]) != 0 && aStack.field_77994_a > this.mMaxStorage) {
                this.emitOverflow();
            }
            return null;
        }
        int tMaxStorage = this.getMaxContent();
        ItemStack tContent = this.slot(1);
        if (tContent.field_77994_a >= tMaxStorage) {
            return aStack;
        }
        if (UT.Stacks.equal(aStack, tContent)) {
            if (aCheckForNEI && aStack.field_77994_a == 111) {
                tContent.field_77994_a = this.mMaxStorage;
                this.mPartialUnits = 0L;
                this.updateInventory();
                return aStack;
            }
            ItemStack rStack = null;
            if (aStack.field_77994_a + tContent.field_77994_a > tMaxStorage) {
                rStack = UT.Stacks.amount(aStack.field_77994_a + tContent.field_77994_a - tMaxStorage, aStack);
            }
            tContent.field_77994_a = Math.min(tMaxStorage, tContent.field_77994_a + aStack.field_77994_a);
            this.updateInventory();
            if ((this.mMode & CS.B[2]) != 0 && tContent.field_77994_a > this.mMaxStorage) {
                this.emitOverflow();
            }
            return rStack;
        }
        OreDictItemData tData = OM.data_(tContent);
        OreDictItemData aData = OM.data_(aStack);
        if (tData != null && aData != null && tData.hasValidPrefixData() && aData.hasValidPrefixData() && tData.mMaterial.mMaterial == aData.mMaterial.mMaterial && this.mPartialUnits < tData.mPrefix.mAmount && (tData.mPrefix.contains(TD.Prefix.DUST_BASED) && aData.mPrefix.contains(TD.Prefix.DUST_BASED) || tData.mPrefix.contains(TD.Prefix.INGOT_BASED) && aData.mPrefix.contains(TD.Prefix.INGOT_BASED))) {
            this.updatePartialContent(aData.mPrefix.mAmount * (long)aStack.field_77994_a);
            if ((this.mMode & CS.B[2]) != 0 && tContent.field_77994_a > this.mMaxStorage) {
                this.emitOverflow();
            }
            return null;
        }
        return aStack;
    }

    public void updatePartialContent(long aAmountAdded) {
        OreDictItemData tData;
        this.mPartialUnits += aAmountAdded;
        int tMaxStorage = this.getMaxContent();
        ItemStack tContent = this.slot(1);
        if (this.mPartialUnits > 0L && this.slotHas(1) && tContent.field_77994_a < tMaxStorage && (tData = OM.data_(tContent)) != null && tData.hasValidPrefixData() && this.mPartialUnits >= tData.mPrefix.mAmount) {
            ItemStack tStack = UT.Stacks.amount(this.mPartialUnits / tData.mPrefix.mAmount, tContent);
            if (tStack.field_77994_a > 0) {
                this.mPartialUnits -= tData.mPrefix.mAmount * (long)tStack.field_77994_a;
                if (tStack.field_77994_a + tContent.field_77994_a > tMaxStorage) {
                    this.mPartialUnits += tData.mPrefix.mAmount * (long)(tStack.field_77994_a + tContent.field_77994_a - tMaxStorage);
                }
                tContent.field_77994_a = Math.min(tMaxStorage, tContent.field_77994_a + tStack.field_77994_a);
                this.updateInventory();
            }
        }
    }

    public void emitOverflow() {
        byte tToBeMoved;
        DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory((byte)0);
        while (this.slotHas(1) && this.slot((int)1).field_77994_a > this.mMaxStorage && UT.Inventories.moveOneItemStack(this, tTileEntity, (byte)0, tTileEntity.mSideOfTileEntity, null, false, tToBeMoved = UT.Code.bindStack(this.slot((int)1).field_77994_a - this.mMaxStorage), 1, tToBeMoved, 1) > 0) {
        }
    }

    public boolean allowInsertion(ItemStack aStack) {
        if (UT.Stacks.equal(this.slot(1), aStack)) {
            return true;
        }
        OreDictItemData tData = OM.data_(this.slot(1));
        OreDictItemData aData = OM.data_(aStack);
        if (tData != null && aData != null && tData.hasValidPrefixData() && aData.hasValidPrefixData() && tData.mMaterial.mMaterial == aData.mMaterial.mMaterial && this.mPartialUnits < tData.mPrefix.mAmount) {
            return tData.mPrefix.contains(TD.Prefix.DUST_BASED) && aData.mPrefix.contains(TD.Prefix.DUST_BASED) || tData.mPrefix.contains(TD.Prefix.INGOT_BASED) && aData.mPrefix.contains(TD.Prefix.INGOT_BASED);
        }
        return false;
    }

    public boolean isFaceVisible() {
        return CS.SIDES_HORIZONTAL[this.mFacing] && (!this.hasCovers() || this.mCovers.mBehaviours[this.mFacing] == null || !this.mCovers.mBehaviours[this.mFacing].isOpaque(this.mFacing, this.mCovers));
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        int tStacksize = this.slotHas(1) ? this.slot((int)1).field_77994_a : -1;
        short tMeta = this.slotHas(1) ? UT.Stacks.meta(this.slot(1)) : (short)0;
        short tID = UT.Stacks.id(this.slot(1));
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mMode, UT.Code.toByteS(tID, 0), UT.Code.toByteS(tID, 1), UT.Code.toByteS(tMeta, 0), UT.Code.toByteS(tMeta, 1), UT.Code.toByteI(tStacksize, 0), UT.Code.toByteI(tStacksize, 1), UT.Code.toByteI(tStacksize, 2), UT.Code.toByteI(tStacksize, 3)) : this.getClientDataPacketInteger(aSendAll, tStacksize);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        this.mMode = aData[4];
        this.slot(1, UT.Stacks.make(UT.Code.combine(aData[5], aData[6]), (long)UT.Code.combine(aData[9], aData[10], aData[11], aData[12]), (long)UT.Code.combine(aData[7], aData[8])));
        return true;
    }

    @Override
    public boolean receiveDataInteger(int aData, INetworkHandler aNetworkHandler) {
        if (aData < 0) {
            this.slot(1, CS.NI);
        } else if (this.slotHas(1)) {
            this.slot((int)1).field_77994_a = aData;
        }
        return true;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        this.slot(1, CS.NI);
        super.onExploded(aExplosion);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public int func_70297_j_() {
        return Math.min(this.slotHas(1) ? this.getMaxContent() - this.slot((int)1).field_77994_a : this.getMaxContent(), 64);
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 && (!this.slotHas(1) || this.slot((int)1).field_77994_a < this.getMaxContent() && this.allowInsertion(aStack));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 || this.slotHas(1) && this.slot((int)1).field_77994_a > 0;
    }

    @Override
    public boolean allowZeroStacks(int aSlot) {
        return aSlot == 1 && ((this.mMode & CS.B[1]) == 0 || this.mPartialUnits > 0L);
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.SIDES_BOTTOM[aSide]) {
            this.updateInventory();
        }
    }

    @Override
    public long getAmountOfItemsInConnectedInventory(byte aSide, ItemStack aStack, long aStopCountingAtThisNumber) {
        return this.slotHas(1) && UT.Stacks.equal(this.slot(1), aStack) ? (long)this.slot((int)1).field_77994_a : 0L;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.slotHas(1) ? (long)this.slot((int)1).field_77994_a : 0L;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mMaxStorage;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean breakBlock() {
        OreDictItemData tData;
        if (this.isServerSide() && this.mPartialUnits > 0L && (tData = OM.data(this.slot(1))) != null && tData.hasValidPrefixData()) {
            ItemStack tStack;
            ItemStack itemStack = tStack = tData.mPrefix.contains(TD.Prefix.INGOT_BASED) ? OM.ingot(tData.mMaterial.mMaterial, this.mPartialUnits) : OM.dust(tData.mMaterial.mMaterial, this.mPartialUnits);
            if (tStack != null) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, tStack));
            }
        }
        return super.breakBlock();
    }

    @Override
    public int addStackToConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated) {
        if (!aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated || this.slotHas(1)) {
            ItemStack tStack = this.insertItems(aStack, false);
            if (tStack == null) {
                return aStack.field_77994_a;
            }
            if (tStack.field_77994_a < aStack.field_77994_a) {
                return aStack.field_77994_a - tStack.field_77994_a;
            }
        }
        return 0;
    }

    @Override
    public int removeStackFromConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (this.slotHas(1) && UT.Stacks.equal(this.slot(1), aStack)) {
            if (aOnlyRemoveIfItCanRemoveAllAtOnce && this.slot((int)1).field_77994_a < aStack.field_77994_a) {
                return 0;
            }
            int tAmount = Math.min(aStack.field_77994_a, this.slot((int)1).field_77994_a);
            this.slot((int)1).field_77994_a -= tAmount;
            if ((this.mMode & CS.B[1]) != 0 && this.slot((int)1).field_77994_a <= 0 && this.mPartialUnits <= 0L) {
                this.slot(1, CS.NI);
                this.updateClientData();
            }
            this.updateInventory();
            return tAmount;
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistrationFirstClient(MultiTileEntityRegistry aRegistry, short aID) {
        ClientRegistry.bindTileEntitySpecialRenderer(this.getClass(), (TileEntitySpecialRenderer)MultiTileEntityRendererMassStorage.INSTANCE);
    }

    static {
        LH.add("gt.multitileentity.massstorage.tooltip.1", "Can store Items of one Type, Capacity: ");
        LH.add("gt.multitileentity.massstorage.tooltip.2", "Can be used adjacent to Advanced Crafting Tables");
        ACCESSIBLE_SLOTS = new int[]{0, 1};
    }

    @SideOnly(value=Side.CLIENT)
    public static class MultiTileEntityRendererMassStorage
    extends TileEntitySpecialRenderer {
        public static MultiTileEntityRendererMassStorage INSTANCE = new MultiTileEntityRendererMassStorage();

        public void func_147500_a(TileEntity aTileEntity, double aX, double aY, double aZ, float aPartialTick) {
            if (aTileEntity instanceof MultiTileEntityMassStorage && ((MultiTileEntityMassStorage)aTileEntity).slotHas(1) && ((MultiTileEntityMassStorage)aTileEntity).isFaceVisible()) {
                MultiTileEntityMassStorage tTileEntity = (MultiTileEntityMassStorage)aTileEntity;
                boolean tBlend = GL11.glGetBoolean((int)3042);
                boolean tLight = GL11.glGetBoolean((int)2896);
                int tTexIndex = GL11.glGetInteger((int)32873);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(aX + 0.5 + (double)CS.OFFSETS_X[tTileEntity.mFacing] * 0.501 - (double)CS.OFFSETS_Z[tTileEntity.mFacing] * 0.25), (double)(aY + 0.625), (double)(aZ + 0.5 + (double)CS.OFFSETS_Z[tTileEntity.mFacing] * 0.501 + (double)CS.OFFSETS_X[tTileEntity.mFacing] * 0.25));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(CS.COMPASS_FROM_SIDE[tTileEntity.mFacing] * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.00390625f, (float)0.00390625f, (float)-1.0E-4f);
                GL11.glScalef((float)8.0f, (float)8.0f, (float)1.0f);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                try {
                    if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)RenderHelper.mRenderBlocks, (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)tTileEntity.slot(1), (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                        RenderHelper.renderItemIntoGUI(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, tTileEntity.slot(1), 0, 0, false);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                GL11.glPopMatrix();
                if (tBlend) {
                    GL11.glEnable((int)3042);
                } else {
                    GL11.glDisable((int)3042);
                }
                if (tLight) {
                    GL11.glEnable((int)2896);
                } else {
                    GL11.glDisable((int)2896);
                }
                GL11.glBindTexture((int)3553, (int)tTexIndex);
            }
        }
    }
}

