/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class MultiTileEntityHopper
extends TileEntityBase09FacingSingle
implements ITileEntityAdjacentInventoryUpdatable {
    public byte mMode = 0;
    public boolean mCheckNextTick = true;
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mMode = aNBT.func_74771_c("gt.mode");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.func_74774_a("gt.mode", this.mMode);
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.hopper.tooltip.1") + this.func_70302_i_());
        if (this.mMode > 0) {
            aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.hopper.tooltip.2") + this.mMode);
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
        if (this.isServerSide() && CS.SIDES_BOTTOM_HORIZONTAL[this.mFacing]) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityConnector && CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), TD.Connectors.ALL_ITEM_TRANSPORT)) {
                ((ITileEntityConnector)tDelegator.mTileEntity).connect(tDelegator.mSideOfTileEntity, true);
            }
        }
        return true;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("screwdriver")) {
            if (aPlayer != null && aPlayer.func_70093_af()) {
                this.mMode = (byte)(this.mMode - 1);
                if (this.mMode < 0) {
                    this.mMode = (byte)64;
                }
            } else {
                this.mMode = (byte)(this.mMode + 1);
                if (this.mMode > 64) {
                    this.mMode = 0;
                }
            }
            aChatReturn.add(this.mMode <= 0 ? "Uses variable Stacksizes" : "Emits exact Stacksize of: " + this.mMode);
            this.updateClientData();
            return 200L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mMode <= 0 ? "Uses variable Stacksizes" : "Emits exact Stacksize of: " + this.mMode);
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && (aTimer % 64L == 32L || this.mInventoryChanged || this.mCheckNextTick) && !this.hasRedstoneIncoming()) {
            List tList;
            DelegatorTileEntity<IInventory> tDelegator;
            this.mCheckNextTick = false;
            int tMovedItems = 0;
            if (!CS.SIDES_TOP[this.mFacing] && !this.invempty()) {
                byte tMoved;
                tDelegator = this.getAdjacentInventory(this.mFacing);
                if (tDelegator.mTileEntity == null && tDelegator.getBlock() instanceof BlockRailBase && (tList = this.field_145850_b.func_94576_a(null, AxisAlignedBB.func_72330_a((double)tDelegator.mX, (double)tDelegator.mY, (double)tDelegator.mZ, (double)(tDelegator.mX + 1), (double)(tDelegator.mY + 1), (double)(tDelegator.mZ + 1)), IEntitySelector.field_96566_b)) != null && !tList.isEmpty()) {
                    tDelegator = new DelegatorTileEntity<IInventory>((IInventory)tList.get(0), tDelegator);
                }
                while (tMovedItems + (this.mMode <= 0 ? (byte)1 : this.mMode) <= 64 && (tMoved = UT.Inventories.moveOneItemStack(this, tDelegator, this.mFacing, tDelegator.mSideOfTileEntity, null, false, 64, 1, this.mMode <= 0 ? 64 - tMovedItems : this.mMode, this.mMode <= 0 ? (byte)1 : this.mMode)) > 0) {
                    tMovedItems += tMoved;
                }
            }
            if (tMovedItems <= 0) {
                tDelegator = this.getAdjacentInventory((byte)1);
                if (tDelegator.mTileEntity == null && tDelegator.getBlock() instanceof BlockRailBase && (tList = this.field_145850_b.func_94576_a(null, AxisAlignedBB.func_72330_a((double)tDelegator.mX, (double)tDelegator.mY, (double)tDelegator.mZ, (double)(tDelegator.mX + 1), (double)(tDelegator.mY + 1), (double)(tDelegator.mZ + 1)), IEntitySelector.field_96566_b)) != null && !tList.isEmpty()) {
                    tDelegator = new DelegatorTileEntity<IInventory>((IInventory)tList.get(0), tDelegator);
                }
                if (tDelegator.mTileEntity != null) {
                    tMovedItems += UT.Inventories.moveOneItemStack(tDelegator.mTileEntity, this, tDelegator.mSideOfTileEntity, (byte)1, null, false, 64, 1, 64, 1);
                } else if (!UT.Worlds.isVisuallyOpaque(tDelegator.getWorld(), tDelegator.getX(), tDelegator.getY(), tDelegator.getZ(), false, true)) {
                    int j = this.func_70302_i_();
                    for (int i = 0; i < j; ++i) {
                        if (this.slotHas(i)) continue;
                        this.slot(i, UT.Worlds.suckOneItemStackAt(tDelegator.getWorld(), tDelegator.getX(), tDelegator.getY(), tDelegator.getZ(), 1.0, 1.0, 1.0));
                        if (!this.slotHas(i)) break;
                        tMovedItems += this.slot((int)i).field_77994_a;
                        this.updateInventory();
                        break;
                    }
                }
            }
            if (this.mInventoryChanged) {
                int k = this.func_70302_i_();
                int l = this.func_70297_j_();
                block2: for (int i = 0; i < k; ++i) {
                    for (int j = i + 1; j < k; ++j) {
                        if (!this.slotHas(j)) continue;
                        int tMaxSize = Math.min(l, this.slot(j).func_77976_d());
                        if (this.slotHas(i)) {
                            if (this.slot((int)i).field_77994_a >= tMaxSize || !UT.Stacks.equal(this.slot(i), this.slot(j))) continue;
                            tMovedItems += UT.Inventories.moveStackFromSlotAToSlotB(this, this, j, i, 64, 1, 64, 1);
                            if (this.slot((int)i).field_77994_a < tMaxSize) continue;
                            continue block2;
                        }
                        tMovedItems += UT.Inventories.moveStackFromSlotAToSlotB(this, this, j, i, 64, 1, 64, 1);
                        if (this.slotHas(i) && this.slot((int)i).field_77994_a >= tMaxSize) continue block2;
                    }
                }
            }
            if (tMovedItems > 0) {
                this.mCheckNextTick = true;
                for (byte tSide : CS.ALL_SIDES_BUT_TOP) {
                    if (tSide == this.mFacing) continue;
                    DelegatorTileEntity<TileEntity> tDelegatorUpdate = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegatorUpdate.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegatorUpdate.mTileEntity).adjacentInventoryUpdated(tDelegatorUpdate.mSideOfTileEntity, this);
                }
            }
        }
    }

    @Override
    public byte getVisualData() {
        return this.mMode;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mMode = aData;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_NEG[0] : CS.PIXELS_NEG[8];
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PIXELS_NEG[2] : CS.PIXELS_NEG[8];
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(this.func_70302_i_());
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return this.mMode <= 0 ? 64 : this.mMode * Math.max(1, 64 / this.mMode);
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return this.mMode <= 0 ? 64 : this.mMode * Math.max(1, 64 / this.mMode);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.SIDES_TOP[aSide] || aSide == this.mFacing) {
            this.mCheckNextTick = true;
        }
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return CS.SIDES_TOP[this.mFacing] ? 2 : 3;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[10], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[4], CS.PIXELS_POS[4], CS.PIXELS_POS[4], CS.PIXELS_NEG[4], CS.PIXELS_NEG[6], CS.PIXELS_NEG[4]);
                return true;
            }
            case 2: {
                switch (this.mFacing) {
                    case 0: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[0], CS.PIXELS_POS[6], CS.PIXELS_NEG[6], CS.PIXELS_NEG[12], CS.PIXELS_NEG[6]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[4], CS.PIXELS_POS[0], CS.PIXELS_NEG[6], CS.PIXELS_NEG[8], CS.PIXELS_NEG[12]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PIXELS_POS[6], CS.PIXELS_POS[4], CS.PIXELS_POS[12], CS.PIXELS_NEG[6], CS.PIXELS_NEG[8], CS.PIXELS_NEG[0]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[4], CS.PIXELS_POS[6], CS.PIXELS_NEG[12], CS.PIXELS_NEG[8], CS.PIXELS_NEG[6]);
                        return true;
                    }
                    case 5: {
                        aBlock.func_149676_a(CS.PIXELS_POS[12], CS.PIXELS_POS[4], CS.PIXELS_POS[6], CS.PIXELS_NEG[0], CS.PIXELS_NEG[8], CS.PIXELS_NEG[6]);
                        return true;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return (aRenderPass == 1 ? !CS.SIDES_TOP[aSide] : aShouldSideBeRendered[aSide] || aRenderPass == 0 && CS.SIDES_BOTTOM[aSide] || aRenderPass == 2 && aSide != this.mFacing) ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.hopper";
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.field_71071_by, this);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this);
    }

    static {
        LH.add("gt.multitileentity.hopper.tooltip.1", "Slot Count: ");
        LH.add("gt.multitileentity.hopper.tooltip.2", "Specified Stacksize: ");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/automation/hopper/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/automation/hopper/colored/top"), new Textures.BlockIcons.CustomIcon("machines/automation/hopper/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/automation/hopper/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/automation/hopper/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/automation/hopper/overlay/side")};
    }
}

