/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityEnderGarbageDump
extends TileEntityBase07Paintable
implements IFluidHandler,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnServerLoad,
IMultiTileEntity.IMTE_OnServerSave {
    public static ArrayListNoNulls<ItemStack> GARBAGE_ITEMS = new ArrayListNoNulls();
    public static ArrayListNoNulls<FluidTank> GARBAGE_FLUIDS = new ArrayListNoNulls();
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void onServerSave(File aSaveLocation) {
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "endergarbage.items.dat");
        if (!aTargetFile.exists()) {
            try {
                aTargetFile.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        NBTTagCompound aNBT = new NBTTagCompound();
        for (int i = 0; i < GARBAGE_ITEMS.size(); ++i) {
            UT.Stacks.save(aNBT, "" + i, (ItemStack)GARBAGE_ITEMS.get(i));
        }
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)aNBT, (File)aTargetFile);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        aTargetFile = new File(new File(aSaveLocation, "gregtech"), "endergarbage.fluids.dat");
        if (!aTargetFile.exists()) {
            try {
                aTargetFile.createNewFile();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        aNBT = new NBTTagCompound();
        for (int i = 0; i < GARBAGE_FLUIDS.size(); ++i) {
            aNBT.func_74782_a("" + i, (NBTBase)((FluidTank)GARBAGE_FLUIDS.get(i)).writeToNBT(new NBTTagCompound()));
        }
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)aNBT, (File)aTargetFile);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    @Override
    public void onServerLoad(File aSaveLocation) {
        NBTTagCompound aNBT;
        GARBAGE_ITEMS.clear();
        File aTargetFile = new File(new File(aSaveLocation, "gregtech"), "endergarbage.items.dat");
        if (aTargetFile.exists()) {
            aNBT = new NBTTagCompound();
            try {
                aNBT = CompressedStreamTools.func_74797_a((File)aTargetFile);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            for (int i = 0; i < Integer.MAX_VALUE && aNBT.func_74764_b("" + i); ++i) {
                ItemStack aStack = UT.Stacks.load(aNBT, "" + i);
                if (aStack == null || aStack.field_77994_a <= 0) continue;
                GARBAGE_ITEMS.add(aStack);
            }
        }
        GARBAGE_FLUIDS.clear();
        aTargetFile = new File(new File(aSaveLocation, "gregtech"), "endergarbage.fluids.dat");
        if (aTargetFile.exists()) {
            aNBT = new NBTTagCompound();
            try {
                aNBT = CompressedStreamTools.func_74797_a((File)aTargetFile);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            for (int i = 0; i < Integer.MAX_VALUE && aNBT.func_74764_b("" + i); ++i) {
                FluidTank tTank = new FluidTank(Integer.MAX_VALUE);
                tTank.readFromNBT(aNBT.func_74775_l("" + i));
                if (tTank.getFluidAmount() <= 0) continue;
                GARBAGE_FLUIDS.add(tTank);
            }
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.2"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.dump.tooltip.3"));
        aList.add(LH.Chat.RED + LH.get("gt.lang.admin.only.creation"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            DelegatorTileEntity<TileEntity> tDelegate = this.getAdjacentTileEntity((byte)0, true, false);
            if (!GARBAGE_ITEMS.isEmpty()) {
                UT.Inventories.moveOneItemStack(this, tDelegate, (byte)6, tDelegate.mSideOfTileEntity, null, false, 64, 1, 64, 1);
            }
            if (tDelegate.mTileEntity instanceof IFluidHandler) {
                for (FluidTank tTank : GARBAGE_FLUIDS) {
                    FluidStack tDrained = tTank.drain(Integer.MAX_VALUE, false);
                    if (tDrained == null) continue;
                    tDrained.amount = ((IFluidHandler)tDelegate.mTileEntity).fill(CS.FORGE_DIR[tDelegate.mSideOfTileEntity], tDrained, false);
                    if (tDrained.amount <= 0 || ((IFluidHandler)tDelegate.mTileEntity).fill(CS.FORGE_DIR[tDelegate.mSideOfTileEntity], tTank.drain(tDrained.amount, true), true) <= 0) continue;
                    break;
                }
            }
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < GARBAGE_FLUIDS.size(); ++i) {
                if (((FluidTank)GARBAGE_FLUIDS.get(i)).getFluidAmount() <= 0) continue;
                return (IFluidTank)GARBAGE_FLUIDS.get(i);
            }
        } else {
            for (int i = 0; i < GARBAGE_FLUIDS.size(); ++i) {
                if (!UT.Fluids.equal(aFluidToDrain, ((FluidTank)GARBAGE_FLUIDS.get(i)).getFluid(), false)) continue;
                return (IFluidTank)GARBAGE_FLUIDS.get(i);
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return (IFluidTank[])GARBAGE_FLUIDS.toArray(new FluidTank[GARBAGE_FLUIDS.size()]);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return new ArrayListNoNulls<ItemStack>();
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        this.updateInventory();
        ItemStack tStack = (ItemStack)GARBAGE_ITEMS.get(aSlot);
        if (tStack == null) {
            return null;
        }
        if (tStack.field_77994_a <= aDecrement) {
            ItemStack rStack = UT.Stacks.copy(tStack);
            tStack.field_77994_a = 0;
            return rStack;
        }
        return tStack.func_77979_a(aDecrement);
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        return (ItemStack)GARBAGE_ITEMS.get(aSlot);
    }

    @Override
    public int func_70302_i_() {
        return GARBAGE_ITEMS.size();
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        this.updateInventory();
        GARBAGE_ITEMS.set(aSlot, OM.get(aStack));
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.ender.garbage.dump";
    }

    @Override
    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return CS.ZL_ITEMSTACK;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    static {
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.1", "This is where all the Trash Bin Items & Fluids go to");
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.2", "Accesses the Garbage Dimension to retrieve Trash.");
        LH.add("gt.multitileentity.ender.garbage.dump.tooltip.3", "If used properly, people could for example 'donate' Resources.");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/dump/overlay/side")};
    }
}

