/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.UT;
import gregtech.tileentity.inventories.MultiTileEntityEnderGarbageDump;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityEnderGarbageBin
extends TileEntityBase07Paintable
implements IFluidHandler,
IMultiTileEntity.IMTE_AddToolTips {
    public static IIconContainer[] sColoreds;
    public static IIconContainer[] sOverlays;

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.2"));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.ender.garbage.bin.tooltip.3"));
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer % 100L == 50L && !this.hasRedstoneIncoming()) {
            for (int i = 0; i < 9; ++i) {
                if (!this.slotHas(i)) continue;
                for (ItemStack tGarbage : MultiTileEntityEnderGarbageDump.GARBAGE_ITEMS) {
                    if (!UT.Stacks.equal(this.slot(i), tGarbage)) continue;
                    tGarbage.field_77994_a = UT.Code.bindInt((long)tGarbage.field_77994_a + (long)this.slot((int)i).field_77994_a);
                    this.slot(i, CS.NI);
                    break;
                }
                if (!this.slotHas(i)) continue;
                MultiTileEntityEnderGarbageDump.GARBAGE_ITEMS.add(this.slot(i));
                this.slot(i, CS.NI);
            }
        }
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        int i;
        for (i = 0; i < MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.size(); ++i) {
            if (!UT.Fluids.equal(aFluidToFill, ((FluidTank)MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.get(i)).getFluid(), false)) continue;
            return (IFluidTank)MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.get(i);
        }
        for (i = 0; i < MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.size(); ++i) {
            if (((FluidTank)MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.get(i)).getFluid() != null) continue;
            return (IFluidTank)MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.get(i);
        }
        FluidTank tTank = new FluidTank(Integer.MAX_VALUE);
        MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.add(tTank);
        return tTank;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return (IFluidTank[])MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.toArray(new FluidTank[MultiTileEntityEnderGarbageDump.GARBAGE_FLUIDS.size()]);
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? 0.0f : CS.PIXELS_POS[1];
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_TOP[aSide] ? 1.0f : CS.PIXELS_POS[14];
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return this.getSurfaceSize(aSide);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 2;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[12], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
        } else {
            aBlock.func_149676_a(CS.PIXELS_POS[1], CS.PIXELS_POS[0], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[4], CS.PIXELS_NEG[1]);
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return (aRenderPass == 0 ? aSide == 0 || aShouldSideBeRendered[aSide] : aSide != 1 && (aSide != 0 || aShouldSideBeRendered[aSide])) ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.ender.garbage.bin";
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[9];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.field_71071_by, this, CS.RES_PATH_GUI + "machines/Trash.png");
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this);
    }

    static {
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.1", "Trash Bin deleting Items & Fluids, or moving them to the Servers Garbage Dump");
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.2", "Items & Fluids entering this will be dumped inside the Garbage Dimension");
        LH.add("gt.multitileentity.ender.garbage.bin.tooltip.3", "You can stop this from operating using a simple Redstone Signal");
        sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/colored/side")};
        sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/endergarbage/bin/overlay/side")};
    }
}

