/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.dummies.DummyInventory;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.network.packets.PacketItemStackChat;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.inventories.ITileEntityBookShelf;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class MultiTileEntityBookShelf
extends TileEntityBase09FacingSingle
implements ITileEntityBookShelf,
IMultiTileEntity.IMTE_GetEnchantPowerBonus,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public byte[] mDisplay = new byte[28];
    public byte mRedstoneDelay = 0;
    public IIconContainer mShelfIcon = Textures.BlockIcons.RENDERING_ERROR;
    public String mDungeonLootNameFront = "";
    public String mDungeonLootNameBack = "";
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        short tShelfID;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.dungeonloot.front")) {
            this.mDungeonLootNameFront = aNBT.func_74779_i("gt.dungeonloot.front");
        }
        if (aNBT.func_74764_b("gt.dungeonloot.back")) {
            this.mDungeonLootNameBack = aNBT.func_74779_i("gt.dungeonloot.back");
        }
        if (aNBT.func_74764_b("gt.redstone")) {
            this.mRedstoneDelay = aNBT.func_74771_c("gt.redstone");
        }
        if (aNBT.func_74764_b("gt.texture") && UT.Code.exists(tShelfID = aNBT.func_74765_d("gt.texture"), CS.PlankData.PLANK_ICONS)) {
            this.mShelfIcon = CS.PlankData.PLANK_ICONS[tShelfID];
        }
        if (this.mShelfIcon == null || this.mShelfIcon == Textures.BlockIcons.RENDERING_ERROR) {
            this.mShelfIcon = this.mMaterial.mTextureSetsBlock.get(OP.casingMachine.mIconIndexBlock);
        }
        for (int i = 0; i < 28; ++i) {
            Byte tID;
            Byte by = tID = this.slotHas(i) ? (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i))) : null;
            if ((tID == null || tID == 0) && this.slotHas(i)) {
                tID = (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(UT.Stacks.copyMeta(32767L, this.slot(i))));
            }
            this.mDisplay[i] = tID == null ? (byte)0 : tID;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (UT.Code.stringValid(this.mDungeonLootNameFront)) {
            aNBT.func_74778_a("gt.dungeonloot.front", this.mDungeonLootNameFront);
        }
        if (UT.Code.stringValid(this.mDungeonLootNameBack)) {
            aNBT.func_74778_a("gt.dungeonloot.back", this.mDungeonLootNameBack);
        }
        if (this.mRedstoneDelay != 0) {
            aNBT.func_74774_a("gt.redstone", this.mRedstoneDelay);
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean breakBlock() {
        this.generateDungeonLoot();
        return super.breakBlock();
    }

    protected void generateDungeonLoot() {
        if (this.isServerSide()) {
            int tSlot;
            DummyInventory tDummyInventory;
            if (UT.Code.stringValid(this.mDungeonLootNameFront)) {
                tDummyInventory = new DummyInventory(14);
                WeightedRandomChestContent.func_76293_a((Random)this.field_145850_b.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)this.mDungeonLootNameFront, (Random)this.field_145850_b.field_73012_v), (IInventory)tDummyInventory, (int)ChestGenHooks.getCount((String)this.mDungeonLootNameFront, (Random)this.field_145850_b.field_73012_v));
                for (ItemStack tStack : tDummyInventory.mInventory) {
                    tSlot = this.getRandomNumber(14);
                    if (this.slotHas(tSlot)) continue;
                    if (CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(tStack)) || CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, tStack)))) {
                        this.slot(tSlot, UT.Stacks.amount(1L, tStack));
                        continue;
                    }
                    this.slot(tSlot, this.getRandomNumber(4) != 0 ? UT.Stacks.make(Items.field_151122_aG, 1L, 0L) : UT.Stacks.make(MD.LOSTBOOKS, "randomBook", 1L, 0, UT.Stacks.make(Items.field_151122_aG, 1L, 0L)));
                }
                this.mDungeonLootNameFront = "";
                this.updateInventory();
            }
            if (UT.Code.stringValid(this.mDungeonLootNameBack)) {
                tDummyInventory = new DummyInventory(14);
                WeightedRandomChestContent.func_76293_a((Random)this.field_145850_b.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)this.mDungeonLootNameBack, (Random)this.field_145850_b.field_73012_v), (IInventory)tDummyInventory, (int)ChestGenHooks.getCount((String)this.mDungeonLootNameBack, (Random)this.field_145850_b.field_73012_v));
                for (ItemStack tStack : tDummyInventory.mInventory) {
                    tSlot = 14 + this.getRandomNumber(14);
                    if (this.slotHas(tSlot)) continue;
                    if (CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(tStack)) || CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, tStack)))) {
                        this.slot(tSlot, UT.Stacks.amount(1L, tStack));
                        continue;
                    }
                    this.slot(tSlot, this.getRandomNumber(4) != 0 ? UT.Stacks.make(Items.field_151122_aG, 1L, 0L) : UT.Stacks.make(MD.LOSTBOOKS, "randomBook", 1L, 0, UT.Stacks.make(Items.field_151122_aG, 1L, 0L)));
                }
                this.mDungeonLootNameBack = "";
                this.updateInventory();
            }
        }
    }

    @Override
    public float getEnchantPowerBonus() {
        int tNormalBooks = 0;
        int tEnchantedBooks = 0;
        for (int i = 0; i < 28; ++i) {
            if (!this.slotHas(i)) continue;
            if (this.slot(i).func_77973_b() == Items.field_151122_aG) {
                ++tNormalBooks;
                continue;
            }
            if (this.slot(i).func_77973_b() != Items.field_151134_bR) continue;
            ++tEnchantedBooks;
        }
        return (tNormalBooks + tEnchantedBooks * 2) / 14;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (aTimer % 300L == 0L && (UT.Code.stringValid(this.mDungeonLootNameFront) || UT.Code.stringValid(this.mDungeonLootNameBack)) && !this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - 32.0f), (double)((float)this.field_145848_d - 32.0f), (double)((float)this.field_145849_e - 32.0f), (double)((float)(this.field_145851_c + 1) + 32.0f), (double)((float)(this.field_145848_d + 1) + 32.0f), (double)((float)(this.field_145849_e + 1) + 32.0f))).isEmpty()) {
                this.generateDungeonLoot();
            }
            if (this.mRedstoneDelay > 0 && (this.mRedstoneDelay = (byte)(this.mRedstoneDelay - 1)) == 0) {
                this.causeBlockUpdate();
            }
            if (this.mInventoryChanged) {
                for (int i = 0; i < 28; ++i) {
                    Byte tID;
                    Byte by = tID = this.slotHas(i) ? (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i))) : null;
                    if ((tID == null || tID == 0) && this.slotHas(i)) {
                        tID = (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(UT.Stacks.copyMeta(32767L, this.slot(i))));
                    }
                    if (tID == null) {
                        tID = 0;
                    }
                    if (tID == this.mDisplay[i]) continue;
                    this.mDisplay[i] = tID;
                    this.updateClientData();
                }
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("magnifyingglass") && aPlayer instanceof EntityPlayerMP && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] >= CS.PIXELS_POS[1] && tCoords[0] <= CS.PIXELS_NEG[1] && tCoords[1] >= CS.PIXELS_POS[1] && tCoords[1] <= CS.PIXELS_NEG[1]) {
            int tIndex = -1;
            if (aSide == this.mFacing) {
                tIndex = (tCoords[1] < CS.PIXELS_POS[8] ? 6 : 13) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PIXELS_POS[1])));
            }
            if (aSide == CS.OPPOSITES[this.mFacing]) {
                tIndex = (tCoords[1] < CS.PIXELS_POS[8] ? 20 : 27) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PIXELS_POS[1])));
            }
            if (tIndex >= 0 && this.slotHas(tIndex)) {
                CS.NW_API.sendToPlayer(new PacketItemStackChat(this.slot(tIndex)), (EntityPlayerMP)aPlayer);
                return 1L;
            }
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.generateDungeonLoot();
        }
        if ((tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] >= CS.PIXELS_POS[1] && tCoords[0] <= CS.PIXELS_NEG[1] && tCoords[1] >= CS.PIXELS_POS[1] && tCoords[1] <= CS.PIXELS_NEG[1]) {
            if (aSide == this.mFacing) {
                if (this.isServerSide()) {
                    this.switchBooks(aPlayer, (tCoords[1] < CS.PIXELS_POS[8] ? 6 : 13) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PIXELS_POS[1]))));
                }
                return true;
            }
            if (aSide == CS.OPPOSITES[this.mFacing]) {
                if (this.isServerSide()) {
                    this.switchBooks(aPlayer, (tCoords[1] < CS.PIXELS_POS[8] ? 20 : 27) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PIXELS_POS[1]))));
                }
                return true;
            }
        }
        return false;
    }

    private boolean switchBooks(EntityPlayer aPlayer, int aSlot) {
        if (this.slotHas(aSlot)) {
            if (!aPlayer.func_70093_af()) {
                if (UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150430_aB, 1L, 32767L)) || UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150471_bO, 1L, 32767L))) {
                    this.mRedstoneDelay = (byte)120;
                    this.causeBlockUpdate();
                    this.playClick();
                    return true;
                }
                if (UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150442_at, 1L, 32767L)) || UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150429_aA, 1L, 32767L))) {
                    this.mRedstoneDelay = this.mRedstoneDelay == 0 ? (byte)-1 : (byte)0;
                    this.causeBlockUpdate();
                    this.playClick();
                    return true;
                }
            }
            if (UT.Inventories.addStackToPlayerInventory(aPlayer, this.slot(aSlot), true)) {
                this.slot(aSlot, CS.NI);
                this.updateInventory();
                return true;
            }
            return false;
        }
        ItemStack tStack = aPlayer.func_71045_bC();
        if (tStack != null && (CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(tStack)) || CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, tStack))))) {
            this.slot(aSlot, UT.Stacks.amount(1L, tStack));
            this.updateInventory();
            --tStack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (byte)(this.mRedstoneDelay == 0 ? 0 : 15);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mDisplay[0], this.mDisplay[1], this.mDisplay[2], this.mDisplay[3], this.mDisplay[4], this.mDisplay[5], this.mDisplay[6], this.mDisplay[7], this.mDisplay[8], this.mDisplay[9], this.mDisplay[10], this.mDisplay[11], this.mDisplay[12], this.mDisplay[13], this.mDisplay[14], this.mDisplay[15], this.mDisplay[16], this.mDisplay[17], this.mDisplay[18], this.mDisplay[19], this.mDisplay[20], this.mDisplay[21], this.mDisplay[22], this.mDisplay[23], this.mDisplay[24], this.mDisplay[25], this.mDisplay[26], this.mDisplay[27]);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        for (int i = 0; i < 28; ++i) {
            this.mDisplay[i] = aData[i + 4];
        }
        return true;
    }

    @Override
    public boolean isCoverSurface(byte aSide, int aRenderpass) {
        return aRenderpass == 0 && super.isCoverSurface(aSide);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 35;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass < 7 || this.mDisplay[aRenderPass - 7] != 0 && aShouldSideBeRendered[aRenderPass < 21 ? this.mFacing : CS.OPPOSITES[this.mFacing]];
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return false;
            }
            case 1: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[15], CS.PIXELS_NEG[0]);
                return true;
            }
            case 2: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[15], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]);
                return true;
            }
            case 3: {
                aBlock.func_149676_a(CS.PIXELS_POS[0], CS.PIXELS_POS[1], CS.PIXELS_POS[0], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 15 : 0], CS.PIXELS_NEG[1], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0]);
                return true;
            }
            case 4: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 15 : 0], CS.PIXELS_POS[1], CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[1], CS.PIXELS_NEG[0]);
                return true;
            }
            case 5: {
                aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PIXELS_POS[1], CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1]);
                return true;
            }
            case 6: {
                aBlock.func_149676_a(CS.PIXELS_POS[1], CS.PIXELS_POS[7], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[7], CS.PIXELS_NEG[1]);
                return true;
            }
        }
        aRenderPass -= 7;
        switch (this.mFacing) {
            case 5: {
                if (aRenderPass < 7) {
                    aBlock.func_149676_a(CS.PIXELS_POS[9], CS.PIXELS_POS[9], CS.PIXELS_NEG[15 - aRenderPass * 2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[13 - aRenderPass * 2]);
                    return true;
                }
                if (aRenderPass < 14) {
                    aBlock.func_149676_a(CS.PIXELS_POS[9], CS.PIXELS_POS[1], CS.PIXELS_NEG[15 - (aRenderPass %= 7) * 2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[13 - aRenderPass * 2]);
                    return true;
                }
                if (aRenderPass < 21) {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[9], CS.PIXELS_NEG[3 + (aRenderPass %= 7) * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1 + aRenderPass * 2]);
                    return true;
                }
                aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[1], CS.PIXELS_NEG[3 + (aRenderPass %= 7) * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[9], CS.PIXELS_NEG[1 + aRenderPass * 2]);
                return true;
            }
            case 4: {
                if (aRenderPass < 7) {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[9], CS.PIXELS_POS[13 - aRenderPass * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[1], CS.PIXELS_POS[15 - aRenderPass * 2]);
                    return true;
                }
                if (aRenderPass < 14) {
                    aBlock.func_149676_a(CS.PIXELS_POS[2], CS.PIXELS_POS[1], CS.PIXELS_POS[13 - (aRenderPass %= 7) * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[9], CS.PIXELS_POS[15 - aRenderPass * 2]);
                    return true;
                }
                if (aRenderPass < 21) {
                    aBlock.func_149676_a(CS.PIXELS_POS[9], CS.PIXELS_POS[9], CS.PIXELS_POS[1 + (aRenderPass %= 7) * 2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[1], CS.PIXELS_POS[3 + aRenderPass * 2]);
                    return true;
                }
                aBlock.func_149676_a(CS.PIXELS_POS[9], CS.PIXELS_POS[1], CS.PIXELS_POS[1 + (aRenderPass %= 7) * 2], CS.PIXELS_NEG[2], CS.PIXELS_NEG[9], CS.PIXELS_POS[3 + aRenderPass * 2]);
                return true;
            }
            case 3: {
                if (aRenderPass < 7) {
                    aBlock.func_149676_a(CS.PIXELS_NEG[3 + aRenderPass * 2], CS.PIXELS_POS[9], CS.PIXELS_POS[9], CS.PIXELS_NEG[1 + aRenderPass * 2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[2]);
                    return true;
                }
                if (aRenderPass < 14) {
                    aBlock.func_149676_a(CS.PIXELS_NEG[3 + (aRenderPass %= 7) * 2], CS.PIXELS_POS[1], CS.PIXELS_POS[9], CS.PIXELS_NEG[1 + aRenderPass * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[2]);
                    return true;
                }
                if (aRenderPass < 21) {
                    aBlock.func_149676_a(CS.PIXELS_NEG[15 - (aRenderPass %= 7) * 2], CS.PIXELS_POS[9], CS.PIXELS_POS[2], CS.PIXELS_NEG[13 - aRenderPass * 2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[9]);
                    return true;
                }
                aBlock.func_149676_a(CS.PIXELS_NEG[15 - (aRenderPass %= 7) * 2], CS.PIXELS_POS[1], CS.PIXELS_POS[2], CS.PIXELS_NEG[13 - aRenderPass * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[9]);
                return true;
            }
            case 2: {
                if (aRenderPass < 7) {
                    aBlock.func_149676_a(CS.PIXELS_POS[1 + aRenderPass * 2], CS.PIXELS_POS[9], CS.PIXELS_POS[2], CS.PIXELS_POS[3 + aRenderPass * 2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[9]);
                    return true;
                }
                if (aRenderPass < 14) {
                    aBlock.func_149676_a(CS.PIXELS_POS[1 + (aRenderPass %= 7) * 2], CS.PIXELS_POS[1], CS.PIXELS_POS[2], CS.PIXELS_POS[3 + aRenderPass * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[9]);
                    return true;
                }
                if (aRenderPass < 21) {
                    aBlock.func_149676_a(CS.PIXELS_POS[13 - (aRenderPass %= 7) * 2], CS.PIXELS_POS[9], CS.PIXELS_POS[9], CS.PIXELS_POS[15 - aRenderPass * 2], CS.PIXELS_NEG[1], CS.PIXELS_NEG[2]);
                    return true;
                }
                aBlock.func_149676_a(CS.PIXELS_POS[13 - (aRenderPass %= 7) * 2], CS.PIXELS_POS[1], CS.PIXELS_POS[9], CS.PIXELS_POS[15 - aRenderPass * 2], CS.PIXELS_NEG[9], CS.PIXELS_NEG[2]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < 7) {
            if (CS.ALONG_AXIS[aSide][this.mFacing] && !aShouldSideBeRendered[aSide]) {
                return null;
            }
            switch (aRenderPass) {
                case 0: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || !aShouldSideBeRendered[aSide] ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa);
                }
                case 1: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_TOP[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa) : null;
                }
                case 2: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_BOTTOM[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa) : null;
                }
                case 3: {
                    return aSide == (CS.SIDES_AXIS_Z[this.mFacing] ? (byte)4 : 2) ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa);
                }
                case 4: {
                    return aSide == (CS.SIDES_AXIS_Z[this.mFacing] ? (byte)5 : 3) ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa);
                }
                case 5: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa) : null;
                }
                case 6: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_VERTICAL[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa) : null;
                }
            }
        }
        if (CS.SIDES_VERTICAL[aSide] || aSide == (aRenderPass < 21 ? CS.OPPOSITES[this.mFacing] : this.mFacing)) {
            return null;
        }
        return (CS.ALONG_AXIS[aSide][this.mFacing] ? CS.BooksGT.BOOK_TEXTURES_BACK : CS.BooksGT.BOOK_TEXTURES_SIDE)[UT.Code.unsignB(this.mDisplay[aRenderPass - 7])];
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0]), (double)this.field_145848_d, (double)((float)this.field_145849_e + CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0]), (double)((float)this.field_145851_c + CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0]), (double)(this.field_145848_d + 1), (double)((float)this.field_145849_e + CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0]));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(CS.PIXELS_POS[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 0.0f, CS.PIXELS_POS[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0], CS.PIXELS_NEG[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 1.0f, CS.PIXELS_NEG[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0]);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isShelfFace(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return 1;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[28];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return this.slotHas(aSlot) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150347_e, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150429_aA, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150442_at, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150430_aB, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150471_bO, 1L, 32767L));
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return !this.slotHas(aSlot) && (CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(aStack)) || CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, aStack)))) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150347_e, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150430_aB, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150429_aA, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150442_at, 1L, 32767L)) && !UT.Stacks.equal(this.slot(aSlot), UT.Stacks.make(Blocks.field_150471_bO, 1L, 32767L));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.shelf.books";
    }
}

